/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aophelper.manager;

import java.io.File;
import org.jboss.aophelper.core.Action;
import org.jboss.aophelper.core.AopHandler;
import org.jboss.aophelper.core.AopOption;
import org.jboss.aophelper.ui.AopHelperMediator;
import org.jboss.aophelper.ui.run.RunMediator;
import org.jboss.aophelper.util.AopRunCommand;

public class RunManager {
    private RunMediator runMediator = RunMediator.instance();

    public void performAction(Action a, AopOption to) {
        if (a.equals((Object)Action.ADD)) {
            if (to.equals((Object)AopOption.CLASSPATH)) {
                this.addClasspath();
            } else if (to.equals((Object)AopOption.AOPXML)) {
                this.addXml();
            } else if (to.equals((Object)AopOption.SUPPRESS)) {
                this.setSuppress(true);
            } else if (to.equals((Object)AopOption.VERBOSE)) {
                this.setVerbose(true);
            } else if (to.equals((Object)AopOption.NOOPT)) {
                this.setNoopt(true);
            } else if (to.equals((Object)AopOption.LOADTIME)) {
                this.setLoadtime(true);
            }
        } else if (a.equals((Object)Action.REMOVE)) {
            if (to.equals((Object)AopOption.CLASSPATH)) {
                this.removeClasspath();
            } else if (to.equals((Object)AopOption.AOPXML)) {
                this.removeXml();
            } else if (to.equals((Object)AopOption.SUPPRESS)) {
                this.setSuppress(false);
            } else if (to.equals((Object)AopOption.VERBOSE)) {
                this.setVerbose(false);
            } else if (to.equals((Object)AopOption.NOOPT)) {
                this.setNoopt(false);
            } else if (to.equals((Object)AopOption.LOADTIME)) {
                this.setLoadtime(false);
            }
        } else if (a.equals((Object)Action.SET)) {
            if (to.equals((Object)AopOption.WORKINGDIR)) {
                this.setWorkingdir();
            } else if (to.equals((Object)AopOption.EXECLASS)) {
                this.setExecutionClass();
            }
        } else if (a.equals((Object)Action.RUN)) {
            this.run();
        }
    }

    private void addClasspath() {
        File[] files;
        for (File f : files = AopHelperMediator.instance().getMainPane().createFileCooser()) {
            AopHandler.instance().getRun().addClasspath(f.getAbsolutePath());
            this.runMediator.getRunClasspathModel().addRow(f.getAbsolutePath());
        }
    }

    private void removeClasspath() {
        String selected = this.runMediator.getRunClasspathTable().getSelectedItem();
        if (selected != null) {
            AopHandler.instance().getRun().removeClasspath(selected);
            this.runMediator.getRunClasspathModel().removeRow(selected);
            this.runMediator.getRunClasspathTable().clearSelectedItem();
        }
    }

    private void addXml() {
        File[] files;
        for (File f : files = AopHelperMediator.instance().getMainPane().createFileCooser()) {
            AopHandler.instance().getRun().addXml(f.getAbsolutePath());
            this.runMediator.getRunXmlModel().addRow(f.getAbsolutePath());
        }
    }

    private void removeXml() {
        String selected = this.runMediator.getRunXmlTable().getSelectedItem();
        if (selected != null) {
            AopHandler.instance().getRun().removeClasspath(selected);
            this.runMediator.getRunXmlModel().removeRow(selected);
            this.runMediator.getRunXmlTable().clearSelectedItem();
        }
    }

    private void setVerbose(boolean verbose) {
        AopHandler.instance().getRun().setVerbose(verbose);
    }

    private void setSuppress(boolean suppress) {
        AopHandler.instance().getRun().setSuppress(suppress);
    }

    private void setNoopt(boolean noopt) {
        AopHandler.instance().getRun().setNoopt(noopt);
    }

    private void setLoadtime(boolean runtime) {
        AopHandler.instance().getRun().setLoadtime(runtime);
    }

    private void setWorkingdir() {
        File[] files;
        for (File f : files = AopHelperMediator.instance().getMainPane().createFileCooser()) {
            AopHandler.instance().getRun().setWorkingdir(f.getAbsolutePath());
            this.runMediator.getRunOptionsPane().setWorkingDir(f.getAbsolutePath());
        }
    }

    private void setExecutionClass() {
        File[] files;
        for (File f : files = AopHelperMediator.instance().getMainPane().createFileCooser()) {
            AopHandler.instance().getRun().setExecutionClass(f.getAbsolutePath());
            this.runMediator.getRunOptionsPane().setExecutionClass(f.getAbsolutePath());
        }
    }

    private void run() {
        if (AopHandler.instance().getRun().getWorkingdir() == null) {
            AopHelperMediator.instance().getMainPane().displayMessageDialog("Must set working directory");
        } else if (AopHandler.instance().getRun().getExecutionClass() == null) {
            AopHelperMediator.instance().getMainPane().displayMessageDialog("Must set execution class");
        } else {
            AopRunCommand run = new AopRunCommand();
            String[] out = run.execute();
            this.runMediator.getRunOutputPane().setText(out[0]);
            this.runMediator.getRunOutputPane().setError(out[1]);
        }
    }
}

