/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aophelper.ui.compile.classpath;

import org.jboss.aophelper.annotation.AopHelperAction;
import org.jboss.aophelper.core.Action;
import org.jboss.aophelper.core.AopHandler;
import org.jboss.aophelper.core.AopOption;
import org.jboss.aophelper.core.AopState;
import org.jboss.aophelper.ui.GenericEditTableModel;
import org.jboss.aophelper.ui.GenericEditTablePane;
import org.jboss.aophelper.ui.compile.CompileMediator;
import org.jboss.aophelper.ui.compile.classpath.ClasspathTableModel;

public class ClasspathTablePane
extends GenericEditTablePane {
    private static final long serialVersionUID = 1L;
    private ClasspathTableModel tableModel;

    public ClasspathTablePane(String classpaths) {
        this.init();
        this.insertClasspaths(classpaths);
    }

    public void setMediatorTableModel() {
        if (this.tableModel == null) {
            this.tableModel = new ClasspathTableModel();
        }
        CompileMediator.instance().setClasspathModel(this.tableModel);
    }

    public void setMediatorJPanel() {
        CompileMediator.instance().setClasspathTable(this);
    }

    public GenericEditTableModel getTableModel() {
        return this.tableModel;
    }

    @AopHelperAction(action=Action.SET, state=AopState.UNSPECIFIED, option=AopOption.CLASSPATH)
    public void notifyAction() {
    }

    private void insertClasspaths(String classpaths) {
        String[] cp;
        for (String path : cp = classpaths.split(System.getProperty("path.separator"))) {
            this.tableModel.addRow(path);
            AopHandler.instance().getCompile().addClasspath(path);
        }
    }

    public void refresh() {
        this.tableModel.clearRows();
        this.tableModel.addRows(AopHandler.instance().getCompile().getClasspath());
    }
}

