/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aophelper.ui.compile.options;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jboss.aophelper.annotation.AopHelperAction;
import org.jboss.aophelper.core.Action;
import org.jboss.aophelper.core.AopHandler;
import org.jboss.aophelper.core.AopOption;
import org.jboss.aophelper.core.AopState;
import org.jboss.aophelper.ui.compile.CompileMediator;

public class CompileOptionsPane
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JCheckBox verbose;
    private JCheckBox suppress;
    private JCheckBox noopt;
    private JTextField workingdir;

    public CompileOptionsPane() {
        this.init();
    }

    private void init() {
        CompileMediator.instance().setCompileOptionsPane(this);
        this.setLayout(new BorderLayout());
        this.verbose = new JCheckBox("Verbose");
        this.verbose.setSelected(true);
        this.suppress = new JCheckBox("Suppress");
        this.noopt = new JCheckBox("Not optimize");
        this.verbose.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent ie) {
                if (ie.getStateChange() == 1) {
                    CompileOptionsPane.this.addVerbose();
                } else {
                    CompileOptionsPane.this.removeVerbose();
                }
            }
        });
        this.suppress.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent ie) {
                if (ie.getStateChange() == 1) {
                    CompileOptionsPane.this.addSuppress();
                } else {
                    CompileOptionsPane.this.removeSuppress();
                }
            }
        });
        this.noopt.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent ie) {
                if (ie.getStateChange() == 1) {
                    CompileOptionsPane.this.addNoopt();
                } else {
                    CompileOptionsPane.this.removeNoopt();
                }
            }
        });
        JPanel checkBoxPanel = new JPanel(new GridLayout(0, 1));
        JLabel checkHeading = new JLabel("Optional Settings:");
        checkBoxPanel.setBorder(BorderFactory.createLineBorder(Color.black));
        checkBoxPanel.add(checkHeading);
        checkBoxPanel.add(this.verbose);
        checkBoxPanel.add(this.suppress);
        checkBoxPanel.add(this.noopt);
        this.add((Component)checkBoxPanel, "North");
        JButton compile = new JButton("Compile!");
        compile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                System.out.println("COMPILING!");
                CompileOptionsPane.this.compile();
            }
        });
        JPanel workingdirPanel = new JPanel(new FlowLayout());
        this.workingdir = new JTextField("must select the working director", 20);
        this.workingdir.setEditable(false);
        JLabel workingLabel = new JLabel("Set the working directory");
        workingLabel.setLabelFor(this.workingdir);
        workingdirPanel.add(workingLabel);
        workingdirPanel.add(this.workingdir);
        JButton workingdirButton = new JButton("Select working directory");
        workingdirButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                CompileOptionsPane.this.setWorkingDir();
            }
        });
        workingdirPanel.add(workingdirButton);
        this.add((Component)workingdirPanel, "Center");
        this.add((Component)compile, "South");
    }

    @AopHelperAction(action=Action.ADD, state=AopState.COMPILE, option=AopOption.VERBOSE)
    private void addVerbose() {
    }

    @AopHelperAction(action=Action.REMOVE, state=AopState.COMPILE, option=AopOption.VERBOSE)
    private void removeVerbose() {
    }

    @AopHelperAction(action=Action.ADD, state=AopState.COMPILE, option=AopOption.SUPPRESS)
    private void addSuppress() {
    }

    @AopHelperAction(action=Action.REMOVE, state=AopState.COMPILE, option=AopOption.SUPPRESS)
    private void removeSuppress() {
    }

    @AopHelperAction(action=Action.ADD, state=AopState.COMPILE, option=AopOption.NOOPT)
    private void addNoopt() {
    }

    @AopHelperAction(action=Action.REMOVE, state=AopState.COMPILE, option=AopOption.NOOPT)
    private void removeNoopt() {
    }

    @AopHelperAction(action=Action.SET, state=AopState.COMPILE, option=AopOption.WORKINGDIR)
    private void setWorkingDir() {
    }

    @AopHelperAction(action=Action.RUN, state=AopState.COMPILE, option=AopOption.UNSPECIFIED)
    private void compile() {
    }

    public void setWorkingDir(String dir) {
        this.workingdir.setText(dir);
    }

    public void refresh() {
        this.setWorkingDir(AopHandler.instance().getCompile().getWorkingdir());
        this.verbose.setSelected(AopHandler.instance().getCompile().isVerbose());
        this.noopt.setSelected(AopHandler.instance().getCompile().isNoopt());
        this.suppress.setSelected(AopHandler.instance().getCompile().isSuppress());
    }
}

