/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aophelper.util;

import java.io.File;
import java.io.IOException;
import java.util.regex.Pattern;
import org.jboss.aophelper.core.AopHandler;
import org.jboss.aophelper.core.AopRun;
import org.jboss.aophelper.util.CommandUtil;

public class AopRunCommand {
    public String[] execute() {
        String execute = this.setup();
        try {
            String[] emptyArray = new String[]{};
            Process process = Runtime.getRuntime().exec(execute, emptyArray, new File(AopHandler.instance().getRun().getWorkingdir()));
            return CommandUtil.analyzeProcess(process);
        }
        catch (IOException ie) {
            System.out.println("Error while aopcompiling: " + ie.getMessage());
            ie.printStackTrace();
            return null;
        }
    }

    private String setup() {
        AopRun runOptions = AopHandler.instance().getRun();
        StringBuilder execute = new StringBuilder();
        execute.append("java ");
        if (runOptions.isLoadtime()) {
            execute.append(this.getLoadtimePath());
        }
        execute.append(" -cp ").append(this.getClasspath());
        execute.append(" ");
        if (runOptions.isVerbose()) {
            execute.append("-Djboss.aop.verbose=true ");
        }
        if (runOptions.isNoopt()) {
            execute.append("-Djboss.aop.noopt=true ");
        }
        if (runOptions.isSuppress()) {
            execute.append("-Djboss.aop.suppress=true ");
        }
        if (runOptions.getAopXml().size() > 0) {
            execute.append("-Djboss.aop.path=");
            String pathSep = System.getProperty("path.separator");
            StringBuffer xmlPaths = new StringBuffer();
            for (String xml : runOptions.getAopXml()) {
                if (xmlPaths.length() > 0) {
                    xmlPaths.append(pathSep);
                }
                System.out.println("appending xml: " + xml);
                xmlPaths.append(xml);
            }
            execute.append(xmlPaths.toString()).append(" ");
        }
        execute.append(runOptions.calculateCorrectExecutionClass());
        System.out.println("EXECUTING: " + execute.toString());
        return execute.toString();
    }

    private String getLoadtimePath() {
        String pathSeparator = System.getProperty("path.separator");
        String fileSeparator = System.getProperty("file.separator");
        String[] paths = System.getProperty("java.class.path").split(pathSeparator);
        Pattern pattern = Pattern.compile("(\\" + fileSeparator + ".*\\" + fileSeparator + ")++");
        for (String p : paths) {
            String[] splits;
            for (String s : splits = pattern.split(p)) {
                if (!s.contains("jboss-aop")) continue;
                return "-javaagent:" + p;
            }
        }
        return null;
    }

    private String getClasspath() {
        StringBuilder sb = new StringBuilder();
        String pathSeparator = System.getProperty("path.separator");
        for (String path : AopHandler.instance().getRun().getClasspath()) {
            if (sb.length() > 0) {
                sb.append(pathSeparator);
            }
            sb.append(path);
        }
        if (sb.length() > 0) {
            sb.append(pathSeparator);
        }
        sb.append(AopHandler.instance().getRun().getWorkingdir());
        System.out.println("cp: " + sb);
        return sb.toString();
    }
}

