/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aophelper.manager;

import java.io.File;
import org.jboss.aophelper.core.Action;
import org.jboss.aophelper.core.AopHandler;
import org.jboss.aophelper.core.AopOption;
import org.jboss.aophelper.ui.AopHelperMediator;
import org.jboss.aophelper.ui.AopHelperUiMediator;
import org.jboss.aophelper.util.AopCompileCommand;

public class CompileManager {
    private AopHelperUiMediator mediator = AopHelperUiMediator.instance();

    public void performAction(Action a, AopOption to) {
        if (a.equals((Object)Action.ADD)) {
            if (to.equals((Object)AopOption.CLASSPATH)) {
                this.addClasspath();
            } else if (to.equals((Object)AopOption.AOPXML)) {
                this.addXml();
            } else if (to.equals((Object)AopOption.SUPPRESS)) {
                this.setSuppress(true);
            } else if (to.equals((Object)AopOption.VERBOSE)) {
                this.setVerbose(true);
            } else if (to.equals((Object)AopOption.NOOPT)) {
                this.setNoopt(true);
            }
        } else if (a.equals((Object)Action.REMOVE)) {
            if (to.equals((Object)AopOption.CLASSPATH)) {
                this.removeClasspath();
            } else if (to.equals((Object)AopOption.AOPXML)) {
                this.removeXml();
            } else if (to.equals((Object)AopOption.SUPPRESS)) {
                this.setSuppress(false);
            } else if (to.equals((Object)AopOption.VERBOSE)) {
                this.setVerbose(false);
            } else if (to.equals((Object)AopOption.NOOPT)) {
                this.setNoopt(false);
            }
        } else if (a.equals((Object)Action.SET)) {
            if (to.equals((Object)AopOption.WORKINGDIR)) {
                this.setWorkingdir();
            }
        } else if (a.equals((Object)Action.RUN)) {
            this.compile();
        }
    }

    private void addClasspath() {
        File[] files;
        for (File f : files = AopHelperMediator.instance().getMainPane().createFileCooser()) {
            AopHandler.instance().getRun().addClasspath(f.getAbsolutePath());
        }
        this.mediator.refresh();
    }

    private void removeClasspath() {
        String selected = this.mediator.getClasspathTable().getSelectedItem();
        if (selected != null) {
            AopHandler.instance().getRun().removeClasspath(selected);
            this.mediator.clearSelected();
        }
        this.mediator.refresh();
    }

    private void addXml() {
        File[] files;
        for (File f : files = AopHelperMediator.instance().getMainPane().createFileCooser()) {
            AopHandler.instance().getRun().addXml(f.getAbsolutePath());
        }
        this.mediator.refresh();
    }

    private void removeXml() {
        String selected = this.mediator.getXmlTable().getSelectedItem();
        if (selected != null) {
            System.out.println("removing Xml");
            AopHandler.instance().getRun().removeXml(selected);
            this.mediator.clearSelected();
        }
        this.mediator.refresh();
    }

    private void setVerbose(boolean verbose) {
        AopHandler.instance().getRun().setVerbose(verbose);
    }

    private void setSuppress(boolean suppress) {
        AopHandler.instance().getRun().setSuppress(suppress);
    }

    private void setNoopt(boolean noopt) {
        AopHandler.instance().getRun().setNoopt(noopt);
    }

    private void setWorkingdir() {
        File[] files;
        for (File f : files = AopHelperMediator.instance().getMainPane().createFileCooser()) {
            AopHandler.instance().getRun().setWorkingdir(f.getAbsolutePath());
        }
        this.mediator.refresh();
    }

    private void compile() {
        if (AopHandler.instance().getRun().getWorkingdir() == null) {
            AopHelperMediator.instance().getMainPane().displayMessageDialog("Must set working directory");
        } else {
            AopCompileCommand compile = new AopCompileCommand();
            String[] out = compile.execute();
            this.mediator.getOutputPane().setText(out[0]);
            this.mediator.getOutputPane().setError(out[1]);
            System.out.println("output: " + out[0]);
        }
    }
}

