/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aophelper.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import org.jboss.aophelper.ui.GenericEditTableModel;

public abstract class GenericEditTablePane
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JTable table;
    private JScrollPane scrollPane;
    private int selectedRow;
    private String selected;

    public GenericEditTablePane() {
        this.init();
    }

    protected void init() {
        GenericEditTableModel tableModel = this.getTableModel();
        this.table = new JTable(tableModel);
        this.table.setColumnSelectionAllowed(false);
        this.table.setCellSelectionEnabled(false);
        this.table.setRowSelectionAllowed(true);
        this.table.setSelectionMode(0);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.scrollPane = new JScrollPane(this.table);
        this.setLayout(new BorderLayout());
        this.add((Component)this.scrollPane, "Center");
        this.table.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (e.getClickCount() == 1) {
                    Point p = new Point(e.getX(), e.getY());
                    System.out.println("Point: " + p.toString());
                    GenericEditTablePane.this.selectedRow = GenericEditTablePane.this.table.rowAtPoint(new Point(e.getX(), e.getY()));
                    GenericEditTablePane.this.table.setRowSelectionInterval(GenericEditTablePane.this.selectedRow, GenericEditTablePane.this.selectedRow);
                    try {
                        String item = GenericEditTablePane.this.getTableModel().getValueAt(GenericEditTablePane.this.selectedRow, 0);
                        GenericEditTablePane.this.notifyAction();
                        GenericEditTablePane.this.setSelectedItem(item);
                    }
                    catch (Exception ex) {
                        System.err.println("ERROR: when selecting an item");
                    }
                    if (e.getButton() == 3) {
                        // empty if block
                    }
                }
            }
        });
        this.setMediatorTableModel();
        this.setMediatorJPanel();
    }

    public abstract void setMediatorTableModel();

    public abstract void setMediatorJPanel();

    public abstract GenericEditTableModel getTableModel();

    public abstract void notifyAction();

    private void setSelectedItem(String item) {
        System.out.println("selected item is: " + item);
        this.selected = item;
    }

    public String getSelectedItem() {
        return this.selected;
    }

    public void clearSelectedItem() {
        this.selected = null;
    }
}

