/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aophelper.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class CommandUtil {
    public static String getAopPaths() {
        String[] paths;
        StringBuilder aopPaths = new StringBuilder();
        String pathSeparator = System.getProperty("path.separator");
        for (String p : paths = System.getProperty("java.class.path").split(pathSeparator)) {
            if (p.contains("jboss-aop")) {
                aopPaths.append(p).append(pathSeparator);
                continue;
            }
            if (p.contains("trove")) {
                aopPaths.append(p).append(pathSeparator);
                continue;
            }
            if (p.contains("javassist")) {
                aopPaths.append(p).append(pathSeparator);
                continue;
            }
            if (p.contains("jboss-common-core")) {
                aopPaths.append(p).append(pathSeparator);
                continue;
            }
            if (p.contains("jboss-logging-spi")) {
                aopPaths.append(p).append(pathSeparator);
                continue;
            }
            if (p.contains("jboss-container")) {
                aopPaths.append(p).append(pathSeparator);
                continue;
            }
            if (p.contains("jboss-common-logging-spi")) {
                aopPaths.append(p).append(pathSeparator);
                continue;
            }
            if (p.contains("jboss-mdr")) {
                aopPaths.append(p).append(pathSeparator);
                continue;
            }
            if (!p.contains("jboss-reflect")) continue;
            aopPaths.append(p).append(pathSeparator);
        }
        return aopPaths.toString();
    }

    public static String[] analyzeProcess(Process process) {
        String line;
        BufferedReader br = new BufferedReader(new InputStreamReader(process.getInputStream()));
        StringBuffer output = new StringBuffer();
        StringBuffer error = new StringBuffer();
        try {
            while ((line = br.readLine()) != null) {
                System.out.println("line: " + line);
                output.append("\n").append(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        BufferedReader errorBr = new BufferedReader(new InputStreamReader(process.getErrorStream()));
        try {
            while ((line = errorBr.readLine()) != null) {
                System.out.println("ERROR: " + line);
                error.append("\n").append(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("INPUTSTREAM: " + output.toString());
        String[] out = new String[]{output.toString(), error.toString()};
        return out;
    }
}

