/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aophelper.ui.run.options;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jboss.aophelper.annotation.AopHelperAction;
import org.jboss.aophelper.core.Action;
import org.jboss.aophelper.core.AopHandler;
import org.jboss.aophelper.core.AopOption;
import org.jboss.aophelper.core.AopState;
import org.jboss.aophelper.ui.AopHelperUiMediator;

public class RunOptionsPane
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JCheckBox verbose;
    private JCheckBox suppress;
    private JCheckBox noopt;
    private JCheckBox loadtime;
    private JTextField workingdir;
    private JTextField executionClass;
    private JTextField srcPath;

    public RunOptionsPane() {
        this.init();
    }

    private void init() {
        AopHelperUiMediator.instance().setRunOptionsPane(this);
        this.setLayout(new BorderLayout());
        this.verbose = new JCheckBox("Verbose");
        this.verbose.setSelected(true);
        this.suppress = new JCheckBox("Suppress");
        this.noopt = new JCheckBox("Not optimize");
        this.loadtime = new JCheckBox("Instrument classes loadtime");
        this.verbose.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent ie) {
                if (ie.getStateChange() == 1) {
                    RunOptionsPane.this.addVerbose();
                } else {
                    RunOptionsPane.this.removeVerbose();
                }
            }
        });
        this.suppress.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent ie) {
                if (ie.getStateChange() == 1) {
                    RunOptionsPane.this.addSuppress();
                } else {
                    RunOptionsPane.this.removeSuppress();
                }
            }
        });
        this.noopt.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent ie) {
                if (ie.getStateChange() == 1) {
                    RunOptionsPane.this.addNoopt();
                } else {
                    RunOptionsPane.this.removeNoopt();
                }
            }
        });
        this.loadtime.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent ie) {
                if (ie.getStateChange() == 1) {
                    RunOptionsPane.this.setLoadtime();
                } else {
                    RunOptionsPane.this.clearLoadtime();
                }
            }
        });
        JPanel checkBoxPanel = new JPanel(new GridLayout(0, 1));
        JLabel checkHeading = new JLabel("Optional Settings:");
        checkBoxPanel.setBorder(BorderFactory.createLineBorder(Color.black));
        checkBoxPanel.add(checkHeading);
        checkBoxPanel.add(this.verbose);
        checkBoxPanel.add(this.suppress);
        checkBoxPanel.add(this.noopt);
        checkBoxPanel.add(this.loadtime);
        this.add((Component)checkBoxPanel, "North");
        JButton compile = new JButton("Run!");
        compile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                System.out.println("RUNNING!");
                RunOptionsPane.this.run();
            }
        });
        JPanel workingdirPanel = new JPanel(new FlowLayout());
        this.workingdir = new JTextField("must set the working directory", 25);
        this.workingdir.setEditable(false);
        JLabel workingLabel = new JLabel("Set the working directory ");
        workingLabel.setLabelFor(this.workingdir);
        workingdirPanel.add(workingLabel);
        workingdirPanel.add(this.workingdir);
        JButton workingdirButton = new JButton("Select working directory");
        workingdirButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                RunOptionsPane.this.setWorkingDir();
            }
        });
        workingdirPanel.add(workingdirButton);
        JPanel exeClassPanel = new JPanel(new FlowLayout());
        this.executionClass = new JTextField("must set the execution class", 25);
        this.executionClass.setEditable(false);
        JLabel executionLabel = new JLabel("Set the execution class");
        executionLabel.setLabelFor(this.executionClass);
        exeClassPanel.add(executionLabel);
        exeClassPanel.add(this.executionClass);
        JButton executionButton = new JButton("Set execution class");
        executionButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                RunOptionsPane.this.setExecutionClass();
            }
        });
        exeClassPanel.add(executionButton);
        JPanel srcPanel = new JPanel(new FlowLayout());
        this.srcPath = new JTextField("only needed if you want to create an ant buildfile", 25);
        this.srcPath.setEditable(false);
        JLabel srcLabel = new JLabel("Set source path: ");
        executionLabel.setLabelFor(this.srcPath);
        srcPanel.add(srcLabel);
        srcPanel.add(this.srcPath);
        JButton srcButton = new JButton("Set source path");
        srcButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                RunOptionsPane.this.setSrcPath();
            }
        });
        srcPanel.add(srcButton);
        JPanel settingPanel = new JPanel(new FlowLayout());
        settingPanel.add(workingdirPanel);
        settingPanel.add(exeClassPanel);
        settingPanel.add(srcPanel);
        this.add((Component)settingPanel, "Center");
        this.add((Component)compile, "South");
    }

    @AopHelperAction(action=Action.ADD, state=AopState.RUN, option=AopOption.VERBOSE)
    private void addVerbose() {
    }

    @AopHelperAction(action=Action.REMOVE, state=AopState.RUN, option=AopOption.VERBOSE)
    private void removeVerbose() {
    }

    @AopHelperAction(action=Action.ADD, state=AopState.RUN, option=AopOption.SUPPRESS)
    private void addSuppress() {
    }

    @AopHelperAction(action=Action.REMOVE, state=AopState.RUN, option=AopOption.SUPPRESS)
    private void removeSuppress() {
    }

    @AopHelperAction(action=Action.ADD, state=AopState.RUN, option=AopOption.NOOPT)
    private void addNoopt() {
    }

    @AopHelperAction(action=Action.REMOVE, state=AopState.RUN, option=AopOption.NOOPT)
    private void removeNoopt() {
    }

    @AopHelperAction(action=Action.ADD, state=AopState.RUN, option=AopOption.LOADTIME)
    private void setLoadtime() {
    }

    @AopHelperAction(action=Action.REMOVE, state=AopState.RUN, option=AopOption.LOADTIME)
    private void clearLoadtime() {
    }

    @AopHelperAction(action=Action.SET, state=AopState.RUN, option=AopOption.WORKINGDIR)
    private void setWorkingDir() {
    }

    @AopHelperAction(action=Action.RUN, state=AopState.RUN, option=AopOption.UNSPECIFIED)
    private void run() {
    }

    @AopHelperAction(action=Action.SET, state=AopState.RUN, option=AopOption.EXECLASS)
    private void setExecutionClass() {
    }

    @AopHelperAction(action=Action.SET, state=AopState.RUN, option=AopOption.SRCPATH)
    private void setSrcPath() {
    }

    public void setWorkingDir(String dir) {
        this.workingdir.setText(dir);
    }

    public void setExecutionClass(String exeClass) {
        this.executionClass.setText(exeClass);
    }

    public void setSrcPath(String srcPath) {
        this.srcPath.setText(srcPath);
    }

    public void refresh() {
        this.setWorkingDir(AopHandler.instance().getRun().getWorkingdir());
        this.setExecutionClass(AopHandler.instance().getRun().getExecutionClass());
        this.setSrcPath(AopHandler.instance().getRun().getSrcPath());
        this.verbose.setSelected(AopHandler.instance().getRun().isVerbose());
        this.noopt.setSelected(AopHandler.instance().getRun().isNoopt());
        this.suppress.setSelected(AopHandler.instance().getRun().isSuppress());
        this.loadtime.setSelected(AopHandler.instance().getRun().isLoadtime());
    }
}

