/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aophelper.ui.run;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import org.jboss.aophelper.ui.AopHelperUiMediator;

public class RunOutputPane
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JTextArea outputArea;
    private JTextArea errorArea;

    public RunOutputPane() {
        this.init();
    }

    private void init() {
        AopHelperUiMediator.instance().setRunOutputPane(this);
        this.setLayout(new FlowLayout());
        this.outputArea = new JTextArea();
        this.outputArea.setText("logs from the execution will be seen here");
        this.outputArea.setLineWrap(true);
        this.outputArea.setWrapStyleWord(true);
        this.outputArea.setEditable(false);
        JScrollPane outputScroll = new JScrollPane(this.outputArea);
        outputScroll.setVisible(true);
        this.errorArea = new JTextArea();
        this.errorArea.setText("errors from the execution will be seen here");
        this.errorArea.setLineWrap(true);
        this.errorArea.setWrapStyleWord(true);
        this.errorArea.setEditable(false);
        JScrollPane errorScroll = new JScrollPane(this.errorArea);
        errorScroll.setVisible(true);
        JTabbedPane tPane = new JTabbedPane();
        tPane.addTab("Output", outputScroll);
        tPane.addTab("Error", errorScroll);
        tPane.setPreferredSize(new Dimension(1020, 270));
        this.add((Component)tPane, "Center");
    }

    public void setText(String text) {
        this.outputArea.setText(text);
    }

    public void setError(String error) {
        this.errorArea.setText(error);
    }
}

