/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.asintegration.jboss5;

import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javassist.ClassPool;
import javassist.scopedpool.ScopedClassPool;
import javassist.scopedpool.ScopedClassPoolFactory;
import javassist.scopedpool.ScopedClassPoolRepository;
import org.jboss.aop.AspectManager;
import org.jboss.aop.asintegration.JBossIntegration;
import org.jboss.aop.asintegration.jboss5.DefaultTranslator;
import org.jboss.aop.asintegration.jboss5.JBoss5ClassPoolFactory;
import org.jboss.aop.asintegration.jboss5.VFSClassLoaderScopingPolicy;
import org.jboss.aop.classpool.AOPClassLoaderScopingPolicy;
import org.jboss.classloader.spi.ClassLoaderSystem;
import org.jboss.classloading.spi.RealClassLoader;
import org.jboss.util.loading.Translator;

public class JBoss5Integration
implements JBossIntegration,
ScopedClassPoolFactory {
    private ScopedClassPoolFactory delegateClassPoolFactory;
    private AOPClassLoaderScopingPolicy policy = new VFSClassLoaderScopingPolicy();
    private static final Set<ClassLoader> bootstrapLoaders;

    public void start() {
    }

    public void stop() {
    }

    public boolean isValidClassLoader(ClassLoader loader) {
        if (loader instanceof RealClassLoader && ((RealClassLoader)loader).isValid()) {
            return true;
        }
        if (loader == null) {
            return true;
        }
        return bootstrapLoaders.contains(loader);
    }

    public AOPClassLoaderScopingPolicy createAOPClassLoaderScopingPolicy() {
        return this.policy;
    }

    public synchronized ScopedClassPoolFactory createScopedClassPoolFactory(File tmpDir) throws Exception {
        if (this.delegateClassPoolFactory == null) {
            this.delegateClassPoolFactory = new JBoss5ClassPoolFactory();
        }
        return this;
    }

    public ScopedClassPool create(ClassLoader cl, ClassPool src, ScopedClassPoolRepository repository) {
        return this.delegateClassPoolFactory.create(cl, src, repository);
    }

    public ScopedClassPool create(ClassPool src, ScopedClassPoolRepository repository) {
        return this.delegateClassPoolFactory.create(src, repository);
    }

    public void attachDeprecatedTranslator() {
        ClassLoaderSystem.getInstance().setTranslator((Translator)new DefaultTranslator(AspectManager.getTopLevelAspectManager()));
    }

    public void detachDeprecatedTranslator() {
        ClassLoaderSystem.getInstance().setTranslator(null);
    }

    static {
        final HashSet loaders = new HashSet();
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                for (ClassLoader loader = JBoss5Integration.class.getClassLoader(); loader != null; loader = loader.getParent()) {
                    loaders.add(loader);
                }
                return null;
            }
        });
        bootstrapLoaders = Collections.unmodifiableSet(loaders);
    }
}

