/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.asintegration.jboss5;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.net.URL;
import java.security.ProtectionDomain;
import javassist.CannotCompileException;
import javassist.CtClass;
import org.jboss.aop.asintegration.jboss5.ToClassInvokerPoolReference;
import org.jboss.classloading.spi.RealClassLoader;
import org.jboss.logging.Logger;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VFSUtils;
import org.jboss.vfs.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToClassInvoker {
    Logger logger = Logger.getLogger(this.getClass());
    public URL tempURL;
    public Object tmplock = new Object();

    public ToClassInvoker(URL tempURL) {
        this.tempURL = tempURL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<?> toClass(ToClassInvokerPoolReference pool, CtClass cc, String classFileName, ClassLoader loader, ProtectionDomain domain) throws CannotCompileException {
        boolean trace = this.logger.isTraceEnabled();
        pool.lockInCache(cc);
        ClassLoader myloader = pool.getClassLoader();
        if (myloader == null || this.tempURL == null) {
            if (trace) {
                this.logger.trace((Object)(this + " " + pool + ".toClass() myloader:" + myloader + " tempURL:" + this.tempURL + " default to superPool.toClass for " + cc.getName()));
            }
            Class<?> clazz = pool.superPoolToClass(cc, loader, domain);
            if (trace) {
                this.logger.trace((Object)(this + " " + pool + " myloader:" + myloader + " created class:" + clazz));
            }
            return clazz;
        }
        try {
            URL outputURL = new URL(this.tempURL.toString() + "/" + classFileName);
            Object object = this.tmplock;
            synchronized (object) {
                if (trace) {
                    this.logger.trace((Object)(this + " " + pool + ".toClass() myloader:" + myloader + " writing bytes to " + this.tempURL));
                }
                ByteArrayOutputStream byteout = new ByteArrayOutputStream();
                BufferedOutputStream out = new BufferedOutputStream(byteout);
                out.write(cc.toBytecode());
                out.flush();
                out.close();
                byte[] classBytes = byteout.toByteArray();
                VirtualFile classFile = VFS.getChild((URL)outputURL);
                VFSUtils.writeFile((VirtualFile)classFile, (byte[])classBytes);
                if (myloader instanceof RealClassLoader) {
                    ((RealClassLoader)myloader).clearBlackList(classFileName);
                }
                Class<?> clazz = myloader.loadClass(cc.getName());
                if (trace) {
                    this.logger.trace((Object)(this + " " + pool + " myloader:" + myloader + " created class:" + clazz));
                }
                return clazz;
            }
        }
        catch (Exception e) {
            ClassFormatError cfe = new ClassFormatError("Failed to load dyn class: " + cc.getName() + " on " + this + " loader:" + myloader);
            cfe.initCause(e);
            throw cfe;
        }
    }
}

