/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.asintegration.jboss5;

import org.jboss.aop.AspectManager;
import org.jboss.aop.Domain;
import org.jboss.aop.asintegration.jboss5.AOPClassLoaderScopingPolicyWithRegistry;
import org.jboss.aop.asintegration.jboss5.AOPDomainRegistry;
import org.jboss.aop.asintegration.jboss5.ScopedVFSClassLoaderDomain;
import org.jboss.classloader.spi.ClassLoaderDomain;
import org.jboss.classloader.spi.ClassLoaderSystem;
import org.jboss.classloading.spi.dependency.Module;
import org.jboss.deployers.structure.spi.DeploymentUnit;

public class AOPClassLoaderInitializer {
    public static Domain initializeForUnit(DeploymentUnit unit) {
        AOPClassLoaderScopingPolicyWithRegistry policy = (AOPClassLoaderScopingPolicyWithRegistry)AspectManager.getClassLoaderScopingPolicy();
        AOPClassLoaderInitializer.registerLoaders(policy, unit);
        ScopedVFSClassLoaderDomain domain = AOPClassLoaderInitializer.getDomain(policy.getRegistry(), unit);
        return domain;
    }

    public static void unregisterLoaders(AspectManager manager, DeploymentUnit unit) {
        AOPClassLoaderScopingPolicyWithRegistry policy = (AOPClassLoaderScopingPolicyWithRegistry)AspectManager.getClassLoaderScopingPolicy();
        AOPDomainRegistry registry = policy.getRegistry();
        if (unit.isTopLevel() || unit.getParent().getClassLoader() != unit.getClassLoader()) {
            registry.cleanupModule(registry.getModule(unit.getClassLoader()));
            manager.unregisterClassLoader(unit.getClassLoader());
        }
    }

    private static void registerLoaders(AOPClassLoaderScopingPolicyWithRegistry policy, DeploymentUnit unit) {
        AOPDomainRegistry registry = policy.getRegistry();
        if (!unit.isTopLevel()) {
            AOPClassLoaderInitializer.registerLoaders(policy, unit.getParent());
        }
        if (unit.isTopLevel() || unit.getParent().getClassLoader() != unit.getClassLoader()) {
            Module module = AOPClassLoaderInitializer.getModuleRecursively(unit);
            if (module == null) {
                throw new IllegalStateException("No " + Module.class.getName() + " attachment could be found in the following deployment unit or its parents: " + unit);
            }
            ScopedVFSClassLoaderDomain domain = AOPClassLoaderInitializer.getDomain(registry, unit);
            if (domain == null) {
                domain = AOPClassLoaderInitializer.createDomain(registry, unit.getClassLoader(), module, unit);
            }
            registry.setDomain(domain);
            policy.registerClassLoader(module, unit.getClassLoader());
        }
    }

    private static Module getModuleRecursively(DeploymentUnit unit) {
        if (unit == null) {
            return null;
        }
        Module module = (Module)unit.getAttachment(Module.class);
        if (module == null) {
            return AOPClassLoaderInitializer.getModuleRecursively(unit.getParent());
        }
        return module;
    }

    private static ScopedVFSClassLoaderDomain getDomain(AOPDomainRegistry registry, DeploymentUnit unit) {
        return (ScopedVFSClassLoaderDomain)registry.getRegisteredDomain(unit.getClassLoader());
    }

    private static ScopedVFSClassLoaderDomain createDomain(AOPDomainRegistry registry, ClassLoader loader, Module module, DeploymentUnit unit) {
        if (!module.getDeterminedDomainName().equals("DefaultDomain")) {
            ClassLoaderSystem system = registry.getSystem();
            String domainName = module.getDeterminedDomainName();
            ClassLoaderDomain domain = system.getDomain(domainName);
            boolean parentDelegation = module.isJ2seClassLoadingCompliance();
            String name = String.valueOf(System.identityHashCode(loader));
            ScopedVFSClassLoaderDomain parentDomain = unit.isTopLevel() ? null : AOPClassLoaderInitializer.getDomain(registry, unit.getParent());
            ScopedVFSClassLoaderDomain parent = parentDomain != null ? parentDomain : AspectManager.getTopLevelAspectManager();
            return new ScopedVFSClassLoaderDomain(loader, name, parentDelegation, (AspectManager)parent, false, domain, registry);
        }
        return null;
    }
}

