/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aspects.concurrent;

import java.util.concurrent.Semaphore;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aspects.concurrent.LockAcquisitionFailureException;
import org.jboss.aspects.concurrent.SemaphoreLocked;
import org.jboss.aspects.concurrent.SemaphoredObject;

public class SemaphoreAspect {
    protected SemaphoreLocked props;

    public SemaphoreAspect(SemaphoreLocked locked) {
        this.props = locked;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object acquire(Invocation invocation) throws Throwable {
        SemaphoredObject obj = (SemaphoredObject)invocation.getTargetObject();
        if (this.props.timeout() == -1L) {
            this.blockIndefinately(obj.getSemaphore());
        } else if (this.props.timeout() == 0L) {
            this.tryLock(obj.getSemaphore());
        } else {
            this.tryLockWithTimeout(obj.getSemaphore());
        }
        try {
            Object object = invocation.invokeNext();
            return object;
        }
        finally {
            obj.getSemaphore().release(this.props.permits());
        }
    }

    protected void blockIndefinately(Semaphore semaphore) {
        try {
            semaphore.acquire(this.props.permits());
        }
        catch (InterruptedException e) {
            throw new LockAcquisitionFailureException("Failed to acquire permit for @Semaphored class", e);
        }
    }

    protected void tryLock(Semaphore semaphore) {
        if (!semaphore.tryAcquire(this.props.permits())) {
            throw new LockAcquisitionFailureException("Failed to acquire permit for @Semaphored class");
        }
    }

    protected void tryLockWithTimeout(Semaphore semaphore) {
        try {
            if (!semaphore.tryAcquire(this.props.timeout(), this.props.unit())) {
                throw new LockAcquisitionFailureException("Failed to acquire permit for @Semaphored class.  Timeout reached.");
            }
        }
        catch (InterruptedException e) {
            throw new LockAcquisitionFailureException("Failed to acquire permit for @Semaphored class", e);
        }
    }
}

