/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.advice;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import org.jboss.aop.AspectManager;
import org.jboss.aop.advice.AdviceBinding;
import org.jboss.aop.util.BindingClassifier;
import org.jboss.aop.util.UnmodifiableEmptyCollections;
import org.jboss.aop.util.logging.AOPLogger;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassifiedBindingCollection {
    private static final Logger logger = AOPLogger.getLogger(AspectManager.class);
    private volatile LinkedHashMap<String, AdviceBinding> bindings = UnmodifiableEmptyCollections.EMPTY_LINKED_HASHMAP;
    private volatile Collection<AdviceBinding> fieldReadBindings = UnmodifiableEmptyCollections.EMPTY_ARRAYLIST;
    private volatile Collection<AdviceBinding> fieldWriteBindings = UnmodifiableEmptyCollections.EMPTY_ARRAYLIST;
    private volatile Collection<AdviceBinding> constructionBindings = UnmodifiableEmptyCollections.EMPTY_ARRAYLIST;
    private volatile Collection<AdviceBinding> constructorExecutionBindings = UnmodifiableEmptyCollections.EMPTY_ARRAYLIST;
    private volatile Collection<AdviceBinding> methodExecutionBindings = UnmodifiableEmptyCollections.EMPTY_ARRAYLIST;
    private volatile Collection<AdviceBinding> constructorCallBindings = UnmodifiableEmptyCollections.EMPTY_ARRAYLIST;
    private volatile Collection<AdviceBinding> methodCallBindings = UnmodifiableEmptyCollections.EMPTY_ARRAYLIST;

    public synchronized Collection<AdviceBinding> getFieldReadBindings() {
        return this.fieldReadBindings;
    }

    public synchronized Collection<AdviceBinding> getFieldWriteBindings() {
        return this.fieldWriteBindings;
    }

    public synchronized Collection<AdviceBinding> getConstructionBindings() {
        return this.constructionBindings;
    }

    public synchronized Collection<AdviceBinding> getConstructorExecutionBindings() {
        return this.constructorExecutionBindings;
    }

    public synchronized Collection<AdviceBinding> getMethodExecutionBindings() {
        return this.methodExecutionBindings;
    }

    public synchronized Collection<AdviceBinding> getConstructorCallBindings() {
        return this.constructorCallBindings;
    }

    public synchronized Collection<AdviceBinding> getMethodCallBindings() {
        return this.methodCallBindings;
    }

    public synchronized boolean isEmpty() {
        return this.bindings.isEmpty();
    }

    public LinkedHashMap<String, AdviceBinding> getBindings() {
        return this.bindings;
    }

    public synchronized void add(AdviceBinding binding) {
        this.bindings.put(binding.getName(), binding);
        if (BindingClassifier.isGet(binding)) {
            this.fieldReadBindings.add(binding);
        }
        if (BindingClassifier.isSet(binding)) {
            this.fieldWriteBindings.add(binding);
        }
        if (BindingClassifier.isConstruction(binding)) {
            this.constructionBindings.add(binding);
        }
        if (BindingClassifier.isConstructorExecution(binding)) {
            this.constructorExecutionBindings.add(binding);
        }
        if (BindingClassifier.isMethodExecution(binding)) {
            this.methodExecutionBindings.add(binding);
        }
        if (BindingClassifier.isConstructorCall(binding)) {
            this.constructorCallBindings.add(binding);
        }
        if (BindingClassifier.isMethodCall(binding)) {
            this.methodCallBindings.add(binding);
        }
    }

    public synchronized AdviceBinding remove(String name) {
        AdviceBinding binding = (AdviceBinding)this.bindings.remove(name);
        if (binding != null) {
            this.fieldReadBindings.remove(binding);
            this.fieldWriteBindings.remove(binding);
            this.constructionBindings.remove(binding);
            this.constructorExecutionBindings.remove(binding);
            this.methodExecutionBindings.remove(binding);
            this.constructorCallBindings.remove(binding);
            this.methodCallBindings.remove(binding);
        }
        return binding;
    }

    public synchronized ArrayList<AdviceBinding> remove(ArrayList<String> names) {
        ArrayList<AdviceBinding> removedBindings = new ArrayList<AdviceBinding>();
        for (String name : names) {
            AdviceBinding binding = this.remove(name);
            if (binding == null) {
                logger.debug((Object)("ClassifiedBindingCollection.removeBindings() no binding found with name " + name));
                continue;
            }
            removedBindings.add(binding);
        }
        return removedBindings;
    }

    public synchronized boolean isInitialized() {
        return this.bindings != UnmodifiableEmptyCollections.EMPTY_LINKED_HASHMAP;
    }

    public synchronized void initialize() {
        this.bindings = new LinkedHashMap();
        this.fieldReadBindings = new LinkedHashSet<AdviceBinding>(0);
        this.fieldWriteBindings = new LinkedHashSet<AdviceBinding>(0);
        this.constructionBindings = new LinkedHashSet<AdviceBinding>(0);
        this.constructorExecutionBindings = new LinkedHashSet<AdviceBinding>(0);
        this.methodExecutionBindings = new LinkedHashSet<AdviceBinding>(0);
        this.constructorCallBindings = new LinkedHashSet<AdviceBinding>(0);
        this.methodCallBindings = new LinkedHashSet<AdviceBinding>(0);
    }
}

