/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.instrument;

import javassist.CannotCompileException;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMember;
import javassist.CtMethod;
import javassist.Modifier;
import javassist.NotFoundException;
import javassist.expr.ExprEditor;
import javassist.expr.FieldAccess;
import org.jboss.aop.instrument.FieldAccessTransformer;
import org.jboss.aop.instrument.Instrumentor;
import org.jboss.aop.instrument.JoinpointClassification;
import org.jboss.aop.instrument.OptimizedFieldInvocations;

public class NonOptimizedFieldAccessTransformer
extends FieldAccessTransformer {
    public NonOptimizedFieldAccessTransformer(Instrumentor instrumentor) {
        super(instrumentor);
    }

    protected void doBuildFieldWrappers(CtClass clazz, CtField field, int fieldIndex, boolean shouldReplaceArrayAccess, JoinpointClassification classificationGet, JoinpointClassification classificationSet) throws NotFoundException, CannotCompileException {
        this.instrumentor.setupBasics(clazz);
        boolean wrappedGet = classificationGet.equals(JoinpointClassification.WRAPPED);
        boolean wrappedSet = classificationSet.equals(JoinpointClassification.WRAPPED);
        int mod = this.getStaticModifiers(field);
        this.buildWrapperPlaceHolders(clazz, field, this.isPrepared(classificationGet), this.isPrepared(classificationSet), mod);
        try {
            if (this.isPrepared(classificationGet)) {
                this.addFieldReadInfoFieldWithAccessors(10, clazz, field);
                OptimizedFieldInvocations.createOptimizedInvocationClass(this.instrumentor, clazz, field, true);
                wrapper.prepareForWrapping((CtMember)field, 0);
            }
            if (this.isPrepared(classificationSet)) {
                this.addFieldWriteInfoField(10, clazz, field);
                OptimizedFieldInvocations.createOptimizedInvocationClass(this.instrumentor, clazz, field, false);
                wrapper.prepareForWrapping((CtMember)field, 1);
            }
        }
        catch (Exception e) {
            throw new CannotCompileException((Throwable)e);
        }
        if (wrappedGet) {
            wrapper.wrap((CtMember)field, 0);
            if (classificationGet.equals(JoinpointClassification.DYNAMICALY_WRAPPED)) {
                this.instrumentor.dynamicTransformationObserver.fieldReadDynamicalyWrapped(field);
            }
        }
        if (wrappedSet) {
            wrapper.wrap((CtMember)field, 1);
            if (classificationSet.equals(JoinpointClassification.DYNAMICALY_WRAPPED)) {
                this.instrumentor.dynamicTransformationObserver.fieldWriteDynamicalyWrapped(field);
            }
        }
        this.replaceFieldAccessInternally(clazz, field, wrappedGet, wrappedSet, fieldIndex);
        this.buildWrappers(clazz, field, shouldReplaceArrayAccess, wrappedGet, wrappedSet, fieldIndex);
    }

    private void buildWrappers(CtClass clazz, CtField field, boolean shouldReplaceArrayAccess, boolean doGet, boolean doSet, int index) throws NotFoundException, CannotCompileException {
        CtMethod method;
        String code;
        if (doGet) {
            code = this.getReadWrapperBody(clazz, field, index);
            method = clazz.getDeclaredMethod(NonOptimizedFieldAccessTransformer.fieldRead(field.getName()));
            method.setBody(code);
        }
        if (doSet) {
            code = this.getWriteWrapperBody(clazz, field, shouldReplaceArrayAccess, index);
            method = clazz.getDeclaredMethod(NonOptimizedFieldAccessTransformer.fieldWrite(field.getName()));
            method.setBody(code);
        }
    }

    protected String getWrapperBody(CtClass clazz, CtField field, boolean get, int index) throws NotFoundException, CannotCompileException {
        if (get) {
            return this.getReadWrapperBody(clazz, field, index);
        }
        return this.getWriteWrapperBody(clazz, field, false, index);
    }

    private String getReadWrapperBody(CtClass clazz, CtField field, int index) throws NotFoundException, CannotCompileException {
        String access = "";
        String instanceCheck = "";
        String name = field.getName();
        boolean isStatic = Modifier.isStatic((int)field.getModifiers());
        if (!isStatic) {
            access = "((" + clazz.getName() + ")$1).";
            instanceCheck = " || ((org.jboss.aop.ClassInstanceAdvisor)((org.jboss.aop.InstanceAdvised)$1)._getInstanceAdvisor()).hasInstanceAspects";
        }
        return "{     if (aop$classAdvisor$aop.hasAspects() " + instanceCheck + " ) " + "    { " + "       return ($r)" + "aop$classAdvisor$aop" + ".invokeRead($1, (int)" + index + "); " + "    } " + "    return " + access + name + "; " + "}";
    }

    private String getWriteWrapperBody(CtClass clazz, CtField field, boolean shouldReplaceArrayAccess, int index) throws NotFoundException, CannotCompileException {
        String fieldString;
        String targetString;
        String name = field.getName();
        boolean isStatic = Modifier.isStatic((int)field.getModifiers());
        String access = "";
        String instanceCheck = "";
        if (!isStatic) {
            access = "((" + clazz.getName() + ")$1).";
            instanceCheck = " || ((org.jboss.aop.ClassInstanceAdvisor)((org.jboss.aop.InstanceAdvised)$1)._getInstanceAdvisor()).hasInstanceAspects";
            targetString = "((" + clazz.getName() + ")$1)";
            fieldString = targetString + "." + field.getName();
        } else {
            targetString = "java.lang.Class.forName(\"" + clazz.getName() + "\")";
            fieldString = clazz.getName() + "." + field.getName();
        }
        return "{     " + this.getArrayWriteRegistration(shouldReplaceArrayAccess, targetString, field, fieldString, "$2") + "    if (" + "aop$classAdvisor$aop" + ".hasAspects() " + instanceCheck + " ) " + "    { " + "       " + "aop$classAdvisor$aop" + ".invokeWrite($1, (int)" + index + ", ($w)$2); " + "    } " + "    else " + "    { " + "       " + access + name + " = $2; " + "    } " + "}";
    }

    protected void replaceFieldAccessInternally(CtClass clazz, CtField field, boolean doGet, boolean doSet, int index) throws CannotCompileException {
        NonOptimizedFieldAccessExprEditor expr = new NonOptimizedFieldAccessExprEditor(clazz, field, doGet, doSet, index);
        clazz.instrument((ExprEditor)expr);
    }

    protected class NonOptimizedFieldAccessExprEditor
    extends FieldAccessTransformer.FieldAccessExprEditor {
        public NonOptimizedFieldAccessExprEditor(CtClass clazz, CtField field, boolean doGet, boolean doSet, int index) {
            super(clazz, field, doGet, doSet, index);
        }

        protected void replaceRead(FieldAccess fieldAccess) throws CannotCompileException {
            if (fieldAccess.isStatic()) {
                String code = "    {        $_ = ($r)" + FieldAccessTransformer.fieldRead(this.field.getName()) + "(null);" + "    } " + "";
                fieldAccess.replace(code);
            } else {
                String code = "    {        $_ = ($r)" + FieldAccessTransformer.fieldRead(this.field.getName()) + "($0);" + "    } " + "";
                fieldAccess.replace(code);
            }
        }

        protected void replaceWrite(FieldAccess fieldAccess) throws CannotCompileException {
            String fieldWrite = FieldAccessTransformer.fieldWrite(this.field.getName());
            if (fieldAccess.isStatic()) {
                String code = "    {        " + fieldWrite + "(null, $1);" + "    } " + "";
                fieldAccess.replace(code);
            } else {
                String code = "    {        " + fieldWrite + "($0, $1);" + "    } " + "";
                fieldAccess.replace(code);
            }
        }
    }
}

