/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.instrument;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import javassist.CannotCompileException;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.NotFoundException;
import org.jboss.aop.Advisor;
import org.jboss.aop.ClassAdvisor;
import org.jboss.aop.instrument.Instrumentor;
import org.jboss.aop.instrument.TransformerCommon;
import org.jboss.aop.pointcut.Pointcut;

public abstract class ConstructionTransformer {
    static final String CONSTRUCTION_INFO_CLASS_NAME = "org.jboss.aop.ConstructionInfo";
    protected Instrumentor instrumentor;

    protected ConstructionTransformer(Instrumentor instrumentor) {
        this.instrumentor = instrumentor;
    }

    protected String addConstructionInfoField(int modifiers, CtClass addTo, CtConstructor ctor, int index) throws NotFoundException, CannotCompileException {
        return this.addConstructionInfoField(modifiers, addTo, ctor, index, null);
    }

    protected String addConstructionInfoField(int modifiers, CtClass addTo, CtConstructor ctor, int index, CtField.Initializer init) throws NotFoundException, CannotCompileException {
        String name = ConstructionTransformer.getConstructionInfoFieldName(ctor.getDeclaringClass().getSimpleName(), index);
        if (this.instrumentor.getClassPool() != null) {
            try {
                addTo.getDeclaredField(name);
                return name;
            }
            catch (NotFoundException e) {
                TransformerCommon.addInfoField(this.instrumentor, CONSTRUCTION_INFO_CLASS_NAME, name, modifiers, addTo, this.addInfoAsWeakReference(), init);
            }
        }
        return name;
    }

    protected boolean addInfoAsWeakReference() {
        return true;
    }

    public static String getConstructionInfoFieldName(String classname, int index) {
        if (classname.indexOf(".") >= 0) {
            throw new RuntimeException("Use simple class name for construction info field name: " + classname);
        }
        return "aop$constructionInfo_" + classname.replace('.', '$') + "_" + index;
    }

    protected static String constructionInfoFromWeakReference(String localName, String ctorInfoName) {
        return TransformerCommon.infoFromWeakReference(CONSTRUCTION_INFO_CLASS_NAME, localName, ctorInfoName);
    }

    public boolean insertConstructionInterception(CtClass clazz, ClassAdvisor advisor) throws Exception {
        if (!advisor.getManager().isConstruction()) {
            return false;
        }
        boolean oneMatch = false;
        List<CtConstructor> constructors = this.instrumentor.getConstructors(clazz);
        Iterator<CtConstructor> it = constructors.iterator();
        int index = 0;
        while (it.hasNext()) {
            CtConstructor constructor = it.next();
            if (constructor.isClassInitializer() || !ConstructionTransformer.isAdvisableConstructor(constructor, advisor)) {
                if (oneMatch) {
                    this.generateNotMatchedConstructionInfoField(constructor, index);
                }
            } else {
                if (!oneMatch) {
                    oneMatch = true;
                    this.instrumentor.setupBasics(clazz);
                    for (int j = 0; j < index; ++j) {
                        this.generateNotMatchedConstructionInfoField(constructors.get(j), j);
                    }
                }
                this.generateConstructionInfoField(constructor, index);
                this.insertInterception(constructor, index);
            }
            ++index;
        }
        return oneMatch;
    }

    protected abstract void insertInterception(CtConstructor var1, int var2) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isAdvisableConstructor(CtConstructor con, ClassAdvisor advisor) throws NotFoundException {
        LinkedHashMap<String, Pointcut> pointcuts;
        LinkedHashMap<String, Pointcut> linkedHashMap = pointcuts = advisor.getManager().getPointcuts();
        synchronized (linkedHashMap) {
            for (Pointcut pointcut : pointcuts.values()) {
                if (!pointcut.matchesConstruction((Advisor)advisor, con)) continue;
                return true;
            }
        }
        return false;
    }

    protected void generateConstructionInfoField(CtConstructor constructor, int index) throws NotFoundException, CannotCompileException {
        this.addConstructionInfoField(10, constructor.getDeclaringClass(), constructor, index);
    }

    protected void generateNotMatchedConstructionInfoField(CtConstructor constructor, int index) throws NotFoundException, CannotCompileException {
    }
}

