/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.pointcut;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SecurityActions {
    SecurityActions() {
    }

    static Class<?> loadClass(String name) {
        if (System.getSecurityManager() == null) {
            return LoadClassAction.NON_PRIVILEGED.loadClass(name);
        }
        return LoadClassAction.PRIVILEGED.loadClass(name);
    }

    static ClassLoader getContextClassLoader() {
        if (System.getSecurityManager() == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return AccessController.doPrivileged(GetContextClassLoaderAction.INSTANCE);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class GetContextClassLoaderAction
    implements PrivilegedAction<ClassLoader> {
        public static GetContextClassLoaderAction INSTANCE = new GetContextClassLoaderAction();

        @Override
        public ClassLoader run() {
            return Thread.currentThread().getContextClassLoader();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface LoadClassAction {
        public static final LoadClassAction PRIVILEGED = new LoadClassAction(){

            @Override
            public Class<?> loadClass(final String name) {
                try {
                    return (Class)AccessController.doPrivileged(new PrivilegedExceptionAction<Class<?>>(){

                        @Override
                        public Class<?> run() throws Exception {
                            return Thread.currentThread().getContextClassLoader().loadClass(name);
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    throw new RuntimeException("Unable to load class " + name, e.getException());
                }
            }
        };
        public static final LoadClassAction NON_PRIVILEGED = new LoadClassAction(){

            @Override
            public Class<?> loadClass(String name) {
                try {
                    return Thread.currentThread().getContextClassLoader().loadClass(name);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("Unable to load class " + name, e);
                }
            }
        };

        public Class<?> loadClass(String var1);
    }
}

