/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.advice;

import org.jboss.aop.advice.SecurityActions;
import org.jboss.aop.pointcut.DynamicCFlow;
import org.jboss.util.xml.XmlLoadable;
import org.w3c.dom.Element;

public class DynamicCFlowDefinition {
    private String name;
    private String className;
    private Element element;
    private Class<?> pClass;

    public DynamicCFlowDefinition(Element element, String className, String name) {
        this.className = className;
        this.element = element;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getClassName() {
        return this.className;
    }

    public DynamicCFlow create() {
        if (this.pClass == null) {
            try {
                this.pClass = SecurityActions.getContextClassLoader().loadClass(this.className);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("dynamic cflow class not found: " + this.className);
            }
        }
        try {
            DynamicCFlow cflow = (DynamicCFlow)this.pClass.newInstance();
            if (cflow instanceof XmlLoadable) {
                ((XmlLoadable)cflow).importXml(this.element);
            }
            return cflow;
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

