/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.classpool;

import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.NotFoundException;
import javassist.scopedpool.ScopedClassPool;
import javassist.scopedpool.ScopedClassPoolRepository;
import org.jboss.aop.AspectManager;
import org.jboss.aop.classpool.AOPClassPoolRepository;

public class AOPClassPool
extends ScopedClassPool {
    protected ConcurrentHashMap<String, String> generatedClasses = new ConcurrentHashMap();
    protected ConcurrentHashMap<String, Boolean> localResources = new ConcurrentHashMap();
    protected ConcurrentHashMap<String, Boolean> loadedButNotWovenClasses = new ConcurrentHashMap();

    public AOPClassPool(ClassLoader cl, ClassPool src, ScopedClassPoolRepository repository) {
        this(cl, src, repository, false);
    }

    protected AOPClassPool(ClassPool src, ScopedClassPoolRepository repository) {
        this(null, src, repository, true);
    }

    private AOPClassPool(ClassLoader cl, ClassPool src, ScopedClassPoolRepository repository, boolean isTemp) {
        super(cl, src, repository, isTemp);
    }

    public void setClassLoader(ClassLoader cl) {
        this.classLoader = new WeakReference<ClassLoader>(cl);
    }

    public void registerGeneratedClass(String className) {
        this.generatedClasses.put(className, className);
    }

    public void close() {
        super.close();
        AOPClassPoolRepository.getInstance().perfomUnregisterClassLoader(this.getClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CtClass getCached(String classname) {
        CtClass clazz = this.getCachedLocally(classname);
        if (clazz == null) {
            String o;
            boolean isLocal = false;
            ClassLoader cl = this.getClassLoader0();
            if (cl != null) {
                isLocal = this.isLocalResource(classname);
            }
            if (!isLocal && (o = this.generatedClasses.get(classname)) == null) {
                Map<ClassLoader, ClassPool> registeredCLs;
                Map<ClassLoader, ClassPool> map = registeredCLs = AspectManager.getRegisteredCLs();
                synchronized (map) {
                    for (ClassPool pl : AspectManager.getRegisteredCLs().values()) {
                        AOPClassPool pool = (AOPClassPool)pl;
                        if (pool.isUnloadedClassLoader()) {
                            AspectManager.instance().unregisterClassLoader(pool.getClassLoader());
                            continue;
                        }
                        if (!pool.includeInGlobalSearch() || (clazz = pool.getCachedLocally(classname)) == null) continue;
                        return clazz;
                    }
                }
            }
        }
        return clazz;
    }

    protected boolean includeInGlobalSearch() {
        return true;
    }

    protected String getResourceName(String classname) {
        int lastIndex = classname.lastIndexOf(36);
        if (lastIndex < 0) {
            return classname.replaceAll("[\\.]", "/") + ".class";
        }
        return classname.substring(0, lastIndex).replaceAll("[\\.]", "/") + classname.substring(lastIndex) + ".class";
    }

    protected boolean isLocalResource(String resourceName) {
        String classResourceName = this.getResourceName(resourceName);
        Boolean isLocal = this.localResources.get(classResourceName);
        if (isLocal != null) {
            return isLocal;
        }
        boolean localResource = this.getClassLoader().getResource(classResourceName) != null;
        this.localResources.put(classResourceName, localResource ? Boolean.TRUE : Boolean.FALSE);
        return localResource;
    }

    public synchronized CtClass getLocally(String classname) throws NotFoundException {
        this.softcache.remove((Object)classname);
        CtClass clazz = (CtClass)this.classes.get(classname);
        if (clazz == null) {
            clazz = this.createCtClass(classname, true);
            if (clazz == null) {
                throw new NotFoundException(classname);
            }
            this.lockInCache(clazz);
        }
        return clazz;
    }

    public void setClassLoadedButNotWoven(String classname) {
        this.loadedButNotWovenClasses.put(classname, Boolean.TRUE);
    }

    public boolean isClassLoadedButNotWoven(String classname) {
        return this.loadedButNotWovenClasses.get(classname) == Boolean.TRUE;
    }

    public static AOPClassPool createAOPClassPool(ClassLoader cl, ClassPool src, ScopedClassPoolRepository repository) {
        return (AOPClassPool)AspectManager.getClassPoolFactory().create(cl, src, repository);
    }

    public static AOPClassPool createAOPClassPool(ClassPool src, ScopedClassPoolRepository repository) {
        return (AOPClassPool)AspectManager.getClassPoolFactory().create(src, repository);
    }

    public String toString() {
        ClassLoader cl = null;
        try {
            cl = this.getClassLoader();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        return ((Object)((Object)this)).getClass().getName() + "@" + System.identityHashCode((Object)this) + " " + super.toString() + " - dcl " + cl;
    }

    static {
        ClassPool.doPruning = false;
        ClassPool.releaseUnmodifiedClassFile = false;
    }
}

