/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.ClassAdvisor;
import org.jboss.aop.MethodInfo;
import org.jboss.aop.SecurityActions;
import org.jboss.aop.advice.AdviceBinding;
import org.jboss.aop.advice.ClassifiedBindingCollection;
import org.jboss.aop.metadata.ClassMetaDataBinding;
import org.jboss.aop.metadata.ClassMetaDataLoader;
import org.jboss.aop.util.Advisable;
import org.jboss.aop.util.BindingClassifier;
import org.jboss.aop.util.ConstructorComparator;
import org.jboss.aop.util.FieldComparator;
import org.jboss.aop.util.MethodHashing;
import org.jboss.aop.util.logging.AOPLogger;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassContainer
extends Advisor {
    private static final Logger logger = AOPLogger.getLogger(ClassContainer.class);
    private boolean chainOverridingForInheritedMethods;
    protected Field[] advisedFields;

    public ClassContainer(String name, AspectManager manager) {
        super(name, manager);
    }

    public void initializeClassContainer(Class<?> clazz) {
        this.setClass(clazz);
        this.initializeClassContainer();
    }

    @Deprecated
    public void initializeClassContainer() {
        this.initializeMetadata();
        this.rebuildInterceptors();
    }

    @Deprecated
    public void setClass(Class<?> clazz) {
        this.clazz = clazz;
    }

    public void initializeMetadata() {
        this.createMethodMap();
        this.createConstructorTables();
        this.createFieldTable();
        this.getManager().attachMetaData(this, this.clazz);
        this.rebindClassMetaData();
        this.deployAnnotationOverrides();
    }

    private void populateFieldTable(ArrayList<Field> fields, final Class<?> superclass) {
        if (superclass == null) {
            return;
        }
        if (superclass.equals(Object.class)) {
            return;
        }
        this.populateFieldTable(fields, superclass.getSuperclass());
        ArrayList<Field> temp = new ArrayList<Field>();
        Field[] declaredFields = AccessController.doPrivileged(new PrivilegedAction<Field[]>(){

            @Override
            public Field[] run() {
                return superclass.getDeclaredFields();
            }
        });
        for (int i = 0; i < declaredFields.length; ++i) {
            if (!Advisable.isAdvisable(declaredFields[i])) continue;
            temp.add(declaredFields[i]);
        }
        Collections.sort(temp, FieldComparator.INSTANCE);
        fields.addAll(temp);
    }

    protected void createFieldTable() {
        ArrayList<Field> fields = new ArrayList<Field>();
        this.populateFieldTable(fields, this.clazz);
        this.advisedFields = fields.toArray(new Field[fields.size()]);
    }

    @Override
    protected void rebuildInterceptors() {
        this.adviceBindings.clear();
        if (this.constructorInfos == null) {
            this.createInterceptorChains();
        } else {
            this.updateInterceptorChains();
        }
    }

    @Override
    protected void rebuildInterceptorsForAddedBinding(AdviceBinding binding) {
        if (AspectManager.verbose && logger.isDebugEnabled()) {
            logger.debug((Object)("iterate binding " + binding.getName()));
        }
        this.resetChainKeepInterceptors(this.methodInfos);
        this.resetChainKeepInterceptors(this.constructorInfos);
        this.resolveMethodPointcut(binding);
        this.resolveConstructorPointcut(binding);
        this.finalizeChain(this.constructorInfos);
        this.finalizeMethodChain();
        this.populateInterceptorsFromInfos();
        this.doesHaveAspects = this.adviceBindings.size() > 0;
    }

    @Override
    protected void rebuildInterceptorsForRemovedBinding(AdviceBinding binding) {
        if (BindingClassifier.isExecution(binding)) {
            this.updateMethodPointcutAfterRemove(binding);
        }
        if (BindingClassifier.isConstructorExecution(binding)) {
            this.updateConstructorPointcutAfterRemove(binding);
        }
        if (BindingClassifier.isExecution(binding)) {
            this.finalizeMethodChain();
        }
        if (BindingClassifier.isConstructorExecution(binding)) {
            this.finalizeChain(this.constructorInfos);
        }
        this.doesHaveAspects = this.adviceBindings.size() > 0;
    }

    @Override
    public void addClassMetaData(ClassMetaDataBinding data) {
        this.initClassMetaDataBindingsList();
        this.classMetaDataBindings.add(data);
        if (this.clazz == null) {
            return;
        }
        this.bindClassMetaData(data);
        this.adviceBindings.clear();
        this.doesHaveAspects = false;
        this.rebuildInterceptors();
    }

    @Override
    public void removeClassMetaData(ClassMetaDataBinding data) {
        if (this.classMetaDataBindings.remove(data)) {
            if (this.clazz == null) {
                return;
            }
            this.rebindClassMetaData();
            this.adviceBindings.clear();
            this.doesHaveAspects = false;
            this.rebuildInterceptors();
        }
    }

    protected void bindClassMetaData(ClassMetaDataBinding data) {
        try {
            ClassMetaDataLoader loader = data.getLoader();
            Object[] objs = this.advisedMethods.getValues();
            Method[] methods = new Method[objs.length];
            for (int i = 0; i < objs.length; ++i) {
                methods[i] = (Method)objs[i];
            }
            loader.bind((Advisor)this, data, methods, this.advisedFields, this.clazz.getDeclaredConstructors());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected void rebindClassMetaData() {
        this.defaultMetaData.clear();
        this.methodMetaData.clear();
        this.fieldMetaData.clear();
        this.constructorMetaData.clear();
        this.classMetaData.clear();
        for (int i = 0; i < this.classMetaDataBindings.size(); ++i) {
            try {
                ClassMetaDataBinding data = (ClassMetaDataBinding)this.classMetaDataBindings.get(i);
                this.bindClassMetaData(data);
                continue;
            }
            catch (ClassCastException e) {
                logger.warn((Object)("Invalid object found in classMetaDataBindings map. The type was " + e.getMessage()));
            }
        }
    }

    protected void createMethodMap() {
        this.initAdvisedMethodsMap();
        try {
            Method[] declaredMethods = this.clazz.getMethods();
            for (int i = 0; i < declaredMethods.length; ++i) {
                if (!ClassAdvisor.isAdvisable(declaredMethods[i])) continue;
                long hash = MethodHashing.methodHash(declaredMethods[i]);
                this.advisedMethods.put(hash, (Object)declaredMethods[i]);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void initializeMethodChain() {
        long[] keys = this.advisedMethods.keys();
        for (int i = 0; i < keys.length; ++i) {
            MethodInfo info = new MethodInfo();
            Method amethod = (Method)this.advisedMethods.get(keys[i]);
            info.setAdvisedMethod(amethod);
            info.setUnadvisedMethod(amethod);
            info.setHash(keys[i]);
            info.setAdvisor(this);
            this.methodInfos.put(keys[i], info);
        }
    }

    protected void createConstructorTables() {
        this.constructors = SecurityActions.getDeclaredConstructors(this.clazz);
        if (this.constructors.length > 0) {
            for (int i = 0; i < this.constructors.length; ++i) {
                SecurityActions.setAccessible(this.constructors[i]);
            }
            Arrays.sort(this.constructors, ConstructorComparator.INSTANCE);
        }
    }

    protected void createInterceptorChains() {
        this.initializeMethodChain();
        this.initializeConstructorChain();
        this.makeInterceptorChains();
    }

    protected void updateInterceptorChains() {
        this.resetChain(this.methodInfos);
        this.resetChain(this.constructorInfos);
        this.makeInterceptorChains();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeInterceptorChains() {
        ClassifiedBindingCollection bindingCol;
        ClassifiedBindingCollection classifiedBindingCollection = bindingCol = this.manager.getBindingCollection();
        synchronized (classifiedBindingCollection) {
            Collection<AdviceBinding> bindings = bindingCol.getConstructorExecutionBindings();
            for (AdviceBinding binding : bindings) {
                if (AspectManager.verbose && logger.isDebugEnabled()) {
                    logger.debug((Object)("iterate binding " + binding.getName()));
                }
                this.resolveConstructorPointcut(binding);
            }
            bindings = bindingCol.getMethodExecutionBindings();
            for (AdviceBinding binding : bindings) {
                if (AspectManager.verbose && logger.isDebugEnabled()) {
                    logger.debug((Object)("iterate binding " + binding.getName()));
                }
                this.resolveMethodPointcut(binding);
            }
        }
        this.finalizeChain(this.constructorInfos);
        this.finalizeMethodChain();
        this.populateInterceptorsFromInfos();
        this.doesHaveAspects = this.adviceBindings.size() > 0;
    }

    @Override
    public boolean chainOverridingForInheritedMethods() {
        return this.chainOverridingForInheritedMethods;
    }

    @Override
    protected void setChainOverridingForInheritedMethods(boolean overriding) {
        this.chainOverridingForInheritedMethods = overriding;
    }
}

