/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.advice;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jboss.aop.AspectManager;
import org.jboss.aop.advice.AdviceBinding;
import org.jboss.aop.util.BindingClassifier;
import org.jboss.aop.util.UnmodifiableEmptyCollections;
import org.jboss.aop.util.UnmodifiableLinkedHashMap;
import org.jboss.aop.util.logging.AOPLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassifiedBindingCollection {
    private static final AOPLogger logger = AOPLogger.getLogger(AspectManager.class);
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private volatile LinkedHashMap<String, AdviceBinding> bindings = UnmodifiableEmptyCollections.EMPTY_LINKED_HASHMAP;
    private volatile Collection<AdviceBinding> fieldReadBindings = UnmodifiableEmptyCollections.EMPTY_ARRAYLIST;
    private volatile Collection<AdviceBinding> fieldWriteBindings = UnmodifiableEmptyCollections.EMPTY_ARRAYLIST;
    private volatile Collection<AdviceBinding> constructionBindings = UnmodifiableEmptyCollections.EMPTY_ARRAYLIST;
    private volatile Collection<AdviceBinding> constructorExecutionBindings = UnmodifiableEmptyCollections.EMPTY_ARRAYLIST;
    private volatile Collection<AdviceBinding> methodExecutionBindings = UnmodifiableEmptyCollections.EMPTY_ARRAYLIST;
    private volatile Collection<AdviceBinding> constructorCallBindings = UnmodifiableEmptyCollections.EMPTY_ARRAYLIST;
    private volatile Collection<AdviceBinding> methodCallBindings = UnmodifiableEmptyCollections.EMPTY_ARRAYLIST;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<AdviceBinding> getFieldReadBindings() {
        this.lockRead();
        try {
            Collection<AdviceBinding> collection = this.fieldReadBindings;
            return collection;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<AdviceBinding> getFieldWriteBindings() {
        this.lockRead();
        try {
            Collection<AdviceBinding> collection = this.fieldWriteBindings;
            return collection;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<AdviceBinding> getConstructionBindings() {
        this.lockRead();
        try {
            Collection<AdviceBinding> collection = this.constructionBindings;
            return collection;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<AdviceBinding> getConstructorExecutionBindings() {
        this.lockRead();
        try {
            Collection<AdviceBinding> collection = this.constructorExecutionBindings;
            return collection;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<AdviceBinding> getMethodExecutionBindings() {
        this.lockRead();
        try {
            Collection<AdviceBinding> collection = this.methodExecutionBindings;
            return collection;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<AdviceBinding> getConstructorCallBindings() {
        this.lockRead();
        try {
            Collection<AdviceBinding> collection = this.constructorCallBindings;
            return collection;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<AdviceBinding> getMethodCallBindings() {
        this.lockRead();
        try {
            Collection<AdviceBinding> collection = this.methodCallBindings;
            return collection;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        this.lockRead();
        try {
            boolean bl = this.bindings.isEmpty();
            return bl;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkedHashMap<String, AdviceBinding> getBindings() {
        this.lockRead();
        try {
            UnmodifiableLinkedHashMap<String, AdviceBinding> unmodifiableLinkedHashMap = new UnmodifiableLinkedHashMap<String, AdviceBinding>(this.bindings);
            return unmodifiableLinkedHashMap;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(AdviceBinding binding) {
        this.lockWrite();
        try {
            this.addBinding(binding);
            this.addGet(binding);
            this.addSet(binding);
            this.addConstruction(binding);
            this.addConstructorExecution(binding);
            this.addMethodExecution(binding);
            this.addConstructorCall(binding);
            this.addMethodCall(binding);
        }
        finally {
            this.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AdviceBinding remove(String name) {
        this.lockWrite();
        try {
            AdviceBinding binding = (AdviceBinding)this.bindings.remove(name);
            if (binding != null) {
                this.fieldReadBindings.remove(binding);
                this.fieldWriteBindings.remove(binding);
                this.constructionBindings.remove(binding);
                this.constructorExecutionBindings.remove(binding);
                this.methodExecutionBindings.remove(binding);
                this.constructorCallBindings.remove(binding);
                this.methodCallBindings.remove(binding);
            }
            AdviceBinding adviceBinding = binding;
            return adviceBinding;
        }
        finally {
            this.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<AdviceBinding> remove(ArrayList<String> names) {
        this.lockWrite();
        try {
            ArrayList<AdviceBinding> removedBindings = new ArrayList<AdviceBinding>();
            for (String name : names) {
                AdviceBinding binding = this.remove(name);
                if (binding == null) {
                    logger.debug("ClassifiedBindingCollection.removeBindings() no binding found with name " + name);
                    continue;
                }
                removedBindings.add(binding);
            }
            ArrayList<AdviceBinding> arrayList = removedBindings;
            return arrayList;
        }
        finally {
            this.unlockWrite();
        }
    }

    public final void lockRead() {
        this.lock.readLock().lock();
    }

    protected final void unlockRead() {
        this.lock.readLock().unlock();
    }

    public final void lockWrite() {
        this.lock.writeLock().lock();
    }

    public final void unlockWrite() {
        this.lock.writeLock().unlock();
    }

    public void lockRead(boolean lockParents) {
        this.lockRead();
    }

    public void unlockRead(boolean lockParents) {
        this.unlockRead();
    }

    public void lockWrite(boolean lockParents) {
        this.lockWrite();
    }

    public void unlockWrite(boolean lockParents) {
        this.unlockWrite();
    }

    private void addBinding(AdviceBinding binding) {
        if (this.bindings == UnmodifiableEmptyCollections.EMPTY_LINKED_HASHMAP) {
            this.bindings = new LinkedHashMap();
        }
        this.bindings.put(binding.getName(), binding);
    }

    private void addGet(AdviceBinding binding) {
        if (BindingClassifier.isGet(binding)) {
            if (this.fieldReadBindings == UnmodifiableEmptyCollections.EMPTY_ARRAYLIST) {
                this.fieldReadBindings = new CopyOnWriteArraySet<AdviceBinding>();
            }
            this.fieldReadBindings.add(binding);
        }
    }

    private void addSet(AdviceBinding binding) {
        if (BindingClassifier.isSet(binding)) {
            if (this.fieldWriteBindings == UnmodifiableEmptyCollections.EMPTY_ARRAYLIST) {
                this.fieldWriteBindings = new CopyOnWriteArraySet<AdviceBinding>();
            }
            this.fieldWriteBindings.add(binding);
        }
    }

    private void addConstruction(AdviceBinding binding) {
        if (BindingClassifier.isConstruction(binding)) {
            if (this.constructionBindings == UnmodifiableEmptyCollections.EMPTY_ARRAYLIST) {
                this.constructionBindings = new CopyOnWriteArraySet<AdviceBinding>();
            }
            this.constructionBindings.add(binding);
        }
    }

    private void addConstructorExecution(AdviceBinding binding) {
        if (BindingClassifier.isConstructorExecution(binding)) {
            if (this.constructorExecutionBindings == UnmodifiableEmptyCollections.EMPTY_ARRAYLIST) {
                this.constructorExecutionBindings = new CopyOnWriteArraySet<AdviceBinding>();
            }
            this.constructorExecutionBindings.add(binding);
        }
    }

    private void addMethodExecution(AdviceBinding binding) {
        if (BindingClassifier.isMethodExecution(binding)) {
            if (this.methodExecutionBindings == UnmodifiableEmptyCollections.EMPTY_ARRAYLIST) {
                this.methodExecutionBindings = new CopyOnWriteArraySet<AdviceBinding>();
            }
            this.methodExecutionBindings.add(binding);
        }
    }

    private void addMethodCall(AdviceBinding binding) {
        if (BindingClassifier.isMethodCall(binding)) {
            if (this.methodCallBindings == UnmodifiableEmptyCollections.EMPTY_ARRAYLIST) {
                this.methodCallBindings = new CopyOnWriteArraySet<AdviceBinding>();
            }
            this.methodCallBindings.add(binding);
        }
    }

    private void addConstructorCall(AdviceBinding binding) {
        if (BindingClassifier.isConstructorCall(binding)) {
            if (this.constructorCallBindings == UnmodifiableEmptyCollections.EMPTY_ARRAYLIST) {
                this.constructorCallBindings = new CopyOnWriteArraySet<AdviceBinding>();
            }
            this.constructorCallBindings.add(binding);
        }
    }
}

