/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.metadata;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.metadata.MetaDataResolver;
import org.jboss.aop.util.MarshalledValue;
import org.jboss.aop.util.PayloadKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleMetaData
implements MetaDataResolver,
Externalizable {
    static final long serialVersionUID = -3873275588469743345L;
    protected HashMap<Object, HashMap<Object, MetaDataValue>> metaData = new HashMap();

    public synchronized int size() {
        return this.metaData.size();
    }

    public synchronized HashSet<Object> tags() {
        return new HashSet<Object>(this.metaData.keySet());
    }

    public synchronized HashMap tag(String name) {
        HashMap<Object, MetaDataValue> map = this.metaData.get(name);
        if (map == null) {
            return null;
        }
        return (HashMap)map.clone();
    }

    public synchronized boolean hasTag(String name) {
        return this.metaData.get(name) != null;
    }

    public void tag(Object tag) {
        this.addMetaData(tag, "$tagged$", new Object(), PayloadKey.TRANSIENT);
    }

    public void addMetaData(Object tag, Object attr, Object value) {
        this.addMetaData(tag, attr, value, PayloadKey.MARSHALLED);
    }

    public synchronized void addMetaData(Object tag, Object attr, Object value, PayloadKey type) {
        HashMap<Object, MetaDataValue> groupData = this.metaData.get(tag);
        if (groupData == null) {
            groupData = new HashMap();
            this.metaData.put(tag, groupData);
        }
        MetaDataValue val = new MetaDataValue(type, value);
        groupData.put(attr, val);
    }

    public synchronized Object getMetaData(Object tag, Object attr) {
        try {
            HashMap<Object, MetaDataValue> groupData = this.metaData.get(tag);
            if (groupData == null) {
                return null;
            }
            MetaDataValue val = groupData.get(attr);
            if (val == null) {
                return null;
            }
            return val.get();
        }
        catch (IOException ioex) {
            throw new RuntimeException("failed on MarshalledValue", ioex);
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException("failed on MarshalledValue", ex);
        }
    }

    public synchronized void removeMetaData(Object tag, Object attr) {
        HashMap<Object, MetaDataValue> groupData = this.metaData.get(tag);
        if (groupData != null) {
            groupData.remove(attr);
        }
    }

    public synchronized void removeGroupData(Object group) {
        this.metaData.remove(group);
    }

    public synchronized void clear() {
        this.metaData.clear();
    }

    public synchronized void mergeIn(SimpleMetaData data) {
        for (Object tag : data.metaData.keySet()) {
            HashMap<Object, MetaDataValue> attrs = data.metaData.get(tag);
            HashMap<Object, MetaDataValue> map = this.metaData.get(tag);
            if (map == null) {
                map = new HashMap();
                this.metaData.put(tag, map);
            }
            map.putAll(attrs);
        }
    }

    @Override
    public synchronized Object resolve(Invocation invocation, Object tag, Object attr) {
        return this.getMetaData(tag, attr);
    }

    @Override
    public SimpleMetaData getAllMetaData(Invocation invocation) {
        return this;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        for (Object group : this.metaData.keySet()) {
            HashMap<Object, MetaDataValue> map = this.metaData.get(group);
            if (map == null || map.size() <= 0) continue;
            boolean groupWritten = false;
            for (Object attr : map.keySet()) {
                MetaDataValue value = map.get(attr);
                if (value.type == PayloadKey.TRANSIENT) continue;
                if (!groupWritten) {
                    groupWritten = true;
                    out.writeObject(group);
                }
                out.writeObject(attr);
                if (value.type == PayloadKey.AS_IS) {
                    out.writeObject(value.value);
                    continue;
                }
                out.writeObject(new MarshalledValue(value.value));
            }
            if (!groupWritten) continue;
            out.writeObject(null);
        }
        out.writeObject(null);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        Object group;
        this.metaData = new HashMap();
        while ((group = in.readObject()) != null) {
            Object attr;
            HashMap<Object, MetaDataValue> map = new HashMap<Object, MetaDataValue>();
            this.metaData.put(group, map);
            while ((attr = in.readObject()) != null) {
                Object obj = in.readObject();
                if (obj instanceof MarshalledValue) {
                    map.put(attr, new MetaDataValue(PayloadKey.MARSHALLED, obj));
                    continue;
                }
                map.put(attr, new MetaDataValue(PayloadKey.AS_IS, obj));
            }
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(100);
        sb.append("[");
        sb.append("metaData=").append(this.metaData);
        sb.append("]");
        return sb.toString();
    }

    public class MetaDataValue
    implements Serializable {
        static final long serialVersionUID = -8024138149680591337L;
        public final PayloadKey type;
        public Object value;

        public MetaDataValue(PayloadKey type, Object value) {
            this.type = type;
            this.value = value;
        }

        public Object get() throws IOException, ClassNotFoundException {
            if (this.value instanceof MarshalledValue) {
                this.value = ((MarshalledValue)this.value).get();
            }
            return this.value;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer(100);
            sb.append("[");
            sb.append("type=").append(this.type);
            sb.append("value=").append(this.value);
            sb.append("]");
            return sb.toString();
        }
    }
}

