/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.instrument;

import javassist.CannotCompileException;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMember;
import javassist.CtMethod;
import javassist.Modifier;
import javassist.NotFoundException;
import javassist.expr.ExprEditor;
import javassist.expr.FieldAccess;
import org.jboss.aop.instrument.FieldAccessTransformer;
import org.jboss.aop.instrument.Instrumentor;
import org.jboss.aop.instrument.JoinpointClassification;

public class NonOptimizedFieldAccessTransformer
extends FieldAccessTransformer {
    public NonOptimizedFieldAccessTransformer(Instrumentor instrumentor) {
        super(instrumentor);
    }

    protected void doBuildFieldWrappers(CtClass clazz, CtField field, int fieldIndex, JoinpointClassification classificationGet, JoinpointClassification classificationSet) throws NotFoundException, CannotCompileException {
        this.instrumentor.setupBasics(clazz);
        boolean wrappedGet = classificationGet.equals(JoinpointClassification.WRAPPED);
        boolean wrappedSet = classificationSet.equals(JoinpointClassification.WRAPPED);
        int mod = this.getStaticModifiers(field);
        this.replaceFieldAccessInternally(clazz, field, wrappedGet, wrappedSet, fieldIndex);
        if (!Modifier.isPrivate((int)field.getModifiers())) {
            if (this.isPrepared(classificationGet)) {
                wrapper.prepareForWrapping((CtMember)field, 0);
            }
            if (this.isPrepared(classificationSet)) {
                wrapper.prepareForWrapping((CtMember)field, 1);
            }
            if (wrappedGet) {
                wrapper.wrap((CtMember)field, 0);
                if (classificationGet.equals(JoinpointClassification.DYNAMICALY_WRAPPED)) {
                    this.instrumentor.dynamicTransformationObserver.fieldReadDynamicalyWrapped(field);
                }
            }
            if (wrappedSet) {
                wrapper.wrap((CtMember)field, 1);
                if (classificationSet.equals(JoinpointClassification.DYNAMICALY_WRAPPED)) {
                    this.instrumentor.dynamicTransformationObserver.fieldWriteDynamicalyWrapped(field);
                }
            }
            this.buildWrapperPlaceHolders(clazz, field, this.isPrepared(classificationGet), this.isPrepared(classificationSet), mod);
            this.buildWrappers(clazz, field, this.isPrepared(classificationGet), this.isPrepared(classificationSet), fieldIndex);
        }
    }

    private void buildWrappers(CtClass clazz, CtField field, boolean doGet, boolean doSet, int index) throws NotFoundException, CannotCompileException {
        CtMethod method;
        String code;
        if (doGet) {
            code = this.getWrapperBody(clazz, field, true, index);
            method = clazz.getDeclaredMethod(NonOptimizedFieldAccessTransformer.fieldRead(field.getName()));
            method.setBody(code);
        }
        if (doSet) {
            code = this.getWrapperBody(clazz, field, false, index);
            method = clazz.getDeclaredMethod(NonOptimizedFieldAccessTransformer.fieldWrite(field.getName()));
            method.setBody(code);
        }
    }

    protected String getWrapperBody(CtClass clazz, CtField field, boolean get, int fieldIndex) throws NotFoundException, CannotCompileException {
        String name = field.getName();
        boolean isStatic = Modifier.isStatic((int)field.getModifiers());
        String access = "";
        String instanceCheck = "";
        if (!isStatic) {
            access = "((" + clazz.getName() + ")$1).";
            instanceCheck = " || ((org.jboss.aop.ClassInstanceAdvisor)((org.jboss.aop.InstanceAdvised)$1)._getInstanceAdvisor()).hasInstanceAspects";
        }
        if (get) {
            return "{     if (aop$classAdvisor$aop.hasAspects() " + instanceCheck + " ) " + "    { " + "       return ($r)" + "aop$classAdvisor$aop" + ".invokeRead($1, (int)" + fieldIndex + "); " + "    } " + "    return " + access + name + "; " + "}";
        }
        return "{     if (aop$classAdvisor$aop.hasAspects() " + instanceCheck + " ) " + "    { " + "       " + "aop$classAdvisor$aop" + ".invokeWrite($1, (int)" + fieldIndex + ", ($w)$2); " + "    } " + "    else " + "    { " + "       " + access + name + " = $2; " + "    } " + "}";
    }

    protected void replaceFieldAccessInternally(CtClass clazz, CtField field, boolean doGet, boolean doSet, int index) throws CannotCompileException {
        NonOptimizedFieldAccessExprEditor expr = new NonOptimizedFieldAccessExprEditor(clazz, field, doGet, doSet, index);
        clazz.instrument((ExprEditor)expr);
    }

    protected class NonOptimizedFieldAccessExprEditor
    extends FieldAccessTransformer.FieldAccessExprEditor {
        public NonOptimizedFieldAccessExprEditor(CtClass clazz, CtField field, boolean doGet, boolean doSet, int index) {
            super(NonOptimizedFieldAccessTransformer.this, clazz, field, doGet, doSet, index);
        }

        protected void replaceRead(FieldAccess fieldAccess) throws CannotCompileException {
            String code = null;
            try {
                if (fieldAccess.isStatic()) {
                    code = "    if (aop$classAdvisor$aop.hasAspects())     {        Object obj = null;       $_ = ($r)aop$classAdvisor$aop.invokeRead(obj, (int)" + this.fieldIndex + "); " + "    } " + "    else " + "    { " + "       $_ = " + this.clazz.getName() + "." + this.field.getName() + "; " + "    } " + "";
                    fieldAccess.replace(code);
                } else {
                    code = "    org.jboss.aop.ClassInstanceAdvisor instAdv = (org.jboss.aop.ClassInstanceAdvisor)((org.jboss.aop.InstanceAdvised)$0)._getInstanceAdvisor();    if (aop$classAdvisor$aop.hasAspects() || (instAdv != null && instAdv.hasInstanceAspects))     {        $_ = ($r)aop$classAdvisor$aop.invokeRead($0, (int)" + this.fieldIndex + "); " + "    } " + "    else " + "    { " + "       $_ = $0." + fieldAccess.getFieldName() + "; " + "    } ";
                    fieldAccess.replace(code);
                }
            }
            catch (CannotCompileException e) {
                throw new RuntimeException("failed with: " + code, e);
            }
        }

        protected void replaceWrite(FieldAccess fieldAccess) throws CannotCompileException {
            if (fieldAccess.isStatic()) {
                String code = "    if (aop$classAdvisor$aop.hasAspects())     {        Object obj = null;      aop$classAdvisor$aop.invokeWrite(obj, (int)" + this.fieldIndex + ", ($w)$1); " + "    } " + "    else " + "    { " + "       " + this.clazz.getName() + "." + fieldAccess.getFieldName() + " = $1; " + "    } ";
                fieldAccess.replace(code);
            } else {
                String code = "    org.jboss.aop.ClassInstanceAdvisor instAdv = (org.jboss.aop.ClassInstanceAdvisor)((org.jboss.aop.InstanceAdvised)$0)._getInstanceAdvisor();    if (aop$classAdvisor$aop.hasAspects() || (instAdv != null && instAdv.hasInstanceAspects))     {        aop$classAdvisor$aop.invokeWrite($0, (int)" + this.fieldIndex + ", ($w)$1); " + "    } " + "    else " + "    { " + "       $0." + fieldAccess.getFieldName() + " = $1; " + "    } ";
                fieldAccess.replace(code);
            }
        }
    }
}

