/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.proxy;

import java.lang.reflect.Field;
import java.security.ProtectionDomain;
import java.util.HashMap;
import java.util.HashSet;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewMethod;
import org.jboss.aop.AspectManager;
import org.jboss.aop.ClassInstanceAdvisor;
import org.jboss.aop.InstanceAdvisor;
import org.jboss.aop.instrument.TransformerCommon;
import org.jboss.aop.proxy.ClassProxyFactory;
import org.jboss.aop.proxy.Proxy;
import org.jboss.aop.proxy.ProxyMixin;
import org.jboss.aop.proxy.SecurityActions;
import org.jboss.aop.util.JavassistMethodHashing;
import org.jboss.util.collection.WeakValueHashMap;
import org.jboss.util.id.GUID;

public class ProxyFactory {
    private static long counter = 0L;
    private static WeakValueHashMap proxyCache = new WeakValueHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Proxy createInterfaceProxy(ClassLoader loader, Class[] interfaces, ProxyMixin[] mixins, InstanceAdvisor advisor) throws Exception {
        Class clazz = ProxyFactory.createProxyClass(loader, mixins, interfaces);
        Proxy instance = (Proxy)clazz.newInstance();
        instance.instanceAdvisor = advisor;
        instance.mixins = mixins;
        instance.interfaces = interfaces;
        instance.guid = new GUID();
        WeakValueHashMap weakValueHashMap = proxyCache;
        synchronized (weakValueHashMap) {
            proxyCache.put((Object)instance.guid, (Object)clazz);
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Class getProxyClass(GUID guid) {
        WeakValueHashMap weakValueHashMap = proxyCache;
        synchronized (weakValueHashMap) {
            return (Class)proxyCache.get((Object)guid);
        }
    }

    public static Proxy createInterfaceProxy(GUID guid, ClassLoader loader, Class[] interfaces) throws Exception {
        return ProxyFactory.createInterfaceProxy(guid, loader, interfaces, null, new ClassInstanceAdvisor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Proxy createInterfaceProxy(GUID guid, ClassLoader loader, Class[] interfaces, ProxyMixin[] mixins, InstanceAdvisor advisor) throws Exception {
        Class clazz = ProxyFactory.getProxyClass(guid);
        boolean wasFound = true;
        if (clazz == null) {
            wasFound = false;
            clazz = ProxyFactory.createProxyClass(loader, mixins, interfaces);
        }
        Proxy instance = (Proxy)clazz.newInstance();
        instance.instanceAdvisor = advisor;
        instance.mixins = mixins;
        instance.interfaces = interfaces;
        instance.guid = guid;
        if (!wasFound) {
            WeakValueHashMap weakValueHashMap = proxyCache;
            synchronized (weakValueHashMap) {
                proxyCache.put((Object)guid, (Object)clazz);
            }
        }
        return instance;
    }

    private static Class createProxyClass(ClassLoader loader, ProxyMixin[] mixins, Class[] interfaces) throws Exception {
        CtClass proxy = ProxyFactory.createProxyCtClass(loader, mixins, interfaces);
        int length = interfaces != null ? interfaces.length : 0;
        ProtectionDomain pd = null;
        for (int n = 0; n < interfaces.length && pd == null; ++n) {
            pd = interfaces[n].getProtectionDomain();
        }
        Class clazz = TransformerCommon.toClass(proxy, loader, pd);
        HashMap methodmap = ClassProxyFactory.getMethodMap(clazz);
        Field field = clazz.getDeclaredField("methodMap");
        SecurityActions.setAccessible(field);
        field.set(null, methodmap);
        return clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GUID generateProxyClass(ClassLoader loader, ProxyMixin[] mixins, Class[] interfaces) throws Exception {
        Class clazz = ProxyFactory.createProxyClass(loader, mixins, interfaces);
        GUID guid = new GUID();
        WeakValueHashMap weakValueHashMap = proxyCache;
        synchronized (weakValueHashMap) {
            proxyCache.put((Object)guid, (Object)clazz);
        }
        return guid;
    }

    private static CtClass createProxyCtClass(ClassLoader loader, ProxyMixin[] mixins, Class[] interfaces) throws Exception {
        int i;
        ClassPool pool = AspectManager.instance().findClassPool(loader);
        if (pool == null) {
            throw new NullPointerException("Could not find ClassPool");
        }
        String classname = "AOPProxy$" + counter++;
        CtClass base = pool.get("org.jboss.aop.proxy.Proxy");
        CtClass proxy = TransformerCommon.makeClass(pool, classname, base);
        proxy.addInterface(pool.get("org.jboss.aop.instrument.Untransformable"));
        CtClass map = pool.get("java.util.Map");
        CtField methodMap = new CtField(map, "methodMap", proxy);
        methodMap.setModifiers(10);
        proxy.addField(methodMap);
        CtMethod getMethodMap = CtNewMethod.getter((String)"getMethodMap", (CtField)methodMap);
        getMethodMap.setModifiers(1);
        proxy.addMethod(getMethodMap);
        HashSet<String> addedInterfaces = new HashSet<String>();
        HashSet<Long> addedMethods = new HashSet<Long>();
        if (mixins != null) {
            for (i = 0; i < mixins.length; ++i) {
                HashSet<Long> mixinMethods = new HashSet<Long>();
                Class[] mixinf = mixins[i].getInterfaces();
                ClassPool mixPool = AspectManager.instance().findClassPool(mixins[i].getMixin().getClass().getClassLoader());
                CtClass mixClass = mixPool.get(mixins[i].getMixin().getClass().getName());
                for (int j = 0; j < mixinf.length; ++j) {
                    if (addedInterfaces.contains(mixinf[j].getName())) {
                        throw new Exception("2 mixins are implementing the same interfaces");
                    }
                    ClassPool mixIntfPool = AspectManager.instance().findClassPool(mixinf[j].getClassLoader());
                    CtClass intfClass = mixIntfPool.get(mixinf[j].getName());
                    CtMethod[] methods = intfClass.getMethods();
                    for (int m = 0; m < methods.length; ++m) {
                        Long hash;
                        if (methods[m].getDeclaringClass().getName().equals("java.lang.Object") || mixinMethods.contains(hash = new Long(JavassistMethodHashing.methodHash(methods[m])))) continue;
                        if (addedMethods.contains(hash)) {
                            throw new Exception("More than one mixin has same method");
                        }
                        mixinMethods.add(hash);
                        addedMethods.add(hash);
                        String returnStr = methods[m].getReturnType().equals(CtClass.voidType) ? "" : "return ";
                        String code = "{   " + mixClass.getName() + " mixin = (" + mixClass.getName() + ")mixins[" + i + "].getMixin();" + "   " + returnStr + " mixin." + methods[m].getName() + "($$);" + "}";
                        CtMethod newMethod = CtNewMethod.make((CtClass)methods[m].getReturnType(), (String)methods[m].getName(), (CtClass[])methods[m].getParameterTypes(), (CtClass[])methods[m].getExceptionTypes(), (String)code, (CtClass)proxy);
                        newMethod.setModifiers(1);
                        proxy.addMethod(newMethod);
                    }
                    proxy.addInterface(intfClass);
                    addedInterfaces.add(intfClass.getName());
                }
            }
        }
        for (i = 0; i < interfaces.length; ++i) {
            if (addedInterfaces.contains(interfaces[i].getName())) continue;
            ClassPool mixPool = AspectManager.instance().findClassPool(interfaces[i].getClassLoader());
            CtClass intfClass = mixPool.get(interfaces[i].getName());
            CtMethod[] methods = intfClass.getMethods();
            for (int m = 0; m < methods.length; ++m) {
                Long hash;
                if (methods[m].getDeclaringClass().getName().equals("java.lang.Object") || addedMethods.contains(hash = new Long(JavassistMethodHashing.methodHash(methods[m])))) continue;
                addedMethods.add(hash);
                String aopReturnStr = methods[m].getReturnType().equals(CtClass.voidType) ? "" : "return ($r)";
                String args = "null";
                if (methods[m].getParameterTypes().length > 0) {
                    args = "$args";
                }
                String code = "{       org.jboss.aop.advice.Interceptor[] aspects = instanceAdvisor.getInterceptors();     org.jboss.aop.MethodInfo mi = new org.jboss.aop.MethodInfo();     mi.setHash(" + hash + "L);" + "    org.jboss.aop.proxy.ProxyMethodInvocation invocation = new org.jboss.aop.proxy.ProxyMethodInvocation(this, mi, aspects); " + "    invocation.setInstanceResolver(instanceAdvisor.getMetaData()); " + "    invocation.setArguments(" + args + "); " + "    " + aopReturnStr + " invocation.invokeNext(); " + "}";
                CtMethod newMethod = CtNewMethod.make((CtClass)methods[m].getReturnType(), (String)methods[m].getName(), (CtClass[])methods[m].getParameterTypes(), (CtClass[])methods[m].getExceptionTypes(), (String)code, (CtClass)proxy);
                newMethod.setModifiers(1);
                proxy.addMethod(newMethod);
            }
            proxy.addInterface(intfClass);
        }
        return proxy;
    }
}

