/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.standalone;

import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Package
implements Serializable {
    static final long serialVersionUID = 6188655039267365373L;
    public HashMap<String, Advisor> advisors = new HashMap();
    public HashMap<String, Package> packages = new HashMap();
    public String name;

    public Package(String name) {
        this.name = name;
    }

    static void parse(AspectManager manager, Class<?> clazz, Package root) {
        Advisor advisor = manager.findAdvisor(clazz);
        StringTokenizer tokenizer = new StringTokenizer(clazz.getName(), ".");
        while (tokenizer.hasMoreTokens()) {
            String pkgName = tokenizer.nextToken();
            if (tokenizer.hasMoreTokens()) {
                Package subpkg = root.packages.get(pkgName);
                if (subpkg == null) {
                    subpkg = new Package(pkgName);
                    root.packages.put(pkgName, subpkg);
                }
                root = subpkg;
                continue;
            }
            root.advisors.put(pkgName, advisor);
        }
    }

    public static Package aopClassMap() {
        return Package.aopClassMap(AspectManager.getTopLevelAspectManager());
    }

    public static Package aopClassMap(AspectManager manager) {
        Map<Class<?>, WeakReference<Advisor>> advisors = manager.getAdvisors();
        Iterator<Class<?>> it = advisors.keySet().iterator();
        Package root = new Package("classes");
        while (it.hasNext()) {
            Class<?> clazz = it.next();
            Package.parse(manager, clazz, root);
        }
        return root;
    }
}

