/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.instrument;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewConstructor;
import javassist.CtNewMethod;
import javassist.Modifier;
import javassist.NotFoundException;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.CallerConstructorInfo;
import org.jboss.aop.ClassAdvisor;
import org.jboss.aop.GeneratedClassAdvisor;
import org.jboss.aop.InstanceAdvisor;
import org.jboss.aop.JoinPointInfo;
import org.jboss.aop.advice.AdviceMethodProperties;
import org.jboss.aop.advice.AdviceType;
import org.jboss.aop.advice.GeneratedAdvisorInterceptor;
import org.jboss.aop.advice.InvalidAdviceException;
import org.jboss.aop.advice.NoMatchingAdviceException;
import org.jboss.aop.advice.Scope;
import org.jboss.aop.instrument.FieldJoinPointGenerator;
import org.jboss.aop.instrument.Instrumentor;
import org.jboss.aop.instrument.MethodJoinPointGenerator;
import org.jboss.aop.instrument.SecurityActions;
import org.jboss.aop.instrument.TransformerCommon;
import org.jboss.aop.instrument.Untransformable;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.JoinPointBean;
import org.jboss.aop.pointcut.ast.ASTCFlowExpression;
import org.jboss.aop.pointcut.ast.ClassExpression;
import org.jboss.aop.util.JavassistUtils;
import org.jboss.aop.util.ReflectToJavassist;
import org.jboss.aop.util.logging.AOPLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JoinPointGenerator {
    private static final AOPLogger logger = AOPLogger.getLogger(JoinPointGenerator.class);
    public static final String INFO_FIELD = "info";
    public static final String INITIALISED_LIGHTWEIGHT_INSTANCE_ASPECTS = "initialisedLightweightInstanceAspects";
    public static final String INITIALISE_LIGHTWEIGHT_INSTANCE_ASPECTS = "initialisePerInstanceAspects";
    public static final String IS_FOR_INSTANCE_ADVISOR = "isForInstanceAdvisor";
    public static final String INVOKE_JOINPOINT = "invokeJoinpoint";
    public static final String INVOKE_TARGET = "invokeTarget";
    public static final String DISPATCH = "dispatch";
    protected static final String TARGET_FIELD = "targetObject";
    protected static final String TYPED_TARGET_FIELD = "typedTargetObject";
    protected static final String CALLER_FIELD = "callingObject";
    protected static final String TYPED_CALLER_FIELD = "typedCallingObject";
    protected static final String GENERATED_CLASS_ADVISOR = GeneratedClassAdvisor.class.getName();
    public static final String GENERATE_JOINPOINT_CLASS = "generateJoinPointClass";
    private static final String CURRENT_ADVICE = "super.currentInterceptor";
    public static final String JOINPOINT_FIELD_PREFIX = "joinpoint_";
    public static final String JOINPOINT_CLASS_PREFIX = "JoinPoint_";
    private static final String RETURN_VALUE = "ret";
    private static final String THROWABLE = "t";
    protected static final String ARGUMENTS = "arguments";
    private static final String GET_ARGUMENTS = "getArguments()";
    protected static final CtClass[] EMPTY_CTCLASS_ARRAY = new CtClass[0];
    protected static final CtClass[] THROWS_THROWABLE;
    private final ArrayList<Integer> joinPointArguments;
    private final boolean nullArgsArray;
    private JoinPointParameters parameters;
    private static int increment;
    private Class<?> advisorClass;
    private String baseJoinPointClassName;
    protected String joinpointClassName;
    protected String joinpointFieldName;
    private String joinpointFqn;
    private Field joinpointField;
    private ThreadLocal<Set<Integer>> inconsistentTypeArgs;
    private HashMap<String, GeneratedClassInfo> generatedJoinPointClassCache = new HashMap();

    protected JoinPointGenerator(GeneratedClassAdvisor advisor, JoinPointInfo info, JoinPointParameters parameters, int argumentsSize, boolean nullArgsArray) {
        int i;
        this.parameters = parameters;
        this.advisorClass = advisor.getClass();
        this.nullArgsArray = nullArgsArray;
        Class<?>[] interfaces = this.advisorClass.getInterfaces();
        for (i = 0; i < interfaces.length; ++i) {
            if (!interfaces[i].equals(InstanceAdvisor.class)) continue;
            this.advisorClass = this.advisorClass.getSuperclass();
            break;
        }
        this.joinPointArguments = new ArrayList(argumentsSize);
        for (i = 0; i < argumentsSize; ++i) {
            this.joinPointArguments.add(i);
        }
        this.inconsistentTypeArgs = new ThreadLocal<Set<Integer>>(){

            @Override
            protected synchronized Set<Integer> initialValue() {
                return new HashSet<Integer>();
            }
        };
        this.initialiseJoinPointNames(info);
        this.findAdvisedField(info);
        this.initBaseJoinPointClassName(advisor);
    }

    private void initBaseJoinPointClassName(GeneratedClassAdvisor advisor) {
        Package pkg = advisor.getClass().getPackage();
        StringBuffer className = new StringBuffer();
        if (pkg != null) {
            className.append(pkg.getName());
            className.append(".");
        }
        className.append(this.joinpointClassName);
        className.append("_");
        this.baseJoinPointClassName = className.toString();
    }

    public void rebindJoinpoint(JoinPointInfo newInfo) {
        try {
            if (this.joinpointField == null) {
                return;
            }
            this.joinpointField.set(newInfo.getAdvisor(), null);
        }
        catch (Exception e) {
            e.printStackTrace();
            StringBuffer sb = new StringBuffer();
            this.debugClass(sb, newInfo.getAdvisor().getClass());
            System.out.println("==================== Error");
            System.out.println("Field: " + this.joinpointField);
            System.out.println("Field: " + this.joinpointField.getDeclaringClass() + " " + SecurityActions.getClassLoader(this.joinpointField.getDeclaringClass()));
            System.out.println("Value: " + newInfo.getAdvisor().getClass() + " " + SecurityActions.getClassLoader(newInfo.getAdvisor().getClass()));
            System.out.println(sb.toString());
            throw new RuntimeException(e);
        }
    }

    public void generateJoinPointClass() {
        this.generateJoinPointClass(null, null);
    }

    public synchronized Object generateJoinPointClass(ClassLoader classloader, JoinPointInfo info) {
        if (info == null) {
            throw new RuntimeException("GeneratedAdvisor weaving in AOP 2.0.0.aplha5 and later is not compatible with that of previous versions");
        }
        if (System.getSecurityManager() == null) {
            return GenerateJoinPointClassAction.NON_PRIVILEGED.generateJoinPointClass(classloader, this, info);
        }
        return GenerateJoinPointClassAction.PRIVILEGED.generateJoinPointClass(classloader, this, info);
    }

    private Object doGenerateJoinPointClass(ClassLoader classloader, JoinPointInfo info) {
        try {
            if (classloader == null) {
                logger.warn("No classloader specified " + info.getAdviceString());
                classloader = SecurityActions.getContextClassLoader();
            }
            String infoAdviceString = info.getAdviceString();
            GeneratedClassInfo generatedClass = null;
            if (this.generatedJoinPointClassCache.containsKey(infoAdviceString)) {
                generatedClass = this.generatedJoinPointClassCache.get(infoAdviceString);
            } else {
                AspectManager manager = AspectManager.instance();
                ClassPool pool = manager.findClassPool(classloader);
                ProtectionDomain pd = this.advisorClass.getProtectionDomain();
                generatedClass = this.generateJoinpointClass(pool, info, classloader, pd);
                this.generatedJoinPointClassCache.put(infoAdviceString, generatedClass);
            }
            Object obj = generatedClass.createJoinPointInstance(classloader, info);
            this.joinpointField.set(info.getAdvisor(), obj);
            return obj;
        }
        catch (NoMatchingAdviceException e) {
            throw e;
        }
        catch (InvalidAdviceException e) {
            throw e;
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new RuntimeException("Error generating joinpoint class for joinpoint " + info, e);
        }
    }

    private Class<?> toClass(ClassLoader classLoader, CtClass ctclass, ProtectionDomain pd) throws NotFoundException, CannotCompileException, ClassNotFoundException {
        return TransformerCommon.toClass(ctclass, classLoader, pd);
    }

    private StringBuffer debugClass(StringBuffer sb, Class<?> clazz) {
        sb.append("\n\t\t" + Modifier.toString((int)clazz.getModifiers()) + " " + clazz.getName() + " " + SecurityActions.getClassLoader(clazz));
        Field[] fields = clazz.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            sb.append("\n\t\t\t" + Modifier.toString((int)fields[i].getModifiers()) + " " + fields[i].getType().getName() + " " + fields[i].getName() + " " + SecurityActions.getClassLoader(fields[i].getType()));
        }
        Class<?> superClass = clazz.getSuperclass();
        if (superClass != null && superClass != Object.class) {
            sb.append("\n\t\t\textends\n");
            this.debugClass(sb, superClass);
        }
        return sb;
    }

    private static synchronized int getIncrement() {
        return ++increment;
    }

    protected String getJoinPointArg(int index) {
        return "this.arg" + index;
    }

    protected abstract void initialiseJoinPointNames(JoinPointInfo var1);

    private GeneratedClassInfo generateJoinpointClass(ClassPool pool, JoinPointInfo newInfo, ClassLoader classloader, ProtectionDomain pd) throws NotFoundException, CannotCompileException, ClassNotFoundException {
        CtClass superClass = pool.get(this.joinpointFqn);
        String className = this.getJoinpointClassName();
        try {
            CtClass clazz = TransformerCommon.makeClass(pool, className);
            clazz.setSuperclass(superClass);
            JoinPointGenerator.addUntransformableInterface(pool, clazz);
            AdviceSetups setups = this.initialiseAdviceInfosAndAddFields(pool, clazz, newInfo);
            this.createInitialisePerInstanceAspectsMethod(clazz, setups, newInfo.getClazz());
            this.createConstructors(pool, superClass, clazz, setups);
            this.createJoinPointInvokeMethod(superClass, clazz, this.isVoid(), setups, newInfo);
            this.createInvokeNextMethod(clazz, this.isVoid(), setups, newInfo);
            this.overrideDispatchMethods(superClass, clazz, newInfo);
            Class<?> loadedClass = this.toClass(classloader, clazz, pd);
            return new GeneratedClassInfo(loadedClass, setups);
        }
        catch (NotFoundException e) {
            logger.error("Exception generating " + className + ": " + e.getMessage(), e);
            throw e;
        }
        catch (CannotCompileException e) {
            logger.error("Exception generating " + className + ": " + e.getMessage(), e);
            throw e;
        }
        catch (ClassNotFoundException e) {
            logger.error("Exception generating " + className + ": " + e.getMessage(), e);
            throw e;
        }
    }

    private String getJoinpointClassName() {
        return this.baseJoinPointClassName + JoinPointGenerator.getIncrement();
    }

    private void createInitialisePerInstanceAspectsMethod(CtClass clazz, AdviceSetups setups, Class<?> advisedClass) throws CannotCompileException, NotFoundException {
        if (setups.hasLightweightAdvicesRequiringInstanceAdvisor()) {
            StringBuffer code = new StringBuffer("{");
            for (AdviceSetup setup : setups.getLightweightAdvicesRequiringInstanceAdvisor()) {
                AdviceType type = setup.getType();
                if (type == AdviceType.AROUND || !setup.requiresInstanceAdvisor()) continue;
                code.append(this.getPerInstanceAspectCode("$1", setup, false));
            }
            code.append("}");
            String name = advisedClass.getName();
            CtClass ctTarget = clazz.getClassPool().get(name);
            CtMethod method = CtNewMethod.make((int)2, (CtClass)CtClass.voidType, (String)INITIALISE_LIGHTWEIGHT_INSTANCE_ASPECTS, (CtClass[])new CtClass[]{ctTarget}, (CtClass[])EMPTY_CTCLASS_ARRAY, (String)code.toString(), (CtClass)clazz);
            clazz.addMethod(method);
        }
    }

    protected abstract boolean isVoid();

    protected abstract Class<?> getReturnClassType();

    protected abstract AdviceMethodProperties getAdviceMethodProperties(JoinPointBean var1, AdviceSetup var2);

    protected boolean isCaller() {
        return false;
    }

    protected boolean hasCallingObject() {
        return false;
    }

    protected abstract boolean hasTargetObject();

    private boolean isStaticCall() {
        if (this.isCaller()) {
            return !this.hasCallingObject();
        }
        return !this.hasTargetObject();
    }

    private void findAdvisedField(JoinPointInfo info) {
        Class<?> advisorClass;
        block8: {
            if (info.getClazz() == null) {
                return;
            }
            advisorClass = null;
            if (info.getAdvisor().getClazz().equals(info.getClazz())) {
                advisorClass = info.getAdvisor().getClass();
            } else {
                AspectManager manager = info.getAdvisor().getManager();
                try {
                    advisorClass = manager.getAdvisor(info.getClazz()).getClass();
                }
                catch (ClassCastException e) {
                    Advisor advisor = manager.findAdvisor(info.getClazz());
                    if (advisor == null || advisor instanceof ClassAdvisor) break block8;
                    return;
                }
            }
        }
        try {
            this.joinpointField = advisorClass.getField(this.joinpointFieldName);
            SecurityActions.setAccessible(this.joinpointField);
            this.joinpointFqn = advisorClass.getDeclaringClass().getName() + "$" + this.joinpointClassName;
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        catch (NoClassDefFoundError e) {
            throw e;
        }
    }

    private AdviceSetups initialiseAdviceInfosAndAddFields(ClassPool pool, CtClass clazz, JoinPointInfo info) throws ClassNotFoundException, NotFoundException, CannotCompileException {
        HashMap<String, Integer> cflows = new HashMap<String, Integer>();
        ArrayList<AdviceSetup> setups = new ArrayList<AdviceSetup>(info.getInterceptors().length);
        ClassLoader classLoader = pool.getClassLoader();
        if (classLoader == null) {
            logger.warn("No classloader specified " + clazz.getName(), new Throwable("STACKTRACE"));
            classLoader = SecurityActions.getContextClassLoader();
        }
        for (int i = 0; i < info.getInterceptors().length; ++i) {
            AdviceSetup setup = new AdviceSetup(i, (GeneratedAdvisorInterceptor)info.getInterceptors()[i], info, classLoader);
            if (!setup.shouldInvokeAspect()) continue;
            setups.add(setup);
            this.addAspectFieldAndGetter(pool, clazz, setup);
            this.addCFlowFieldsAndGetters(pool, setup, clazz, cflows);
        }
        this.addLightweightInstanceAspectsTrackerFields(clazz);
        AdviceSetup[] setupArray = setups.toArray(new AdviceSetup[setups.size()]);
        return new AdviceSetups(info, setupArray);
    }

    private void addAspectFieldAndGetter(ClassPool pool, CtClass clazz, AdviceSetup setup) throws NotFoundException, CannotCompileException {
        CtClass aspectClass = setup.getAspectCtClass();
        CtField field = new CtField(aspectClass, setup.getAspectFieldName(), clazz);
        field.setModifiers(130);
        clazz.addField(field);
        String body = this.getAspectFieldGetterBody(setup);
        CtMethod method = CtNewMethod.make((CtClass)aspectClass, (String)setup.getAspectInitialiserName(), (CtClass[])new CtClass[0], (CtClass[])new CtClass[0], (String)body, (CtClass)clazz);
        method.setModifiers(2);
        clazz.addMethod(method);
    }

    private String getAspectFieldGetterBody(AdviceSetup setup) {
        if (setup.requiresInstanceAdvisor()) {
            String instanceAdvisor = this.isCaller() ? CALLER_FIELD : TARGET_FIELD;
            return this.getPerInstanceAspectCode(instanceAdvisor, setup, true);
        }
        return "{   if (" + setup.getAspectFieldName() + " != null)" + "   {" + "      return " + setup.getAspectFieldName() + ";" + "   }" + "   org.jboss.aop.advice.GeneratedAdvisorInterceptor fw = (org.jboss.aop.advice.GeneratedAdvisorInterceptor)info.getInterceptors()[" + setup.getIndex() + "];" + "   Object o = fw.getAspect(info.getAdvisor(), info.getJoinpoint());" + "   return (" + setup.getAspectClass().getName() + ")o;" + "}";
    }

    private String getPerInstanceAspectCode(String objectWithInstanceAdvisor, AdviceSetup setup, boolean shouldReturn) {
        String instanceAdvisor = "org.jboss.aop.InstanceAdvisor ia = ((org.jboss.aop.Advised)" + objectWithInstanceAdvisor + ")._getInstanceAdvisor();";
        String assignOrReturn = shouldReturn ? "return " : setup.getAspectFieldName() + " = ";
        return "{   " + instanceAdvisor + "   org.jboss.aop.advice.GeneratedAdvisorInterceptor fw = (org.jboss.aop.advice.GeneratedAdvisorInterceptor)info.getInterceptors()[" + setup.getIndex() + "];" + "   Object o = fw.getPerInstanceAspect(info.getAdvisor(), info.getJoinpoint(), ia);" + "   " + assignOrReturn + "(" + setup.getAspectClass().getName() + ")o;" + "}";
    }

    private void addCFlowFieldsAndGetters(ClassPool pool, AdviceSetup setup, CtClass clazz, HashMap<String, Integer> cflows) throws NotFoundException, CannotCompileException {
        if (setup.getCFlowString() != null) {
            Integer useCFlowIndex = cflows.get(setup.getCFlowString());
            if (useCFlowIndex == null) {
                useCFlowIndex = new Integer(setup.getIndex());
                cflows.put(setup.getCFlowString(), useCFlowIndex);
                CtField cflowX = new CtField(pool.get(ASTCFlowExpression.class.getName()), "cflow" + useCFlowIndex, clazz);
                clazz.addField(cflowX);
                CtField matchesCFlowX = new CtField(CtClass.booleanType, "matchesCflow" + useCFlowIndex, clazz);
                clazz.addField(matchesCFlowX);
                String initCFlowXBody = "{   org.jboss.aop.pointcut.CFlowMatcher matcher = new org.jboss.aop.pointcut.CFlowMatcher();   return matcher.matches(" + cflowX.getName() + ", this);" + "}";
                CtMethod initCFlowX = CtNewMethod.make((CtClass)CtClass.booleanType, (String)("getCFlow" + useCFlowIndex), (CtClass[])new CtClass[0], (CtClass[])new CtClass[0], (String)initCFlowXBody, (CtClass)clazz);
                clazz.addMethod(initCFlowX);
            }
            setup.setUseCFlowFrom(useCFlowIndex);
        }
    }

    private void addLightweightInstanceAspectsTrackerFields(CtClass clazz) throws CannotCompileException {
        CtField initialised = new CtField(CtClass.booleanType, INITIALISED_LIGHTWEIGHT_INSTANCE_ASPECTS, clazz);
        clazz.addField(initialised);
        CtField forInstance = new CtField(CtClass.booleanType, IS_FOR_INSTANCE_ADVISOR, clazz);
        clazz.addField(forInstance);
    }

    private void createJoinPointInvokeMethod(CtClass superClass, CtClass clazz, boolean isVoid, AdviceSetups setups, JoinPointInfo info) throws CannotCompileException, NotFoundException {
        CtMethod superInvoke = superClass.getDeclaredMethod(INVOKE_JOINPOINT);
        String code = null;
        try {
            code = this.createJoinpointInvokeBody(superClass, clazz, setups, superInvoke.getExceptionTypes(), superInvoke.getParameterTypes(), info);
            CtMethod invoke = CtNewMethod.make((CtClass)superInvoke.getReturnType(), (String)superInvoke.getName(), (CtClass[])superInvoke.getParameterTypes(), (CtClass[])superInvoke.getExceptionTypes(), (String)code, (CtClass)clazz);
            clazz.addMethod(invoke);
        }
        catch (CannotCompileException e) {
            throw new RuntimeException("Error compiling code for Joinpoint (" + info.getJoinpoint() + "): " + code + "\n - " + (Object)((Object)e) + "\n - " + JoinPointGenerator.getMethodString(clazz, superInvoke.getName(), superInvoke.getParameterTypes()) + "\n - " + clazz.getName(), e);
        }
    }

    private String createJoinpointInvokeBody(CtClass joinpointSuperClass, CtClass joinpointClass, AdviceSetups setups, CtClass[] declaredExceptions, CtClass[] parameterTypes, JoinPointInfo info) throws NotFoundException {
        DefaultAdviceCallStrategy defaultCall = DefaultAdviceCallStrategy.getInstance();
        AfterThrowingAdviceCallStrategy afterThrowingCall = AfterThrowingAdviceCallStrategy.getInstance();
        AfterAdviceCallStrategy afterCall = AfterAdviceCallStrategy.getInstance();
        StringBuffer code = new StringBuffer();
        code.append("{");
        if (!this.isVoid()) {
            String ret = null;
            Class<?> retType = this.getReturnClassType();
            if (retType.isPrimitive()) {
                if (retType.equals(Boolean.TYPE)) {
                    ret = "false";
                } else if (retType.equals(Character.TYPE)) {
                    ret = "'\\0'";
                } else if (retType.equals(Byte.TYPE)) {
                    ret = "(byte)0";
                } else if (retType.equals(Short.TYPE)) {
                    ret = "(short)0";
                } else if (retType.equals(Integer.TYPE)) {
                    ret = "(int)0";
                } else if (retType.equals(Long.TYPE)) {
                    ret = "0L";
                } else if (retType.equals(Float.TYPE)) {
                    ret = "0.0f";
                } else if (retType.equals(Double.TYPE)) {
                    ret = "0.0d";
                }
            }
            code.append("   " + ClassExpression.simpleType(this.getReturnClassType()) + "  " + RETURN_VALUE + " = " + ret + ";");
        }
        code.append("Throwable ").append(THROWABLE).append(" = null;");
        this.addInitialiseLightweightPerInstanceAdvicesCode(joinpointSuperClass, info, code, setups);
        code.append("   try");
        code.append("   {");
        boolean argsFoundBefore = defaultCall.addInvokeCode(this, setups.getByType(AdviceType.BEFORE), code, info);
        boolean joinPointCreated = this.addAroundInvokeCode(code, setups, joinpointClass, argsFoundBefore, parameterTypes);
        StringBuffer afterCode = new StringBuffer();
        boolean argsFoundAfter = afterCall.addInvokeCode(this, setups.getByType(AdviceType.AFTER), afterCode, info);
        afterCode.append("   }");
        afterCode.append("   catch(java.lang.Throwable throwable)");
        afterCode.append("   {");
        afterCode.append(THROWABLE).append(" = ").append("throwable;");
        argsFoundAfter = afterThrowingCall.addInvokeCode(this, setups.getByType(AdviceType.THROWING), afterCode, info) || argsFoundAfter;
        afterCode.append("throw t;");
        afterCode.append("   }");
        AdviceSetup[] finallySetups = setups.getByType(AdviceType.FINALLY);
        if (finallySetups != null && finallySetups.length > 0) {
            afterCode.append("   finally {");
            argsFoundAfter = afterCall.addInvokeCode(this, finallySetups, afterCode, info) || argsFoundAfter;
            afterCode.append("}");
        }
        if (joinPointCreated && (argsFoundAfter || this.inconsistentTypeArgs.get().size() < this.joinPointArguments.size())) {
            code.append(ARGUMENTS);
            code.append(" = jp.").append(GET_ARGUMENTS).append(";");
            argsFoundAfter = true;
        }
        code.append(afterCode.toString());
        if (!this.isVoid()) {
            code.append("   return ret;");
        }
        code.append("}");
        if (argsFoundBefore || argsFoundAfter) {
            code.insert(1, this.parameters.declareArgsArray(parameterTypes.length, this.nullArgsArray));
        }
        return code.toString();
    }

    private void addInitialiseLightweightPerInstanceAdvicesCode(CtClass joinpointSuperClass, JoinPointInfo info, StringBuffer code, AdviceSetups setups) {
        if (setups.hasLightweightAdvicesRequiringInstanceAdvisor()) {
            if (!this.hasCallingObject() && !this.hasTargetObject()) {
                return;
            }
            String instanceAdvisor = "$" + this.parameters.getContextIndex();
            code.append("if (!initialisedLightweightInstanceAspects){");
            code.append("   if(isForInstanceAdvisor){");
            code.append("      initialisePerInstanceAspects(" + instanceAdvisor + ");");
            code.append("initialisedLightweightInstanceAspects = true;");
            code.append("   }else{");
            code.append("      org.jboss.aop.GeneratedClassAdvisor instanceAdvisor = (org.jboss.aop.GeneratedClassAdvisor)((org.jboss.aop.Advised)" + instanceAdvisor + ")._getInstanceAdvisor();");
            code.append("      Object objJp = instanceAdvisor.createAndRebindJoinPointForInstance((org.jboss.aop.JoinPointInfo)super.info);");
            code.append("      " + joinpointSuperClass.getName() + " jp = (" + joinpointSuperClass.getName() + ")objJp;");
            if (this.isVoid()) {
                code.append("      jp.invokeJoinpoint($$);");
                code.append("return;");
            } else {
                code.append("      return jp.invokeJoinpoint($$);");
            }
            code.append("   }");
            code.append("}");
        }
    }

    private boolean addAroundInvokeCode(StringBuffer code, AdviceSetups setups, CtClass joinpointClass, boolean argsFoundBefore, CtClass[] parameterTypes) throws NotFoundException {
        if (setups.getByType(AdviceType.AROUND) != null) {
            StringBuffer aspects = new StringBuffer();
            StringBuffer cflows = new StringBuffer();
            AdviceSetup[] asetups = setups.getAllSetups();
            for (int i = 0; i < asetups.length; ++i) {
                if (!asetups[i].requiresInstanceAdvisor()) {
                    aspects.append(", ");
                    aspects.append(asetups[i].getAspectFieldName());
                }
                if (!asetups[i].isNewCFlow()) continue;
                cflows.append(", cflow" + asetups[i].getIndex());
            }
            code.append(this.joinpointFqn).append(" jp = new " + joinpointClass.getName() + "(this");
            if (argsFoundBefore) {
                this.parameters.appendParameterListWithoutArgs(code);
            } else {
                code.append(", $$");
            }
            code.append(aspects.toString() + cflows.toString() + ");");
            if (argsFoundBefore) {
                code.append("   jp.setArguments(");
                code.append(ARGUMENTS);
                code.append(");");
            }
            if (setups.getHasArgsAroundAdvices()) {
                code.append("try{");
                code.append("   org.jboss.aop.joinpoint.CurrentInvocation.push(jp); ");
            }
            if (!this.isVoid()) {
                code.append("          ret = ($r)");
            }
            code.append("jp.invokeNext();");
            if (setups.getHasArgsAroundAdvices()) {
                code.append("}finally{");
                code.append("   org.jboss.aop.joinpoint.CurrentInvocation.pop(); ");
                code.append("}");
            }
            this.inconsistentTypeArgs.get().addAll(this.joinPointArguments);
            return true;
        }
        this.addDispatchCode(code, parameterTypes, argsFoundBefore);
        return false;
    }

    private final void addDispatchCode(StringBuffer code, CtClass[] parameterTypes, boolean argsFound) {
        if (!this.isVoid()) {
            code.append("          ret = ($r)");
        }
        code.append("super.dispatch(");
        if (argsFound) {
            this.parameters.appendParameterList(code, parameterTypes);
        } else {
            code.append("$$");
        }
        code.append(");");
    }

    private void createInvokeNextMethod(CtClass jp, boolean isVoid, AdviceSetups setups, JoinPointInfo info) throws NotFoundException, CannotCompileException {
        AdviceSetup[] aroundSetups = setups.getByType(AdviceType.AROUND);
        if (aroundSetups == null) {
            return;
        }
        CtMethod method = jp.getSuperclass().getSuperclass().getDeclaredMethod("invokeNext");
        CtMethod invokeNext = CtNewMethod.copy((CtMethod)method, (CtClass)jp, null);
        String code = this.createInvokeNextMethodBody(jp, isVoid, aroundSetups, info);
        try {
            invokeNext.setBody(code);
        }
        catch (CannotCompileException e) {
            throw new RuntimeException("Error creating invokeNext method: " + code, e);
        }
        jp.addMethod(invokeNext);
    }

    private String createInvokeNextMethodBody(CtClass jp, boolean isVoid, AdviceSetup[] aroundSetups, JoinPointInfo info) throws NotFoundException {
        String returnStr = isVoid ? "" : "return ($w)";
        StringBuffer body = new StringBuffer();
        body.append("{");
        body.append("   try{");
        body.append("      switch(++super.currentInterceptor){");
        new AroundAdviceCallStrategy().addInvokeCode(this, aroundSetups, body, info);
        body.append("      default:");
        body.append("         " + returnStr + "this.dispatch();");
        body.append("      }");
        body.append("   }finally{");
        body.append("      --super.currentInterceptor;");
        body.append("   }");
        body.append("   return null;");
        body.append("}");
        return body.toString();
    }

    private void createConstructors(ClassPool pool, CtClass superClass, CtClass clazz, AdviceSetups setups) throws NotFoundException, CannotCompileException {
        CtConstructor[] superCtors = superClass.getDeclaredConstructors();
        if (superCtors.length != 3 && superCtors.length != 2 && !this.getClass().equals(MethodJoinPointGenerator.class) && !FieldJoinPointGenerator.class.isAssignableFrom(this.getClass())) {
            throw new RuntimeException("JoinPoints should have 2 or 3 constructors, not " + superCtors.length);
        }
        if (superCtors.length != 4 && superCtors.length != 3 && this.getClass().equals(MethodJoinPointGenerator.class)) {
            throw new RuntimeException("Method JoinPoints should have 3 or 4 constructors, not " + superCtors.length);
        }
        int publicIndex = -1;
        int protectedIndex1 = -1;
        int protectedIndex2 = -1;
        int defaultIndex = -1;
        for (int i = 0; i < superCtors.length; ++i) {
            int modifier = superCtors[i].getModifiers();
            if (Modifier.isPublic((int)modifier)) {
                if (superCtors[i].getParameterTypes().length == 0) {
                    defaultIndex = i;
                    continue;
                }
                publicIndex = i;
                continue;
            }
            if (!Modifier.isProtected((int)modifier)) continue;
            if (protectedIndex1 == -1) {
                protectedIndex1 = i;
                continue;
            }
            protectedIndex2 = i;
        }
        if (publicIndex < 0 || protectedIndex1 < 0) {
            throw new RuntimeException("One of the JoinPoint constructors should be public, and at least one of them should be protected");
        }
        if (defaultIndex >= 0) {
            this.createDefaultConstructor(superCtors[defaultIndex], clazz);
        }
        this.createPublicConstructor(pool, superCtors[publicIndex], clazz, setups);
        if (protectedIndex2 == -1) {
            this.createProtectedConstructors(pool, superCtors[protectedIndex1], null, clazz, setups);
        } else {
            this.createProtectedConstructors(pool, superCtors[protectedIndex1], superCtors[protectedIndex2], clazz, setups);
        }
        this.createCopyConstructorAndMethod(pool, clazz);
    }

    private void createDefaultConstructor(CtConstructor superCtor, CtClass clazz) throws CannotCompileException {
        CtConstructor ctor = CtNewConstructor.defaultConstructor((CtClass)clazz);
        clazz.addConstructor(ctor);
    }

    private void createPublicConstructor(ClassPool pool, CtConstructor superCtor, CtClass clazz, AdviceSetups setups) throws CannotCompileException, NotFoundException {
        StringBuffer body = new StringBuffer();
        try {
            AdviceSetup[] aroundSetups = setups.getByType(AdviceType.AROUND);
            int size = 0;
            int firstIndex = superCtor.getParameterTypes().length;
            if (aroundSetups != null) {
                for (int i = 0; i < aroundSetups.length; ++i) {
                    if (!aroundSetups[i].isNewCFlow()) continue;
                    ++size;
                    body.append("cflow").append(aroundSetups[i].useCFlowFrom());
                    body.append(" = $").append(++firstIndex).append(";");
                }
            }
            CtClass[] paramTypes = null;
            if (size > 0) {
                paramTypes = new CtClass[firstIndex];
                CtClass[] superCtorParamTypes = superCtor.getParameterTypes();
                System.arraycopy(superCtorParamTypes, 0, paramTypes, 0, superCtorParamTypes.length);
                CtClass astCFlowExpression = pool.get(ASTCFlowExpression.class.getName());
                for (int i = superCtorParamTypes.length; i < firstIndex; ++i) {
                    paramTypes[i] = astCFlowExpression;
                }
                String cflowInitialization = body.toString();
                body.setLength(0);
                body.append("{super(");
                body.append("$1");
                for (int i = 1; i < superCtorParamTypes.length; ++i) {
                    body.append(",$" + (i + 1));
                }
                body.append(");");
                body.append(cflowInitialization);
            } else {
                body.append("{super($$);");
                paramTypes = superCtor.getParameterTypes();
            }
            body.append(IS_FOR_INSTANCE_ADVISOR).append("=($1.getAdvisor() instanceof ");
            body.append(InstanceAdvisor.class.getName()).append(");");
            AdviceSetup[] allSetups = setups.getAllSetups();
            for (int i = 0; i < allSetups.length; ++i) {
                if (allSetups[i].requiresInstanceAdvisor()) continue;
                body.append(allSetups[i].getAspectFieldName() + " = " + allSetups[i].getAspectInitialiserName() + "();");
            }
            body.append("}");
            CtConstructor ctor = CtNewConstructor.make((CtClass[])paramTypes, (CtClass[])superCtor.getExceptionTypes(), (String)body.toString(), (CtClass)clazz);
            ctor.setModifiers(superCtor.getModifiers());
            clazz.addConstructor(ctor);
        }
        catch (CannotCompileException e) {
            throw new CannotCompileException("Error compiling. Code \n" + body.toString(), (Throwable)e);
        }
    }

    private void createProtectedConstructors(ClassPool pool, CtConstructor superCtor1, CtConstructor superCtor2, CtClass clazz, AdviceSetups setups) throws CannotCompileException, NotFoundException {
        ArrayList<AdviceSetup> aspects = new ArrayList<AdviceSetup>();
        ArrayList<Integer> cflows = new ArrayList<Integer>();
        StringBuffer adviceInit = new StringBuffer();
        AdviceSetup[] allSetups = setups.getAllSetups();
        for (int i = 0; i < allSetups.length; ++i) {
            if (allSetups[i].requiresInstanceAdvisor()) {
                adviceInit.append(allSetups[i].getAspectFieldName());
                adviceInit.append(" = ");
                adviceInit.append(allSetups[i].getAspectInitialiserName());
                adviceInit.append("();");
            } else {
                aspects.add(allSetups[i]);
            }
            if (!allSetups[i].isNewCFlow()) continue;
            cflows.add(allSetups[i].useCFlowFrom());
        }
        this.createProtectedConstructor(pool, clazz, superCtor1, allSetups, aspects, cflows, adviceInit.toString());
        if (superCtor2 != null) {
            this.createProtectedConstructor(pool, clazz, superCtor2, allSetups, aspects, cflows, adviceInit.toString());
        }
    }

    private void createProtectedConstructor(ClassPool pool, CtClass clazz, CtConstructor superCtor, AdviceSetup[] allSetups, ArrayList<AdviceSetup> aspects, ArrayList<Integer> cflows, String aspectInitialization) throws NotFoundException, CannotCompileException {
        int i;
        CtClass[] superParams = superCtor.getParameterTypes();
        CtClass[] params = new CtClass[superParams.length + aspects.size() + cflows.size()];
        System.arraycopy(superParams, 0, params, 0, superParams.length);
        StringBuffer init = new StringBuffer();
        for (int i2 = 0; i2 < aspects.size(); ++i2) {
            AdviceSetup setup = aspects.get(i2);
            params[i2 + superParams.length] = setup.getAspectCtClass();
            init.append("this." + setup.getAspectFieldName() + " = $" + (i2 + superParams.length + 1) + ";");
        }
        int aspectsLength = superParams.length + aspects.size();
        if (cflows.size() > 0) {
            CtClass astCFlowExpr = pool.get(ASTCFlowExpression.class.getName());
            for (i = 0; i < cflows.size(); ++i) {
                params[i + aspectsLength] = astCFlowExpr;
                init.append("cflow" + cflows.get(i) + "= $" + (i + aspectsLength + 1) + ";");
                init.append("matchesCflow" + cflows.get(i) + " = getCFlow" + allSetups[cflows.get(i)].useCFlowFrom() + "();");
            }
        }
        StringBuffer body = new StringBuffer("{super(");
        for (i = 0; i < superParams.length; ++i) {
            if (i > 0) {
                body.append(", ");
            }
            body.append("$" + (i + 1));
        }
        body.append(");");
        body.append(aspectInitialization);
        body.append(init.toString());
        body.append("}");
        CtConstructor ctor = CtNewConstructor.make((CtClass[])params, (CtClass[])superCtor.getExceptionTypes(), (String)body.toString(), (CtClass)clazz);
        ctor.setModifiers(superCtor.getModifiers());
        clazz.addConstructor(ctor);
    }

    private void createCopyConstructorAndMethod(ClassPool pool, CtClass clazz) throws NotFoundException, CannotCompileException {
        StringBuffer body = new StringBuffer();
        body.append("{");
        body.append("   super($1.info);");
        for (CtClass superClass = clazz; superClass != null && !superClass.getName().equals("java.lang.Object"); superClass = superClass.getSuperclass()) {
            CtField[] fields = superClass.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                if (Modifier.isPrivate((int)fields[i].getModifiers()) && fields[i].getDeclaringClass() != clazz || Modifier.isFinal((int)fields[i].getModifiers()) || Modifier.isStatic((int)fields[i].getModifiers())) continue;
                body.append("   this." + fields[i].getName() + " = $1." + fields[i].getName() + ";");
            }
        }
        body.append("}");
        CtConstructor copyCtor = CtNewConstructor.make((CtClass[])new CtClass[]{clazz}, (CtClass[])new CtClass[0], (String)body.toString(), (CtClass)clazz);
        copyCtor.setModifiers(2);
        clazz.addConstructor(copyCtor);
        CtMethod superCopy = pool.get(Invocation.class.getName()).getDeclaredMethod("copy");
        String copyBody = "{   return new " + clazz.getName() + "(this);" + "}";
        CtMethod copy = CtNewMethod.make((CtClass)superCopy.getReturnType(), (String)superCopy.getName(), (CtClass[])new CtClass[0], (CtClass[])new CtClass[0], (String)copyBody, (CtClass)clazz);
        clazz.setModifiers(1);
        clazz.addMethod(copy);
    }

    protected void overrideDispatchMethods(CtClass superClass, CtClass clazz, JoinPointInfo newInfo) throws CannotCompileException, NotFoundException {
    }

    protected void overrideDispatchMethods(CtClass superClass, CtClass clazz, CallerConstructorInfo cinfo) throws NotFoundException, CannotCompileException {
        if (cinfo.getWrappingMethod() == null) {
            return;
        }
        CtMethod[] superDispatches = JavassistUtils.getDeclaredMethodsWithName(superClass, DISPATCH);
        if (superDispatches.length > 2 && AspectManager.verbose && logger.isDebugEnabled()) {
            logger.debug("Too many dispatch() methods found in " + superClass.getName());
        }
        for (int i = 0; i < superDispatches.length; ++i) {
            CtMethod wrapperMethod = ReflectToJavassist.methodToJavassist(cinfo.getWrappingMethod());
            CtClass[] params = wrapperMethod.getParameterTypes();
            StringBuffer parameters = new StringBuffer("(");
            if (superDispatches[i].getParameterTypes().length == 0) {
                for (int j = 0; j < params.length; ++j) {
                    if (j > 0) {
                        parameters.append(", ");
                    }
                    parameters.append("arg" + j);
                }
            } else {
                int offset = this.hasCallingObject() ? 1 : 0;
                for (int j = 0; j < params.length; ++j) {
                    if (j > 0) {
                        parameters.append(", ");
                    }
                    parameters.append("$" + (j + offset + 1));
                }
            }
            parameters.append(")");
            String body = "{ return " + cinfo.getConstructor().getDeclaringClass().getName() + "." + cinfo.getWrappingMethod().getName() + parameters + ";}";
            try {
                CtMethod dispatch = CtNewMethod.make((CtClass)superDispatches[i].getReturnType(), (String)superDispatches[i].getName(), (CtClass[])superDispatches[i].getParameterTypes(), (CtClass[])superDispatches[i].getExceptionTypes(), (String)body, (CtClass)clazz);
                dispatch.setModifiers(superDispatches[i].getModifiers());
                clazz.addMethod(dispatch);
                continue;
            }
            catch (CannotCompileException e) {
                throw new RuntimeException("Could not compile code " + body + " for method " + JoinPointGenerator.getMethodString(clazz, superDispatches[i].getName(), superDispatches[i].getParameterTypes()), e);
            }
        }
    }

    protected static void addUntransformableInterface(Instrumentor instrumentor, CtClass clazz) throws NotFoundException {
        JoinPointGenerator.addUntransformableInterface(instrumentor.getClassPool(), clazz);
    }

    protected static void addUntransformableInterface(ClassPool pool, CtClass clazz) throws NotFoundException {
        CtClass untransformable = pool.get(Untransformable.class.getName());
        clazz.addInterface(untransformable);
    }

    protected static String getMethodString(CtClass joinpoint, String method, CtClass[] params) {
        StringBuffer sb = new StringBuffer();
        sb.append(joinpoint);
        sb.append(".");
        sb.append("name");
        sb.append("(");
        for (int i = 0; i < params.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(params[i].getName());
        }
        sb.append(")");
        return sb.toString();
    }

    protected Field getJoinpointField() {
        return this.joinpointField;
    }

    static {
        try {
            THROWS_THROWABLE = new CtClass[]{AspectManager.instance().findClassPool(SecurityActions.getContextClassLoader()).get("java.lang.Throwable")};
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    protected static class JoinPointParameters {
        public static final JoinPointParameters ONLY_ARGS = new JoinPointParameters(false, -1, false, -1, 0, null);
        public static final JoinPointParameters TARGET_ARGS = new JoinPointParameters(true, 1, false, -1, 1, "$1");
        public static final JoinPointParameters CALLER_ARGS = new JoinPointParameters(false, -1, true, 1, 1, "$1");
        public static final JoinPointParameters TARGET_CALLER_ARGS = new JoinPointParameters(true, 1, true, 2, 2, "$1, $2");
        private boolean target;
        private boolean caller;
        private int targetIndex;
        private int callerIndex;
        private int firstArgIndex;
        private String targetCallerList;
        private static final String[][] primitiveExtractions = new String[][]{{"((Boolean) arguments [", "]).booleanValue()"}, {"((Integer) arguments[", "]).intValue()"}, {"((Double) arguments[", "]).doubleValue()"}, {"((Float) arguments[", "]).floatValue()"}, {"((Character) arguments[", "]).charValue()"}, {"((Byte) arguments [", "]).byteValue()"}, {"((Long) arguments[", "]).longValue()"}, {"((Short) arguments[", "]).shortValue()"}};

        private JoinPointParameters(boolean target, int targetIndex, boolean caller, int callerIndex, int firstArgIndex, String targetCallerList) {
            this.target = target;
            this.targetIndex = targetIndex;
            this.caller = caller;
            this.callerIndex = callerIndex;
            this.firstArgIndex = firstArgIndex + 1;
            this.targetCallerList = targetCallerList;
        }

        public final boolean hasTarget() {
            return this.target;
        }

        public final int getTargetIndex() {
            return this.targetIndex;
        }

        public final boolean hasCaller() {
            return this.caller;
        }

        public final int getCallerIndex() {
            return this.callerIndex;
        }

        public final int getContextIndex() {
            return this.caller ? this.callerIndex : this.targetIndex;
        }

        public final int getFirstArgIndex() {
            return this.firstArgIndex;
        }

        public final String declareArgsArray(int totalParameters, boolean nullArgsArray) {
            StringBuffer buffer = new StringBuffer("Object[] ");
            buffer.append(JoinPointGenerator.ARGUMENTS);
            if (++totalParameters == this.firstArgIndex) {
                if (nullArgsArray) {
                    buffer.append(" = null;");
                } else {
                    buffer.append(" = new Object[0];");
                }
            } else {
                buffer.append(" = new Object[]{($w)$");
                buffer.append(this.firstArgIndex);
                for (int i = this.firstArgIndex + 1; i < totalParameters; ++i) {
                    buffer.append(", ($w)$");
                    buffer.append(i);
                }
                buffer.append("};");
            }
            return buffer.toString();
        }

        public final void appendParameterList(StringBuffer code, CtClass[] parameterTypes) {
            int j = this.firstArgIndex - 1;
            int totalParameters = parameterTypes.length - j;
            if (this.targetCallerList != null) {
                code.append(this.targetCallerList);
            }
            if (totalParameters == 0) {
                return;
            }
            if (this.targetCallerList != null) {
                code.append(", ");
            }
            this.castArgument(code, parameterTypes[j++], 0);
            int i = 1;
            while (i < totalParameters) {
                code.append(", ");
                this.castArgument(code, parameterTypes[j], i);
                ++i;
                ++j;
            }
        }

        public final void appendParameterListWithoutArgs(StringBuffer code) {
            if (this.targetCallerList != null) {
                code.append(',');
                code.append(this.targetCallerList);
            }
        }

        public final void castArgument(StringBuffer code, CtClass expectedType, int i) {
            if (expectedType.isPrimitive()) {
                String[] extraction = null;
                if (expectedType == CtClass.booleanType) {
                    extraction = primitiveExtractions[0];
                } else if (expectedType == CtClass.intType) {
                    extraction = primitiveExtractions[1];
                } else if (expectedType == CtClass.doubleType) {
                    extraction = primitiveExtractions[2];
                } else if (expectedType == CtClass.floatType) {
                    extraction = primitiveExtractions[3];
                } else if (expectedType == CtClass.charType) {
                    extraction = primitiveExtractions[4];
                } else if (expectedType == CtClass.byteType) {
                    extraction = primitiveExtractions[5];
                } else if (expectedType == CtClass.longType) {
                    extraction = primitiveExtractions[6];
                } else if (expectedType == CtClass.shortType) {
                    extraction = primitiveExtractions[7];
                }
                code.append(extraction[0]);
                code.append(i);
                code.append(extraction[1]);
            } else {
                code.append("(");
                code.append(expectedType.getName());
                code.append(") ");
                code.append(JoinPointGenerator.ARGUMENTS);
                code.append("[");
                code.append(i);
                code.append("]");
            }
        }
    }

    private static class AfterThrowingAdviceCallStrategy
    extends AdviceCallStrategy {
        private static AfterThrowingAdviceCallStrategy INSTANCE = new AfterThrowingAdviceCallStrategy();

        private AfterThrowingAdviceCallStrategy() {
        }

        public static final AfterThrowingAdviceCallStrategy getInstance() {
            return INSTANCE;
        }

        public boolean appendAdviceCall(AdviceSetup setup, String key, StringBuffer beforeCall, StringBuffer call, JoinPointGenerator generator, JoinPointInfo info) {
            Class<?> throwableType;
            int[] args = setup.getAdviceMethodProperties().getArgs();
            int throwableIndex = -1;
            for (int i = 0; i < args.length; ++i) {
                if (args[i] != -5) continue;
                throwableIndex = i;
            }
            if (throwableIndex != -1 && (throwableType = setup.getAdviceMethodProperties().getAdviceMethod().getParameterTypes()[throwableIndex]) != Throwable.class) {
                call.append("if (").append(JoinPointGenerator.THROWABLE).append(" instanceof ");
                call.append(throwableType.getName()).append(") {");
                boolean result = ((AdviceCallStrategy)this).appendAdviceCall(setup, beforeCall, call, generator);
                call.append("}");
                return result;
            }
            return ((AdviceCallStrategy)this).appendAdviceCall(setup, beforeCall, call, generator);
        }

        protected String generateKey(JoinPointGenerator generator) {
            return null;
        }
    }

    private static class AfterAdviceCallStrategy
    extends AdviceCallStrategy {
        private static AfterAdviceCallStrategy INSTANCE = new AfterAdviceCallStrategy();

        public static final AfterAdviceCallStrategy getInstance() {
            return INSTANCE;
        }

        private AfterAdviceCallStrategy() {
        }

        public String generateKey(JoinPointGenerator generator) {
            if (generator.isVoid()) {
                return "";
            }
            return "          ret = (" + generator.getReturnClassType().getName() + ")";
        }

        public boolean appendAdviceCall(AdviceSetup setup, String key, StringBuffer beforeCall, StringBuffer call, JoinPointGenerator generator, JoinPointInfo info) throws NotFoundException {
            AdviceMethodProperties properties = setup.getAdviceMethodProperties();
            if (properties != null && !properties.isAdviceVoid()) {
                call.append(key);
            }
            return ((AdviceCallStrategy)this).appendAdviceCall(setup, beforeCall, call, generator);
        }
    }

    private static class DefaultAdviceCallStrategy
    extends AdviceCallStrategy {
        private static DefaultAdviceCallStrategy INSTANCE = new DefaultAdviceCallStrategy();

        public static final DefaultAdviceCallStrategy getInstance() {
            return INSTANCE;
        }

        private DefaultAdviceCallStrategy() {
        }

        public String generateKey(JoinPointGenerator generator) {
            return null;
        }

        public boolean appendAdviceCall(AdviceSetup setup, String key, StringBuffer beforeCall, StringBuffer call, JoinPointGenerator generator, JoinPointInfo info) {
            return ((AdviceCallStrategy)this).appendAdviceCall(setup, beforeCall, call, generator);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AroundAdviceCallStrategy
    extends AdviceCallStrategy {
        private int addedAdvice = 0;
        private boolean consistencyEnforced = false;

        private AroundAdviceCallStrategy() {
        }

        @Override
        public String generateKey(JoinPointGenerator generator) {
            this.addedAdvice = 0;
            if (generator.isVoid()) {
                return "";
            }
            return "return ($w)";
        }

        @Override
        public boolean appendAdviceCall(AdviceSetup setup, String key, StringBuffer beforeCall, StringBuffer call, JoinPointGenerator generator, JoinPointInfo info) {
            boolean result = false;
            AdviceMethodProperties properties = setup.getAdviceMethodProperties();
            if (properties == null || properties.getAdviceMethod() == null) {
                return false;
            }
            beforeCall.append("      case ");
            beforeCall.append(++this.addedAdvice);
            beforeCall.append(":");
            if (setup.getCFlowString() != null) {
                beforeCall.append("         if (matchesCflow" + setup.useCFlowFrom() + ")");
                beforeCall.append("         {");
                result = this.appendAroundCallString(beforeCall, call, key, setup, properties, generator);
                call.append("         }");
                call.append("         else");
                call.append("         {");
                call.append("            ");
                call.append(key);
                call.append(" invokeNext();");
                call.append("         }");
            } else {
                result = this.appendAroundCallString(beforeCall, call, key, setup, properties, generator);
            }
            call.append("      break;");
            return result;
        }

        public boolean appendAroundCallString(StringBuffer beforeCall, StringBuffer call, String returnStr, AdviceSetup setup, AdviceMethodProperties properties, JoinPointGenerator generator) {
            this.consistencyEnforced = false;
            call.append("   ");
            call.append(returnStr);
            call.append(" ");
            boolean result = ((AdviceCallStrategy)this).appendAdviceCall(setup, beforeCall, call, generator);
            return result;
        }

        @Override
        protected boolean appendParameter(StringBuffer beforeCall, StringBuffer call, int arg, Class<?> adviceParam, AdviceMethodProperties properties, JoinPointGenerator generator) {
            switch (arg) {
                case -3: {
                    if (!generator.parameters.hasTarget()) break;
                    call.append(JoinPointGenerator.TYPED_TARGET_FIELD);
                    return false;
                }
                case -7: {
                    if (!generator.parameters.hasCaller()) break;
                    call.append(JoinPointGenerator.TYPED_CALLER_FIELD);
                    return false;
                }
                case -6: {
                    call.append(JoinPointGenerator.GET_ARGUMENTS);
                    return true;
                }
            }
            if (arg >= 0) {
                if (!this.consistencyEnforced) {
                    beforeCall.append("enforceArgsConsistency");
                    beforeCall.append("();");
                    this.consistencyEnforced = true;
                }
                call.append(generator.getJoinPointArg(arg));
                return false;
            }
            return super.appendParameter(beforeCall, call, arg, adviceParam, properties, generator);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class AdviceCallStrategy {
        private AdviceCallStrategy() {
        }

        public boolean addInvokeCode(JoinPointGenerator generator, AdviceSetup[] setups, StringBuffer code, JoinPointInfo info) throws NotFoundException {
            StringBuffer call = new StringBuffer();
            if (setups == null || setups.length == 0) {
                return false;
            }
            boolean argsFound = false;
            String key = this.generateKey(generator);
            for (int i = 0; i < setups.length; ++i) {
                call.setLength(0);
                argsFound = this.appendAdviceCall(setups[i], key, code, call, generator, info) || argsFound;
                code.append(call);
                call.setLength(0);
            }
            return argsFound;
        }

        protected abstract String generateKey(JoinPointGenerator var1);

        protected abstract boolean appendAdviceCall(AdviceSetup var1, String var2, StringBuffer var3, StringBuffer var4, JoinPointGenerator var5, JoinPointInfo var6) throws NotFoundException;

        private final boolean appendAdviceCall(AdviceSetup setup, StringBuffer beforeCall, StringBuffer call, JoinPointGenerator generator) {
            AdviceMethodProperties properties = setup.getAdviceMethodProperties();
            if (properties == null) {
                return false;
            }
            call.append(setup.getAspectFieldName());
            call.append(".");
            call.append(setup.getAdviceName());
            call.append("(");
            int[] args = properties.getArgs();
            boolean argsFound = false;
            if (args.length > 0) {
                Class<?>[] adviceParams = properties.getAdviceMethod().getParameterTypes();
                if (properties.isAdviceOverloaded()) {
                    this.appendCast(call, adviceParams[0]);
                }
                argsFound = this.appendParameter(beforeCall, call, args[0], adviceParams[0], properties, generator);
                for (int i = 1; i < args.length; ++i) {
                    call.append(", ");
                    if (properties.isAdviceOverloaded()) {
                        this.appendCast(call, adviceParams[i]);
                    }
                    argsFound = this.appendParameter(beforeCall, call, args[i], adviceParams[i], properties, generator) || argsFound;
                }
            }
            call.append(");\n");
            return argsFound;
        }

        protected boolean appendParameter(StringBuffer beforeCall, StringBuffer call, int arg, Class<?> adviceParam, AdviceMethodProperties properties, JoinPointGenerator generator) {
            switch (arg) {
                case -2: {
                    call.append("this");
                    break;
                }
                case -1: {
                    call.append(JoinPointGenerator.INFO_FIELD);
                    break;
                }
                case -4: {
                    call.append(JoinPointGenerator.RETURN_VALUE);
                    break;
                }
                case -5: {
                    call.append('(').append(adviceParam.getName()).append(')');
                    call.append(JoinPointGenerator.THROWABLE);
                    break;
                }
                case -3: {
                    if (!generator.parameters.hasTarget()) {
                        call.append("null");
                        break;
                    }
                    call.append('$');
                    call.append(generator.parameters.getTargetIndex());
                    break;
                }
                case -7: {
                    if (!generator.parameters.hasCaller()) {
                        call.append("null");
                        break;
                    }
                    call.append('$');
                    call.append(generator.parameters.getCallerIndex());
                    break;
                }
                case -6: {
                    call.append(JoinPointGenerator.ARGUMENTS);
                    ((Set)generator.inconsistentTypeArgs.get()).addAll(generator.joinPointArguments);
                    return true;
                }
                default: {
                    Set inconsistentTypeArgs = (Set)generator.inconsistentTypeArgs.get();
                    if (inconsistentTypeArgs.contains(arg)) {
                        int argIndex = arg + generator.parameters.getFirstArgIndex();
                        beforeCall.append("$").append(argIndex).append(" = ");
                        beforeCall.append(ReflectToJavassist.castInvocationValueToTypeString(properties.getJoinpointParameterClassTypes()[arg], "arguments[" + arg + ']'));
                        beforeCall.append(';');
                        inconsistentTypeArgs.remove(arg);
                    }
                    call.append("$");
                    call.append(arg + generator.parameters.getFirstArgIndex());
                }
            }
            return false;
        }

        protected void appendCast(StringBuffer call, Class<?> adviceParam) {
            call.append("(");
            call.append(ClassExpression.simpleType(adviceParam));
            call.append(")");
        }
    }

    private static interface GenerateJoinPointClassAction {
        public static final GenerateJoinPointClassAction PRIVILEGED = new GenerateJoinPointClassAction(){

            public Object generateJoinPointClass(final ClassLoader classloader, final JoinPointGenerator joinPointGenerator, final JoinPointInfo info) {
                try {
                    return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                        @Override
                        public Object run() throws Exception {
                            return joinPointGenerator.doGenerateJoinPointClass(classloader, info);
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    Exception actual = e.getException();
                    if (actual instanceof RuntimeException) {
                        throw (RuntimeException)actual;
                    }
                    throw new RuntimeException(actual);
                }
            }
        };
        public static final GenerateJoinPointClassAction NON_PRIVILEGED = new GenerateJoinPointClassAction(){

            public Object generateJoinPointClass(ClassLoader classloader, JoinPointGenerator joinPointGenerator, JoinPointInfo info) {
                return joinPointGenerator.doGenerateJoinPointClass(classloader, info);
            }
        };

        public Object generateJoinPointClass(ClassLoader var1, JoinPointGenerator var2, JoinPointInfo var3);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AdviceSetups {
        AdviceSetup[] allSetups;
        AdviceSetup[][] setups;
        List<AdviceSetup> lightweightAdvicesRequiringInstanceAdvisor;
        boolean hasAroundAdvices;
        boolean hasArgsAroundAdvices;

        AdviceSetups(JoinPointInfo info, AdviceSetup[] allSetups) {
            int i;
            this.allSetups = allSetups;
            int length = AdviceType.values().length;
            ArrayList[] aspects = new ArrayList[length];
            for (i = 0; i < allSetups.length; ++i) {
                AdviceMethodProperties properties = JoinPointGenerator.this.getAdviceMethodProperties(info, allSetups[i]);
                AdviceType type = allSetups[i].getType();
                int index = type.ordinal();
                if (aspects[index] == null) {
                    aspects[index] = new ArrayList();
                }
                properties = type.getFactory().findAdviceMethod(properties);
                allSetups[i].setAdviceMethodProperties(properties);
                aspects[index].add(allSetups[i]);
                if (AdviceType.AROUND == type) {
                    this.hasAroundAdvices = true;
                    if (this.hasArgsAroundAdvices || this.hasInvocation(properties)) continue;
                    this.hasArgsAroundAdvices = true;
                    continue;
                }
                if (!allSetups[i].requiresInstanceAdvisor()) continue;
                if (this.lightweightAdvicesRequiringInstanceAdvisor == null) {
                    this.lightweightAdvicesRequiringInstanceAdvisor = new ArrayList<AdviceSetup>();
                }
                this.lightweightAdvicesRequiringInstanceAdvisor.add(allSetups[i]);
            }
            this.setups = new AdviceSetup[length][];
            for (i = 0; i < length; ++i) {
                this.setups[i] = aspects[i] == null ? null : aspects[i].toArray(new AdviceSetup[aspects[i].size()]);
            }
        }

        private boolean hasInvocation(AdviceMethodProperties properties) {
            int[] args = properties.getArgs();
            for (int z = 0; z < args.length; ++z) {
                if (args[z] != -2) continue;
                return true;
            }
            return false;
        }

        public AdviceSetup[] getAllSetups() {
            return this.allSetups;
        }

        public AdviceSetup[] getByType(AdviceType type) {
            return this.setups[type.ordinal()];
        }

        public boolean hasLightweightAdvicesRequiringInstanceAdvisor() {
            return this.lightweightAdvicesRequiringInstanceAdvisor != null && this.lightweightAdvicesRequiringInstanceAdvisor.size() > 0;
        }

        public List<AdviceSetup> getLightweightAdvicesRequiringInstanceAdvisor() {
            return this.lightweightAdvicesRequiringInstanceAdvisor;
        }

        public boolean getHasArgsAroundAdvices() {
            return this.hasArgsAroundAdvices;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class GeneratedClassInfo {
        Object[] ctorParams;
        Constructor<?> publicConstructor;

        GeneratedClassInfo(Class<?> generated, AdviceSetups setups) {
            AdviceSetup[] aroundSetups = setups.getByType(AdviceType.AROUND);
            int size = 0;
            if (aroundSetups != null) {
                for (int i = 0; i < aroundSetups.length; ++i) {
                    if (!aroundSetups[i].isNewCFlow()) continue;
                    ++size;
                }
            }
            this.ctorParams = new Object[size + 1];
            if (size > 0) {
                int j = 1;
                for (int i = 0; i < aroundSetups.length; ++i) {
                    if (!aroundSetups[i].isNewCFlow()) continue;
                    this.ctorParams[j++] = aroundSetups[i].getCFlow();
                }
            }
            for (Constructor<?> currentConstructor : generated.getDeclaredConstructors()) {
                if (currentConstructor.getParameterTypes().length <= 0 || !Modifier.isPublic((int)currentConstructor.getModifiers())) continue;
                this.publicConstructor = currentConstructor;
            }
        }

        Object createJoinPointInstance(ClassLoader classloader, JoinPointInfo info) {
            try {
                this.ctorParams[0] = info;
                return this.publicConstructor.newInstance(this.ctorParams);
            }
            catch (Exception e) {
                StringBuffer sb = new StringBuffer();
                throw new RuntimeException(JoinPointGenerator.this.debugClass(sb, this.publicConstructor.getDeclaringClass()).toString(), e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class AdviceSetup {
        int index;
        Class<?> aspectClass;
        CtClass aspectCtClass;
        String adviceName;
        Class<?> thrownType;
        Scope scope;
        String registeredName;
        String cflowString;
        ASTCFlowExpression cflowExpr;
        int cflowIndex;
        AdviceType type;
        AdviceMethodProperties adviceMethodProperties;

        AdviceSetup(int index, GeneratedAdvisorInterceptor ifw, JoinPointInfo info, ClassLoader classLoader) throws ClassNotFoundException, NotFoundException {
            this.index = index;
            this.scope = ifw.getScope();
            this.adviceName = ifw.getAdviceName();
            this.registeredName = ifw.getRegisteredName();
            this.cflowString = ifw.getCFlowString();
            this.cflowExpr = ifw.getCflowExpression();
            if (ifw.isAspectFactory()) {
                Object aspectInstance = ((GeneratedAdvisorInterceptor)info.getInterceptors()[index]).getAspect(info.getAdvisor(), info.getJoinpoint(), true);
                if (aspectInstance != null) {
                    this.aspectClass = aspectInstance.getClass();
                }
            } else {
                this.aspectClass = classLoader.loadClass(ifw.getAspectClassName());
            }
            if (this.aspectClass != null) {
                this.aspectCtClass = ReflectToJavassist.classToJavassist(this.aspectClass);
            }
            this.type = ifw.getType();
        }

        String getAdviceName() {
            return this.adviceName;
        }

        Class<?> getAspectClass() {
            return this.aspectClass;
        }

        CtClass getAspectCtClass() {
            return this.aspectCtClass;
        }

        Scope getScope() {
            return this.scope;
        }

        int getIndex() {
            return this.index;
        }

        String getRegisteredName() {
            return this.registeredName;
        }

        String getAspectFieldName() {
            StringBuffer name = new StringBuffer();
            name.append(this.type.getName());
            name.append(this.index + 1);
            return name.toString();
        }

        String getAspectInitialiserName() {
            StringBuffer name = new StringBuffer();
            name.append(this.type.getAccessor());
            name.append(this.index + 1);
            return name.toString();
        }

        boolean isPerInstance() {
            return this.scope == Scope.PER_INSTANCE;
        }

        boolean isPerJoinpoint() {
            return this.scope == Scope.PER_JOINPOINT;
        }

        boolean shouldInvokeAspect() {
            return (!this.isPerInstance() || !JoinPointGenerator.this.isStaticCall()) && this.aspectClass != null;
        }

        boolean requiresInstanceAdvisor() {
            return this.isPerInstance() || this.isPerJoinpoint() && !JoinPointGenerator.this.isStaticCall();
        }

        String getCFlowString() {
            return this.cflowString;
        }

        ASTCFlowExpression getCFlow() {
            return this.cflowExpr;
        }

        void setUseCFlowFrom(int index) {
            this.cflowIndex = index;
        }

        int useCFlowFrom() {
            return this.cflowIndex;
        }

        boolean isNewCFlow() {
            return this.getCFlowString() != null && this.index == this.cflowIndex;
        }

        public AdviceType getType() {
            return this.type;
        }

        public AdviceMethodProperties getAdviceMethodProperties() {
            return this.adviceMethodProperties;
        }

        public void setAdviceMethodProperties(AdviceMethodProperties adviceMethodProperties) {
            this.adviceMethodProperties = adviceMethodProperties;
        }
    }
}

