/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.instrument;

import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.Modifier;
import javassist.NotFoundException;
import org.jboss.aop.classpool.AOPClassPool;
import org.jboss.aop.instrument.Instrumentor;
import org.jboss.aop.instrument.OptimizedBehaviourInvocations;
import org.jboss.aop.instrument.OptimizedConstructorInvocations;
import org.jboss.aop.instrument.OptimizedMethodInvocations;
import org.jboss.aop.instrument.TransformerCommon;
import org.jboss.logging.Logger;

public class OptimizedCallerInvocations
extends OptimizedBehaviourInvocations {
    private static final Logger logger = Logger.getLogger(OptimizedBehaviourInvocations.class);

    protected static String createOptimizedMethodCalledByConInvocationClass(Instrumentor instrumentor, String className, CtClass callingClass, CtMethod method, int callingIndex, long calledHash) throws NotFoundException, CannotCompileException {
        return OptimizedCallerInvocations.createOptimizedMethodCalledInvocationClass(instrumentor, className, callingClass, method, "org.jboss.aop.joinpoint.MethodCalledByConstructorInvocation", "this.calling, ");
    }

    protected static String createOptimizedMethodCalledByMethodInvocationClass(Instrumentor instrumentor, String className, CtClass callingClass, CtMethod method, long callingHash, long calledHash) throws NotFoundException, CannotCompileException {
        return OptimizedCallerInvocations.createOptimizedMethodCalledInvocationClass(instrumentor, className, callingClass, method, "org.jboss.aop.joinpoint.MethodCalledByMethodInvocation", "this.callingClass, this.callingMethod, ");
    }

    protected static String createOptimizedConCalledByConInvocationClass(Instrumentor instrumentor, String className, CtClass callingClass, CtConstructor con, int callingIndex, long calledHash) throws NotFoundException, CannotCompileException {
        return OptimizedCallerInvocations.createOptimizedConCalledInvocationClass(instrumentor, className, callingClass, con, "org.jboss.aop.joinpoint.ConstructorCalledByConstructorInvocation", "this.calling, ");
    }

    protected static String createOptimizedConCalledByMethodInvocationClass(Instrumentor instrumentor, String className, CtClass callingClass, CtConstructor con, long callingHash, long calledHash) throws NotFoundException, CannotCompileException {
        return OptimizedCallerInvocations.createOptimizedConCalledInvocationClass(instrumentor, className, callingClass, con, "org.jboss.aop.joinpoint.ConstructorCalledByMethodInvocation", "this.callingClass, this.callingMethod, ");
    }

    private static String createOptimizedMethodCalledInvocationClass(Instrumentor instrumentor, String className, CtClass callingClass, CtMethod method, String invocationClassName, String callerDescription) throws NotFoundException, CannotCompileException {
        AOPClassPool pool = (AOPClassPool)instrumentor.getClassPool();
        CtClass methodInvocation = pool.get(invocationClassName);
        CtClass invocation = OptimizedCallerInvocations.makeInvocationClass(pool, true, callingClass, className, methodInvocation);
        CtClass[] params = method.getParameterTypes();
        OptimizedCallerInvocations.addArgumentFieldsAndAccessors((ClassPool)pool, invocation, params, false);
        boolean isStatic = Modifier.isStatic((int)method.getModifiers());
        if (!isStatic) {
            CtField target = new CtField(method.getDeclaringClass(), "typedTargetObject", invocation);
            target.setModifiers(1);
            invocation.addField(target);
        }
        OptimizedMethodInvocations.addDispatch(invocation, "invokeTarget", method, isStatic);
        String copy = "";
        if (!Modifier.isStatic((int)method.getModifiers())) {
            copy = "wrapper.typedTargetObject = typedTargetObject;";
        }
        OptimizedCallerInvocations.addCopyMethod(invocation, callerDescription, "this.method, this.callingObject, this.targetObject, ", copy, params.length);
        TransformerCommon.compileOrLoadClass(callingClass, invocation);
        return invocation.getName();
    }

    private static String createOptimizedConCalledInvocationClass(Instrumentor instrumentor, String className, CtClass callingClass, CtConstructor con, String invocationClassName, String callerDescription) throws NotFoundException, CannotCompileException {
        AOPClassPool pool = (AOPClassPool)instrumentor.getClassPool();
        CtClass conInvocation = pool.get(invocationClassName);
        CtClass invocation = OptimizedCallerInvocations.makeInvocationClass(pool, true, callingClass, className, conInvocation);
        CtClass[] params = con.getParameterTypes();
        OptimizedCallerInvocations.addArgumentFieldsAndAccessors((ClassPool)pool, invocation, params, false);
        OptimizedConstructorInvocations.addDispatch(invocation, "invokeTarget", con);
        OptimizedCallerInvocations.addCopyMethod(invocation, callerDescription, "this.constructor, this.wrappingMethod, this.callingObject, ", "", params.length);
        TransformerCommon.compileOrLoadClass(callingClass, invocation);
        return invocation.getName();
    }

    private static void addCopyMethod(CtClass invocation, String callerDescription, String calledDescription, String copyText, int paramsLength) throws NotFoundException, CannotCompileException {
        CtMethod copyTemplate = invocation.getSuperclass().getDeclaredMethod("copy");
        String copyCode = "{    " + invocation.getName() + " wrapper = new " + invocation.getName() + "(this.advisor, " + callerDescription + calledDescription + "this.arguments, this.interceptors);" + "   wrapper.metadata = this.metadata; " + "   wrapper.currentInterceptor = this.currentInterceptor; " + "   wrapper.instanceResolver = this.instanceResolver; " + "   wrapper.targetObject = this.targetObject; " + "   wrapper.responseContextInfo = this.responseContextInfo; " + copyText;
        for (int i = 0; i < paramsLength; ++i) {
            copyCode = copyCode + "   wrapper.arg" + i + " = this.arg" + i + "; ";
        }
        copyCode = copyCode + "   return wrapper; }";
        CtMethod copy = null;
        try {
            copy = CtNewMethod.make((CtClass)copyTemplate.getReturnType(), (String)"copy", (CtClass[])copyTemplate.getParameterTypes(), (CtClass[])copyTemplate.getExceptionTypes(), (String)copyCode, (CtClass)invocation);
        }
        catch (CannotCompileException e) {
            logger.error((Object)copyCode);
            throw e;
        }
        copy.setModifiers(copyTemplate.getModifiers());
        invocation.addMethod(copy);
    }
}

