/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop;

import java.lang.ref.WeakReference;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.DomainDefinition;
import org.jboss.aop.DynamicAOPStrategy;
import org.jboss.aop.InterceptionMarkers;
import org.jboss.aop.SecurityActions;
import org.jboss.aop.advice.AdviceBinding;
import org.jboss.aop.advice.AdviceStack;
import org.jboss.aop.advice.AspectDefinition;
import org.jboss.aop.advice.ClassifiedBindingAndPointcutCollection;
import org.jboss.aop.advice.DynamicCFlowDefinition;
import org.jboss.aop.advice.InterceptorFactory;
import org.jboss.aop.advice.PrecedenceDef;
import org.jboss.aop.array.ArrayReplacement;
import org.jboss.aop.introduction.AnnotationIntroduction;
import org.jboss.aop.introduction.InterfaceIntroduction;
import org.jboss.aop.metadata.ClassMetaDataBinding;
import org.jboss.aop.metadata.ClassMetaDataLoader;
import org.jboss.aop.microcontainer.lifecycle.LifecycleCallbackBinding;
import org.jboss.aop.pointcut.CFlowStack;
import org.jboss.aop.pointcut.DynamicCFlow;
import org.jboss.aop.pointcut.Pointcut;
import org.jboss.aop.pointcut.PointcutInfo;
import org.jboss.aop.pointcut.Typedef;
import org.jboss.aop.pointcut.ast.ClassExpression;
import org.jboss.aop.util.UnmodifiableEmptyCollections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Domain
extends AspectManager {
    String name;
    protected AspectManager parent;
    protected boolean parentFirst;
    protected boolean inheritsDeclarations = true;
    protected boolean inheritsBindings = false;
    protected boolean hasOwnPointcuts;
    protected boolean hasOwnBindings;
    protected boolean hasOwnAnnotationIntroductions;
    protected boolean hasOwnAnnotationOverrides;
    protected boolean hasOwnInterfaceIntroductions;
    protected boolean hasOwnTypedefs;
    protected boolean hasOwnPrecedenceDefs;
    protected boolean hasOwnClassMetaData;
    private static int sequenceNumber;

    public Domain(AspectManager manager, String name, boolean parentFirst) {
        this.parent = manager;
        this.parentFirst = parentFirst;
        this.name = name;
        manager.addSubDomainByName(this);
    }

    public AspectManager getParent() {
        return this.parent;
    }

    @Override
    protected ClassifiedBindingAndPointcutCollection createBindingCollection() {
        return new DomainClassifiedBindingAndPointcutCollection();
    }

    public boolean isValid() {
        return true;
    }

    public String getDomainName() {
        return this.name;
    }

    @Override
    public String getManagerFQN() {
        return this.parent.getManagerFQN() + this.name + "/";
    }

    public static String getDomainName(final Class<?> clazz, final boolean forInstance) {
        String name = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                StringBuffer sb = new StringBuffer();
                sb.append(clazz.getName());
                sb.append("_");
                sb.append(System.identityHashCode(SecurityActions.getClassLoader(clazz)));
                if (forInstance) {
                    sb.append("_");
                    sb.append(Domain.getNextSequenceNumber());
                }
                return sb.toString();
            }
        });
        return name;
    }

    private static synchronized int getNextSequenceNumber() {
        return sequenceNumber++;
    }

    public void setInheritsDeclarations(boolean inheritsDeclarations) {
        this.inheritsDeclarations = inheritsDeclarations;
    }

    public void setInheritsBindings(boolean inheritBindings) {
        this.inheritsBindings = inheritBindings;
        if (this.inheritsBindings) {
            this.parent.subscribeSubDomain(this);
        } else {
            this.parent.unsubscribeSubDomain(this);
        }
    }

    @Override
    public LinkedHashMap<String, AdviceBinding> getBindings() {
        if (this.inheritsBindings) {
            if (!this.parentFirst) {
                LinkedHashMap<String, AdviceBinding> map = new LinkedHashMap<String, AdviceBinding>(this.parent.getBindings());
                map.putAll(this.bindingCollection.getBindings());
                return map;
            }
            LinkedHashMap<String, AdviceBinding> map = new LinkedHashMap<String, AdviceBinding>(this.bindingCollection.getBindings());
            map.putAll(this.parent.getBindings());
            return map;
        }
        return super.getBindings();
    }

    public boolean hasOwnBindings() {
        return this.hasOwnBindings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addBinding(AdviceBinding binding) {
        lock.lockWrite();
        try {
            this.hasOwnPointcuts = true;
            this.hasOwnBindings = true;
            super.addBinding(binding);
        }
        finally {
            lock.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeBinding(String name) {
        lock.lockWrite();
        try {
            super.removeBinding(name);
            this.hasOwnBindings = !this.bindingCollection.isEmpty();
            this.hasOwnPointcuts = !this.bindingCollection.hasPointcuts();
        }
        finally {
            lock.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeBindings(ArrayList<String> binds) {
        lock.lockWrite();
        try {
            super.removeBindings(binds);
            this.hasOwnBindings = !this.bindingCollection.isEmpty();
            this.hasOwnPointcuts = !this.bindingCollection.hasPointcuts();
        }
        finally {
            lock.unlockWrite();
        }
    }

    @Override
    public LinkedHashMap<String, Pointcut> getPointcuts() {
        return this.bindingCollection.getPointcuts();
    }

    public boolean hasOwnPointcuts() {
        return this.hasOwnPointcuts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPointcut(Pointcut pointcut) {
        lock.lockWrite();
        try {
            this.hasOwnPointcuts = true;
            super.addPointcut(pointcut);
        }
        finally {
            lock.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePointcut(String name) {
        lock.lockWrite();
        try {
            super.removePointcut(name);
            this.hasOwnPointcuts = this.bindingCollection.hasPointcuts();
        }
        finally {
            lock.unlockWrite();
        }
    }

    @Override
    public LinkedHashMap<String, PointcutInfo> getPointcutInfos() {
        return this.bindingCollection.getPointcutInfos();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AnnotationIntroduction> getAnnotationIntroductions() {
        if (this.inheritsBindings) {
            ArrayList<AnnotationIntroduction> result = new ArrayList<AnnotationIntroduction>();
            if (!this.parentFirst) {
                result.addAll(this.parent.getAnnotationIntroductions());
                LinkedHashMap linkedHashMap = this.annotationIntroductions;
                synchronized (linkedHashMap) {
                    result = new ArrayList(this.annotationIntroductions.values());
                }
                return result;
            }
            LinkedHashMap linkedHashMap = this.annotationIntroductions;
            synchronized (linkedHashMap) {
                result = new ArrayList(this.annotationIntroductions.values());
            }
            result.addAll(this.parent.getAnnotationIntroductions());
            return result;
        }
        return super.getAnnotationIntroductions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, ArrayReplacement> getArrayReplacements() {
        if (this.inheritsBindings) {
            HashMap<String, ArrayReplacement> map = new HashMap<String, ArrayReplacement>();
            if (!this.parentFirst) {
                map.putAll(this.parent.getArrayReplacements());
                LinkedHashMap linkedHashMap = this.arrayReplacements;
                synchronized (linkedHashMap) {
                    map.putAll(this.arrayReplacements);
                }
                return map;
            }
            LinkedHashMap linkedHashMap = this.arrayReplacements;
            synchronized (linkedHashMap) {
                map.putAll(this.arrayReplacements);
            }
            map.putAll(this.parent.getArrayReplacements());
            return map;
        }
        return super.getArrayReplacements();
    }

    public boolean hasOwnAnnotationIntroductions() {
        return this.hasOwnAnnotationIntroductions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addAnnotationIntroduction(AnnotationIntroduction pointcut) {
        lock.lockWrite();
        try {
            this.hasOwnAnnotationIntroductions = true;
            super.addAnnotationIntroduction(pointcut);
        }
        finally {
            lock.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAnnotationIntroduction(AnnotationIntroduction pointcut) {
        lock.lockWrite();
        try {
            super.removeAnnotationIntroduction(pointcut);
            this.hasOwnAnnotationIntroductions = this.annotationIntroductions.size() > 0;
        }
        finally {
            lock.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AnnotationIntroduction> getAnnotationOverrides() {
        if (this.inheritsBindings) {
            ArrayList<AnnotationIntroduction> list = new ArrayList<AnnotationIntroduction>();
            if (!this.parentFirst) {
                list.addAll(this.parent.getAnnotationOverrides());
                LinkedHashMap linkedHashMap = this.annotationOverrides;
                synchronized (linkedHashMap) {
                    list.addAll(this.annotationOverrides.values());
                }
                return list;
            }
            LinkedHashMap linkedHashMap = this.annotationOverrides;
            synchronized (linkedHashMap) {
                list.addAll(this.annotationOverrides.values());
            }
            list.addAll(this.parent.getAnnotationOverrides());
            return list;
        }
        return super.getAnnotationOverrides();
    }

    public boolean hasOwnAnnotationOverrides() {
        return this.hasOwnAnnotationOverrides;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addAnnotationOverride(AnnotationIntroduction pointcut) {
        lock.lockWrite();
        try {
            this.hasOwnAnnotationOverrides = true;
            super.addAnnotationOverride(pointcut);
        }
        finally {
            lock.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAnnotationOverride(AnnotationIntroduction pointcut) {
        lock.lockWrite();
        try {
            super.removeAnnotationOverride(pointcut);
            this.hasOwnAnnotationOverrides = this.annotationOverrides.size() > 0;
        }
        finally {
            lock.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, InterfaceIntroduction> getInterfaceIntroductions() {
        if (this.inheritsBindings) {
            HashMap<String, InterfaceIntroduction> map = new HashMap<String, InterfaceIntroduction>();
            if (!this.parentFirst) {
                map.putAll(this.parent.getInterfaceIntroductions());
                LinkedHashMap linkedHashMap = this.interfaceIntroductions;
                synchronized (linkedHashMap) {
                    map.putAll(this.interfaceIntroductions);
                }
                return map;
            }
            LinkedHashMap linkedHashMap = this.interfaceIntroductions;
            synchronized (linkedHashMap) {
                map.putAll(this.interfaceIntroductions);
            }
            map.putAll(this.parent.getInterfaceIntroductions());
            return map;
        }
        return super.getInterfaceIntroductions();
    }

    public boolean hasOwnInterfaceIntroductions() {
        return this.hasOwnInterfaceIntroductions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addInterfaceIntroduction(InterfaceIntroduction pointcut) {
        lock.lockWrite();
        try {
            this.hasOwnInterfaceIntroductions = true;
            super.addInterfaceIntroduction(pointcut);
        }
        finally {
            lock.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeInterfaceIntroduction(String name) {
        lock.lockWrite();
        try {
            super.removeInterfaceIntroduction(name);
            this.hasOwnInterfaceIntroductions = this.interfaceIntroductions.size() > 0;
        }
        finally {
            lock.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Typedef> getTypedefs() {
        if (this.inheritsBindings) {
            HashMap<String, Typedef> map = new HashMap<String, Typedef>();
            if (!this.parentFirst) {
                map.putAll(this.parent.getTypedefs());
                LinkedHashMap linkedHashMap = this.typedefs;
                synchronized (linkedHashMap) {
                    map.putAll(this.typedefs);
                }
                return map;
            }
            LinkedHashMap linkedHashMap = this.typedefs;
            synchronized (linkedHashMap) {
                map.putAll(this.typedefs);
            }
            map.putAll(this.parent.getTypedefs());
            return map;
        }
        return super.getTypedefs();
    }

    public boolean hasOwnTypedefs() {
        return this.hasOwnTypedefs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTypedef(Typedef def) throws Exception {
        lock.lockWrite();
        try {
            this.hasOwnTypedefs = true;
            super.addTypedef(def);
        }
        finally {
            lock.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTypedef(String name) {
        lock.lockWrite();
        try {
            super.removeTypedef(name);
            this.hasOwnTypedefs = this.typedefs.size() > 0;
        }
        finally {
            lock.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, AdviceStack> getInterceptorStacks() {
        if (this.inheritsBindings) {
            HashMap<String, AdviceStack> map = new HashMap<String, AdviceStack>();
            if (!this.parentFirst) {
                map.putAll(this.parent.getInterceptorStacks());
                HashMap hashMap = this.interceptorStacks;
                synchronized (hashMap) {
                    map.putAll(this.interceptorStacks);
                }
                return map;
            }
            HashMap hashMap = this.interceptorStacks;
            synchronized (hashMap) {
                map.putAll(this.interceptorStacks);
            }
            map.putAll(this.parent.getInterceptorStacks());
            return map;
        }
        return super.getInterceptorStacks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, ClassMetaDataLoader> getClassMetaDataLoaders() {
        if (this.inheritsBindings) {
            HashMap<String, ClassMetaDataLoader> map = new HashMap<String, ClassMetaDataLoader>();
            if (!this.parentFirst) {
                map.putAll(this.parent.getClassMetaDataLoaders());
                HashMap hashMap = this.classMetaDataLoaders;
                synchronized (hashMap) {
                    map.putAll(this.classMetaDataLoaders);
                }
                return map;
            }
            HashMap hashMap = this.classMetaDataLoaders;
            synchronized (hashMap) {
                map.putAll(this.classMetaDataLoaders);
            }
            map.putAll(this.parent.getClassMetaDataLoaders());
            return map;
        }
        return super.getClassMetaDataLoaders();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, CFlowStack> getCflowStacks() {
        if (this.inheritsBindings) {
            HashMap<String, CFlowStack> map = new HashMap<String, CFlowStack>();
            if (!this.parentFirst) {
                map.putAll(this.parent.getCflowStacks());
                ConcurrentHashMap concurrentHashMap = this.cflowStacks;
                synchronized (concurrentHashMap) {
                    map.putAll(this.cflowStacks);
                }
                return map;
            }
            ConcurrentHashMap concurrentHashMap = this.cflowStacks;
            synchronized (concurrentHashMap) {
                map.putAll(this.cflowStacks);
            }
            map.putAll(this.parent.getCflowStacks());
            return map;
        }
        return super.getCflowStacks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, DynamicCFlowDefinition> getDynamicCFlows() {
        if (this.inheritsBindings) {
            HashMap<String, DynamicCFlowDefinition> map = new HashMap<String, DynamicCFlowDefinition>();
            if (!this.parentFirst) {
                map.putAll(this.parent.getDynamicCFlows());
                ConcurrentHashMap concurrentHashMap = this.dynamicCFlows;
                synchronized (concurrentHashMap) {
                    map.putAll(this.dynamicCFlows);
                }
                return map;
            }
            ConcurrentHashMap concurrentHashMap = this.dynamicCFlows;
            synchronized (concurrentHashMap) {
                map.putAll(this.dynamicCFlows);
            }
            map.putAll(this.parent.getDynamicCFlows());
            return map;
        }
        return super.getDynamicCFlows();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> getPerVMAspects() {
        if (this.inheritsBindings) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            if (!this.parentFirst) {
                map.putAll(this.parent.getPerVMAspects());
                ConcurrentHashMap concurrentHashMap = this.perVMAspects;
                synchronized (concurrentHashMap) {
                    map.putAll(this.perVMAspects);
                }
                return map;
            }
            ConcurrentHashMap concurrentHashMap = this.perVMAspects;
            synchronized (concurrentHashMap) {
                map.putAll(this.perVMAspects);
            }
            map.putAll(this.parent.getPerVMAspects());
            return map;
        }
        return super.getPerVMAspects();
    }

    @Override
    public LinkedHashMap<String, PrecedenceDef> getPrecedenceDefs() {
        if (this.inheritsDeclarations) {
            if (!this.parentFirst) {
                LinkedHashMap<String, PrecedenceDef> map = new LinkedHashMap<String, PrecedenceDef>(this.parent.getPrecedenceDefs());
                map.putAll(this.precedenceDefs);
                return map;
            }
            LinkedHashMap<String, PrecedenceDef> map = new LinkedHashMap<String, PrecedenceDef>(this.precedenceDefs);
            map.putAll(this.parent.getPrecedenceDefs());
            return map;
        }
        return super.getPrecedenceDefs();
    }

    public boolean hasOwnPrecedenceDefs() {
        return this.hasOwnPrecedenceDefs;
    }

    @Override
    public void addPrecedence(PrecedenceDef precedenceDef) {
        this.hasOwnPrecedenceDefs = true;
        super.addPrecedence(precedenceDef);
    }

    @Override
    public void removePrecedence(String name) {
        super.removePrecedence(name);
        this.hasOwnPrecedenceDefs = this.precedenceDefs.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, ClassMetaDataBinding> getClassMetaData() {
        if (this.inheritsBindings) {
            HashMap<String, ClassMetaDataBinding> map = new HashMap<String, ClassMetaDataBinding>();
            if (!this.parentFirst) {
                map.putAll(this.parent.getClassMetaData());
                LinkedHashMap linkedHashMap = this.classMetaData;
                synchronized (linkedHashMap) {
                    map.putAll(this.classMetaData);
                }
                return map;
            }
            LinkedHashMap linkedHashMap = this.classMetaData;
            synchronized (linkedHashMap) {
                map.putAll(this.classMetaData);
            }
            map.putAll(this.parent.getClassMetaData());
            return map;
        }
        return super.getClassMetaData();
    }

    public boolean hasOwnClassMetaData() {
        return this.hasOwnClassMetaData;
    }

    @Override
    public void removeClassMetaData(String name) {
        super.removeClassMetaData(name);
        this.hasOwnClassMetaData = this.classMetaData.size() > 0;
    }

    @Override
    public void addClassMetaData(ClassMetaDataBinding meta) {
        this.hasOwnClassMetaData = true;
        super.addClassMetaData(meta);
    }

    public boolean hasOwnDataWithEffectOnAdvices() {
        return this.hasOwnBindings || this.hasOwnPointcuts || this.hasOwnAnnotationIntroductions || this.hasOwnAnnotationOverrides || this.hasOwnInterfaceIntroductions || this.hasOwnTypedefs || this.hasOwnPrecedenceDefs || this.hasOwnClassMetaData;
    }

    @Override
    public InterceptorFactory getInterceptorFactory(String name) {
        InterceptorFactory factory = null;
        if (this.parentFirst && (factory = this.parent.getInterceptorFactory(name)) != null) {
            return factory;
        }
        factory = super.getInterceptorFactory(name);
        if (factory != null) {
            return factory;
        }
        return this.parent.getInterceptorFactory(name);
    }

    @Override
    public AdviceStack getAdviceStack(String name) {
        AdviceStack factory = null;
        if (this.parentFirst && (factory = this.parent.getAdviceStack(name)) != null) {
            return factory;
        }
        factory = super.getAdviceStack(name);
        if (factory != null) {
            return factory;
        }
        return this.parent.getAdviceStack(name);
    }

    @Override
    public Object getPerVMAspect(AspectDefinition def) {
        return this.getPerVMAspect(def.getName());
    }

    @Override
    public Object getPerVMAspect(String def) {
        Object factory = null;
        if (this.parentFirst && (factory = this.parent.getPerVMAspect(def)) != null) {
            return factory;
        }
        factory = super.getPerVMAspect(def);
        if (factory != null) {
            return factory;
        }
        return this.parent.getPerVMAspect(def);
    }

    @Override
    public AspectDefinition getAspectDefinition(String name) {
        AspectDefinition factory = null;
        if (this.parentFirst && (factory = this.parent.getAspectDefinition(name)) != null) {
            return factory;
        }
        factory = super.getAspectDefinition(name);
        if (factory != null) {
            return factory;
        }
        return this.parent.getAspectDefinition(name);
    }

    @Override
    public Typedef getTypedef(String name) {
        Typedef factory = null;
        if (this.parentFirst && (factory = this.parent.getTypedef(name)) != null) {
            return factory;
        }
        factory = super.getTypedef(name);
        if (factory != null) {
            return factory;
        }
        return this.parent.getTypedef(name);
    }

    @Override
    public DomainDefinition getContainer(String name) {
        DomainDefinition container = null;
        if (this.parentFirst && (container = this.parent.getContainer(name)) != null) {
            return container;
        }
        container = super.getContainer(name);
        if (container != null) {
            return container;
        }
        return this.parent.getContainer(name);
    }

    @Override
    public Pointcut getPointcut(String name) {
        Pointcut pointcut = null;
        if (this.parentFirst && (pointcut = this.parent.getPointcut(name)) != null) {
            return pointcut;
        }
        pointcut = super.getPointcut(name);
        if (pointcut != null) {
            return pointcut;
        }
        return this.parent.getPointcut(name);
    }

    @Override
    public void attachMetaData(Advisor advisor, Class<?> clazz) {
        if (this.inheritsBindings) {
            if (!this.parentFirst) {
                this.parent.attachMetaData(advisor, clazz);
                super.attachMetaData(advisor, clazz);
            } else {
                super.attachMetaData(advisor, clazz);
                this.parent.attachMetaData(advisor, clazz);
            }
        } else {
            super.attachMetaData(advisor, clazz);
        }
    }

    @Override
    public CFlowStack getCFlowStack(String name) {
        if (this.inheritsDeclarations) {
            if (!this.parentFirst) {
                CFlowStack cflow = super.getCFlowStack(name);
                if (cflow == null) {
                    cflow = this.parent.getCFlowStack(name);
                }
                return cflow;
            }
            CFlowStack cflow = this.parent.getCFlowStack(name);
            if (cflow == null) {
                cflow = super.getCFlowStack(name);
            }
            return cflow;
        }
        return super.getCFlowStack(name);
    }

    @Override
    public DynamicCFlow getDynamicCFlow(String name, ClassLoader cl) {
        if (this.inheritsBindings) {
            if (!this.parentFirst) {
                DynamicCFlow cflow = super.getDynamicCFlow(name, cl);
                if (cflow == null) {
                    cflow = this.parent.getDynamicCFlow(name, cl);
                }
                return cflow;
            }
            DynamicCFlow cflow = this.parent.getDynamicCFlow(name, cl);
            if (cflow == null) {
                cflow = super.getDynamicCFlow(name, cl);
            }
            return cflow;
        }
        return super.getDynamicCFlow(name, cl);
    }

    @Override
    public ClassMetaDataLoader findClassMetaDataLoader(String group) {
        if (this.inheritsDeclarations) {
            if (!this.parentFirst) {
                ClassMetaDataLoader loader = super.findClassMetaDataLoader(group);
                if (loader == null) {
                    loader = this.parent.findClassMetaDataLoader(group);
                }
                return loader;
            }
            ClassMetaDataLoader loader = this.parent.findClassMetaDataLoader(group);
            if (loader == null) {
                loader = super.findClassMetaDataLoader(group);
            }
            return loader;
        }
        return super.findClassMetaDataLoader(group);
    }

    @Override
    public Map<String, LifecycleCallbackBinding> getLifecycleBindings() {
        if (this.inheritsBindings) {
            if (!this.parentFirst) {
                LinkedHashMap<String, LifecycleCallbackBinding> map = new LinkedHashMap<String, LifecycleCallbackBinding>(this.parent.getLifecycleBindings());
                map.putAll(super.getLifecycleBindings());
                return map;
            }
            LinkedHashMap<String, LifecycleCallbackBinding> map = new LinkedHashMap<String, LifecycleCallbackBinding>(super.getLifecycleBindings());
            map.putAll(this.parent.getLifecycleBindings());
            return map;
        }
        return super.getLifecycleBindings();
    }

    @Override
    public InterceptionMarkers getInterceptionMarkers(ClassLoader loader) {
        return this.parent.getInterceptionMarkers(loader);
    }

    @Override
    protected Map<Class<?>, WeakReference<Domain>> getSubDomainsPerClass() {
        return this.parent.getSubDomainsPerClass();
    }

    @Override
    public ArrayList<String> getExclude() {
        return this.parent.getExclude();
    }

    @Override
    public ArrayList<String> getInclude() {
        return this.parent.getInclude();
    }

    @Override
    public ArrayList<String> getIgnore() {
        return this.parent.getIgnore();
    }

    @Override
    public ClassExpression[] getIgnoreExpressions() {
        return this.parent.getIgnoreExpressions();
    }

    @Override
    public List<String> getIncludedInvisibleAnnotations() {
        return this.parent.getIncludedInvisibleAnnotations();
    }

    @Override
    public DynamicAOPStrategy getDynamicAOPStrategy() {
        return this.parent.getDynamicAOPStrategy();
    }

    @Override
    public void setDynamicAOPStrategy(DynamicAOPStrategy strategy) {
        this.parent.setDynamicAOPStrategy(strategy);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DomainClassifiedBindingAndPointcutCollection
    extends ClassifiedBindingAndPointcutCollection {
        private DomainClassifiedBindingAndPointcutCollection() {
        }

        @Override
        public LinkedHashMap<String, AdviceBinding> getBindings() {
            LinkedHashMap<String, AdviceBinding> parentResult;
            LinkedHashMap<String, AdviceBinding> result = super.getBindingsInternal();
            LinkedHashMap<String, AdviceBinding> overall = this.unifyMaps(result, parentResult = Domain.this.inheritsBindings ? Domain.this.parent.getBindingCollection().getBindingsInternal() : UnmodifiableEmptyCollections.EMPTY_LINKED_HASHMAP, Domain.this.parentFirst);
            if (overall == result || overall == parentResult) {
                return new LinkedHashMap<String, AdviceBinding>(overall);
            }
            return overall;
        }

        @Override
        public LinkedHashMap<String, Pointcut> getPointcuts() {
            LinkedHashMap<String, Pointcut> parentResult;
            LinkedHashMap<String, Pointcut> result = super.getPointcutsInternal();
            LinkedHashMap<String, Pointcut> overall = this.unifyMaps(result, parentResult = Domain.this.inheritsBindings ? Domain.this.parent.getBindingCollection().getPointcutsInternal() : UnmodifiableEmptyCollections.EMPTY_LINKED_HASHMAP, Domain.this.parentFirst);
            if (overall == result || overall == parentResult) {
                return new LinkedHashMap<String, Pointcut>(overall);
            }
            return overall;
        }

        @Override
        public LinkedHashMap<String, PointcutInfo> getPointcutInfos() {
            LinkedHashMap<String, PointcutInfo> parentResult;
            LinkedHashMap<String, PointcutInfo> result = super.getPointcutInfosInternal();
            LinkedHashMap<String, PointcutInfo> overall = this.unifyMaps(result, parentResult = Domain.this.inheritsBindings ? Domain.this.parent.getBindingCollection().getPointcutInfosInternal() : UnmodifiableEmptyCollections.EMPTY_LINKED_HASHMAP, Domain.this.parentFirst);
            if (overall == result || overall == parentResult) {
                return new LinkedHashMap<String, PointcutInfo>(overall);
            }
            return overall;
        }

        @Override
        public Collection<AdviceBinding> getFieldReadBindings() {
            Collection<AdviceBinding> result = super.getFieldReadBindings();
            ArrayList parentResult = Domain.this.inheritsBindings ? Domain.this.parent.getBindingCollection().getFieldReadBindings() : UnmodifiableEmptyCollections.EMPTY_ARRAYLIST;
            return this.unifyCollections(result, parentResult, Domain.this.parentFirst);
        }

        @Override
        public Collection<AdviceBinding> getFieldWriteBindings() {
            Collection<AdviceBinding> result = super.getFieldWriteBindings();
            ArrayList parentResult = Domain.this.inheritsBindings ? Domain.this.parent.getBindingCollection().getFieldWriteBindings() : UnmodifiableEmptyCollections.EMPTY_ARRAYLIST;
            return this.unifyCollections(result, parentResult, Domain.this.parentFirst);
        }

        @Override
        public Collection<AdviceBinding> getConstructionBindings() {
            Collection<AdviceBinding> result = super.getConstructionBindings();
            ArrayList parentResult = Domain.this.inheritsBindings ? Domain.this.parent.getBindingCollection().getConstructionBindings() : UnmodifiableEmptyCollections.EMPTY_ARRAYLIST;
            return this.unifyCollections(result, parentResult, Domain.this.parentFirst);
        }

        @Override
        public Collection<AdviceBinding> getConstructorExecutionBindings() {
            Collection<AdviceBinding> result = super.getConstructorExecutionBindings();
            ArrayList parentResult = Domain.this.inheritsBindings ? Domain.this.parent.getBindingCollection().getConstructorExecutionBindings() : UnmodifiableEmptyCollections.EMPTY_ARRAYLIST;
            return this.unifyCollections(result, parentResult, Domain.this.parentFirst);
        }

        @Override
        public Collection<AdviceBinding> getMethodExecutionBindings() {
            Collection<AdviceBinding> result = super.getMethodExecutionBindings();
            ArrayList parentResult = Domain.this.inheritsBindings ? Domain.this.parent.getBindingCollection().getMethodExecutionBindings() : UnmodifiableEmptyCollections.EMPTY_ARRAYLIST;
            return this.unifyCollections(result, parentResult, Domain.this.parentFirst);
        }

        @Override
        public Collection<AdviceBinding> getConstructorCallBindings() {
            Collection<AdviceBinding> result = super.getConstructorCallBindings();
            ArrayList parentResult = Domain.this.inheritsBindings ? Domain.this.parent.getBindingCollection().getConstructorCallBindings() : UnmodifiableEmptyCollections.EMPTY_ARRAYLIST;
            return this.unifyCollections(result, parentResult, Domain.this.parentFirst);
        }

        @Override
        public Collection<AdviceBinding> getMethodCallBindings() {
            Collection<AdviceBinding> result = super.getMethodCallBindings();
            ArrayList parentResult = Domain.this.inheritsBindings ? Domain.this.parent.getBindingCollection().getMethodCallBindings() : UnmodifiableEmptyCollections.EMPTY_ARRAYLIST;
            return this.unifyCollections(result, parentResult, Domain.this.parentFirst);
        }

        @Override
        public Collection<Pointcut> getFieldReadPointcuts() {
            Collection<Pointcut> result = super.getFieldReadPointcuts();
            ArrayList parentResult = Domain.this.inheritsBindings ? Domain.this.parent.getBindingCollection().getFieldReadPointcuts() : UnmodifiableEmptyCollections.EMPTY_ARRAYLIST;
            return this.unifyCollections(result, parentResult, Domain.this.parentFirst);
        }

        @Override
        public Collection<Pointcut> getFieldWritePointcuts() {
            Collection<Pointcut> result = super.getFieldWritePointcuts();
            ArrayList parentResult = Domain.this.inheritsBindings ? Domain.this.parent.getBindingCollection().getFieldWritePointcuts() : UnmodifiableEmptyCollections.EMPTY_ARRAYLIST;
            return this.unifyCollections(result, parentResult, Domain.this.parentFirst);
        }

        @Override
        public Collection<Pointcut> getConstructionPointcuts() {
            Collection<Pointcut> result = super.getConstructionPointcuts();
            ArrayList parentResult = Domain.this.inheritsBindings ? Domain.this.parent.getBindingCollection().getConstructionPointcuts() : UnmodifiableEmptyCollections.EMPTY_ARRAYLIST;
            return this.unifyCollections(result, parentResult, Domain.this.parentFirst);
        }

        @Override
        public Collection<Pointcut> getConstructorExecutionPointcuts() {
            Collection<Pointcut> result = super.getConstructorExecutionPointcuts();
            ArrayList parentResult = Domain.this.inheritsBindings ? Domain.this.parent.getBindingCollection().getConstructorExecutionPointcuts() : UnmodifiableEmptyCollections.EMPTY_ARRAYLIST;
            return this.unifyCollections(result, parentResult, Domain.this.parentFirst);
        }

        @Override
        public Collection<Pointcut> getMethodExecutionPointcuts() {
            Collection<Pointcut> result = super.getMethodExecutionPointcuts();
            ArrayList parentResult = Domain.this.inheritsBindings ? Domain.this.parent.getBindingCollection().getMethodExecutionPointcuts() : UnmodifiableEmptyCollections.EMPTY_ARRAYLIST;
            return this.unifyCollections(result, parentResult, Domain.this.parentFirst);
        }

        @Override
        public Collection<Pointcut> getConstructorCallPointcuts() {
            Collection<Pointcut> result = super.getConstructorCallPointcuts();
            ArrayList parentResult = Domain.this.inheritsBindings ? Domain.this.parent.getBindingCollection().getConstructorCallPointcuts() : UnmodifiableEmptyCollections.EMPTY_ARRAYLIST;
            return this.unifyCollections(result, parentResult, Domain.this.parentFirst);
        }

        @Override
        public Collection<Pointcut> getMethodCallPointcuts() {
            Collection<Pointcut> result = super.getMethodCallPointcuts();
            ArrayList parentResult = Domain.this.inheritsBindings ? Domain.this.parent.getBindingCollection().getMethodCallPointcuts() : UnmodifiableEmptyCollections.EMPTY_ARRAYLIST;
            return this.unifyCollections(result, parentResult, Domain.this.parentFirst);
        }

        @Override
        public Collection<PointcutInfo> getFieldReadPointcutInfos() {
            Collection<PointcutInfo> result = super.getFieldReadPointcutInfos();
            ArrayList parentResult = Domain.this.inheritsBindings ? Domain.this.parent.getBindingCollection().getFieldReadPointcutInfos() : UnmodifiableEmptyCollections.EMPTY_ARRAYLIST;
            return this.unifyCollections(result, parentResult, Domain.this.parentFirst);
        }

        @Override
        public Collection<PointcutInfo> getFieldWritePointcutInfos() {
            Collection<PointcutInfo> result = super.getFieldWritePointcutInfos();
            ArrayList parentResult = Domain.this.inheritsBindings ? Domain.this.parent.getBindingCollection().getFieldWritePointcutInfos() : UnmodifiableEmptyCollections.EMPTY_ARRAYLIST;
            return this.unifyCollections(result, parentResult, Domain.this.parentFirst);
        }

        @Override
        public Collection<PointcutInfo> getConstructionPointcutInfos() {
            Collection<PointcutInfo> result = super.getConstructionPointcutInfos();
            ArrayList parentResult = Domain.this.inheritsBindings ? Domain.this.parent.getBindingCollection().getConstructionPointcutInfos() : UnmodifiableEmptyCollections.EMPTY_ARRAYLIST;
            return this.unifyCollections(result, parentResult, Domain.this.parentFirst);
        }

        @Override
        public Collection<PointcutInfo> getConstructorExecutionPointcutInfos() {
            Collection<PointcutInfo> result = super.getConstructorExecutionPointcutInfos();
            ArrayList parentResult = Domain.this.inheritsBindings ? Domain.this.parent.getBindingCollection().getConstructorExecutionPointcutInfos() : UnmodifiableEmptyCollections.EMPTY_ARRAYLIST;
            return this.unifyCollections(result, parentResult, Domain.this.parentFirst);
        }

        @Override
        public Collection<PointcutInfo> getMethodExecutionPointcutInfos() {
            Collection<PointcutInfo> result = super.getMethodExecutionPointcutInfos();
            ArrayList parentResult = Domain.this.inheritsBindings ? Domain.this.parent.getBindingCollection().getMethodExecutionPointcutInfos() : UnmodifiableEmptyCollections.EMPTY_ARRAYLIST;
            return this.unifyCollections(result, parentResult, Domain.this.parentFirst);
        }

        @Override
        public Collection<PointcutInfo> getConstructorCallPointcutInfos() {
            Collection<PointcutInfo> result = super.getConstructorCallPointcutInfos();
            ArrayList parentResult = Domain.this.inheritsBindings ? Domain.this.parent.getBindingCollection().getConstructorCallPointcutInfos() : UnmodifiableEmptyCollections.EMPTY_ARRAYLIST;
            return this.unifyCollections(result, parentResult, Domain.this.parentFirst);
        }

        @Override
        public Collection<PointcutInfo> getMethodCallPointcutInfos() {
            Collection<PointcutInfo> result = super.getMethodCallPointcutInfos();
            ArrayList parentResult = Domain.this.inheritsBindings ? Domain.this.parent.getBindingCollection().getMethodCallPointcutInfos() : UnmodifiableEmptyCollections.EMPTY_ARRAYLIST;
            return this.unifyCollections(result, parentResult, Domain.this.parentFirst);
        }

        @Override
        public boolean isExecution() {
            if (super.isExecution()) {
                return true;
            }
            if (Domain.this.inheritsBindings) {
                return Domain.this.parent.isExecution();
            }
            return false;
        }

        @Override
        public boolean isConstruction() {
            if (super.isConstruction()) {
                return true;
            }
            if (Domain.this.inheritsBindings) {
                return Domain.this.parent.isConstruction();
            }
            return false;
        }

        @Override
        public boolean isCall() {
            if (super.isCall()) {
                return true;
            }
            if (Domain.this.inheritsBindings) {
                return Domain.this.parent.isCall();
            }
            return false;
        }

        @Override
        public boolean isWithin() {
            if (super.isWithin()) {
                return true;
            }
            if (Domain.this.inheritsBindings) {
                return Domain.this.parent.isWithin();
            }
            return false;
        }

        @Override
        public boolean isWithincode() {
            if (super.isWithincode()) {
                return true;
            }
            if (Domain.this.inheritsBindings) {
                return Domain.this.parent.isWithincode();
            }
            return false;
        }

        @Override
        public boolean isGet() {
            if (super.isGet()) {
                return true;
            }
            if (Domain.this.inheritsBindings) {
                return Domain.this.parent.isGet();
            }
            return false;
        }

        @Override
        public boolean isSet() {
            if (super.isSet()) {
                return true;
            }
            if (Domain.this.inheritsBindings) {
                return Domain.this.parent.isSet();
            }
            return false;
        }

        private <T> Collection<T> unifyCollections(Collection<T> collection1, Collection<T> collection2, boolean prioritizeFirst) {
            if (collection1.isEmpty()) {
                return collection2;
            }
            if (collection2.isEmpty()) {
                return collection1;
            }
            if (prioritizeFirst) {
                collection1 = new LinkedHashSet<T>(collection1);
                collection1.addAll(collection2);
            } else {
                Collection<T> temp = collection1;
                collection1 = new LinkedHashSet<T>(collection2);
                collection1.addAll(temp);
            }
            return collection1;
        }

        private <T, K> LinkedHashMap<T, K> unifyMaps(LinkedHashMap<T, K> map1, LinkedHashMap<T, K> map2, boolean prioritizeFirst) {
            if (map1.isEmpty()) {
                return map2;
            }
            if (map2.isEmpty()) {
                return map1;
            }
            if (prioritizeFirst) {
                map1 = new LinkedHashMap<T, T>(map1);
                map1.putAll(map2);
            } else {
                LinkedHashMap<T, T> temp = map1;
                map1 = new LinkedHashMap<T, T>(map2);
                map1.putAll(temp);
            }
            return map1;
        }
    }
}

