/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop;

import javassist.ByteArrayClassPath;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.NotFoundException;
import org.jboss.aop.Advised;
import org.jboss.aop.AdvisorFactory;
import org.jboss.aop.AspectManager;
import org.jboss.aop.ClassAdvisor;
import org.jboss.aop.Domain;
import org.jboss.aop.SecurityActions;
import org.jboss.aop.WeavingStrategySupport;
import org.jboss.aop.instrument.Instrumentor;
import org.jboss.aop.instrument.InstrumentorFactory;
import org.jboss.aop.instrument.WeavingRegistry;
import org.jboss.classpool.scoped.ScopedClassPool;
import org.jboss.classpool.spi.AbstractClassPool;
import org.jboss.classpool.spi.ClassPoolRepository;
import org.jboss.logging.Logger;

public class SuperClassesFirstWeavingStrategy
extends WeavingStrategySupport {
    private static final Logger logger = Logger.getLogger(SuperClassesFirstWeavingStrategy.class);
    private boolean verbose = AspectManager.verbose;
    public static final String AOP_PACKAGE = Advised.class.getPackage().getName();

    public byte[] translate(AspectManager manager, String className, ClassLoader loader, byte[] classfileBuffer) throws Exception {
        if (SuperClassesFirstWeavingStrategy.isReEntry()) {
            return null;
        }
        SuperClassesFirstWeavingStrategy.setReEntry();
        super.setTransformationStarted();
        try {
            CtClass clazz;
            if (manager.isNonAdvisableClassName(className)) {
                byte[] byArray = null;
                return byArray;
            }
            ScopedClassPool pool = (ScopedClassPool)ClassPoolRepository.getInstance().registerClassLoader(loader);
            CtClass woven = this.instrumentClass(manager, pool, clazz = this.obtainCtClassInfo(pool, className, classfileBuffer), true);
            if (woven != null) {
                pool.lockInCache(woven);
                if (AspectManager.debugClasses) {
                    SecurityActions.debugWriteFile(clazz);
                }
                byte[] rtn = woven.toBytecode();
                if (AspectManager.getPrune()) {
                    woven.prune();
                }
                byte[] byArray = rtn;
                return byArray;
            }
            pool.soften(clazz);
            byte[] byArray = null;
            return byArray;
        }
        catch (Exception ex) {
            if (!(ex instanceof NotFoundException)) {
                if (this.verbose) {
                    logger.warn((Object)ex);
                } else {
                    Throwable cause = ex.getCause();
                    while (cause.getCause() != null) {
                        cause = cause.getCause();
                    }
                    if (cause != null && cause instanceof NotFoundException) {
                        if (this.verbose) {
                            logger.warn((Object)ex);
                        }
                    } else {
                        logger.error((Object)(ex.getMessage() + ".. Do verbose mode if you want full stack trace."));
                    }
                }
            }
            throw ex;
        }
        finally {
            SuperClassesFirstWeavingStrategy.clearReEntry();
        }
    }

    private CtClass obtainCtClassInfo(ScopedClassPool pool, String className, byte[] classfileBuffer) throws NotFoundException {
        try {
            return pool.getLocally(className);
        }
        catch (NotFoundException e) {
            ByteArrayClassPath cp = new ByteArrayClassPath(className, classfileBuffer);
            pool.insertClassPath((ClassPath)cp);
            return pool.getLocally(className);
        }
        catch (Error e) {
            return null;
        }
    }

    private CtClass instrumentClass(AspectManager manager, ScopedClassPool pool, CtClass clazz, boolean isLoadedClass) throws NotFoundException, Exception {
        boolean transformed;
        ClassPool superPool;
        if (WeavingRegistry.isClassLoadedButNotWoven((ClassPool)pool, clazz.getName())) {
            return null;
        }
        CtClass superClass = clazz.getSuperclass();
        if (superClass != null && !Instrumentor.implementsAdvised(clazz) && (superPool = superClass.getClassPool()) != null && superPool instanceof AbstractClassPool) {
            AspectManager aspectManager = manager;
            if (manager instanceof Domain && superPool != pool) {
                aspectManager = AspectManager.instance(superPool.getClassLoader());
            }
            this.instrumentClass(aspectManager, (ScopedClassPool)superPool, superClass, false);
        }
        if (manager.isNonAdvisableClassName(clazz.getName())) {
            return null;
        }
        if (clazz.isArray()) {
            if (this.verbose && logger.isDebugEnabled()) {
                logger.debug((Object)("cannot compile, isArray: " + clazz.getName()));
            }
            pool.flushClass(clazz.getName());
            return null;
        }
        if (clazz.isInterface()) {
            if (this.verbose && logger.isDebugEnabled()) {
                logger.debug((Object)("cannot compile, isInterface: " + clazz.getName()));
            }
            clazz.prune();
            return null;
        }
        if (clazz.isFrozen()) {
            if (this.isAdvised((ClassPool)pool, clazz)) {
                return null;
            }
            if (this.verbose && logger.isDebugEnabled()) {
                logger.debug((Object)("warning, isFrozen: " + clazz.getName() + " " + clazz.getClassPool()));
            }
            if (!isLoadedClass) {
                clazz = this.obtainCtClassInfo(pool, clazz.getName(), null);
            } else {
                return null;
            }
        }
        if (!(transformed = this.isAdvised((ClassPool)pool, clazz))) {
            ClassAdvisor advisor = AdvisorFactory.getClassAdvisor(clazz, manager);
            Instrumentor instrumentor = InstrumentorFactory.getInstrumentor((ClassPool)pool, manager, manager.dynamicStrategy.getJoinpointClassifier(), manager.dynamicStrategy.getDynamicTransformationObserver(clazz));
            if (!Instrumentor.isTransformable(clazz)) {
                if (this.verbose && logger.isDebugEnabled()) {
                    logger.debug((Object)("cannot compile, implements Untransformable: " + clazz.getName()));
                }
                return null;
            }
            manager.attachMetaData(advisor, clazz, true);
            manager.applyInterfaceIntroductions(advisor, clazz);
            transformed = instrumentor.transform(clazz, advisor);
        }
        if (transformed) {
            return clazz;
        }
        if (isLoadedClass) {
            WeavingRegistry.setClassLoadedButNotWoven((ClassPool)pool, clazz.getName());
        }
        return null;
    }

    public boolean isAdvised(ClassPool pool, CtClass clazz) throws NotFoundException {
        CtClass[] interfaces = clazz.getInterfaces();
        CtClass advised = pool.get(AOP_PACKAGE + ".Advised");
        for (int i = 0; i < interfaces.length; ++i) {
            if (interfaces[i].equals(advised)) {
                return true;
            }
            if (!interfaces[i].getName().equals(AOP_PACKAGE + ".Advised")) continue;
            return true;
        }
        return false;
    }
}

