/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.advice;

import org.jboss.aop.Advised;
import org.jboss.aop.Advisor;
import org.jboss.aop.InstanceAdvisor;
import org.jboss.aop.advice.AspectDefinition;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.CallerInvocation;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.proxy.container.ClassProxyContainer;
import org.jboss.aop.proxy.container.ContainerProxyMethodInvocation;

public class PerInstanceInterceptor
implements Interceptor {
    AspectDefinition aspectDefinition;

    public PerInstanceInterceptor(AspectDefinition a, Advisor advisor) {
        this.aspectDefinition = a;
        advisor.addPerInstanceAspect(a);
    }

    public String getName() {
        return this.aspectDefinition.getName();
    }

    public Object invoke(Invocation invocation) throws Throwable {
        if (invocation instanceof CallerInvocation) {
            Advised advised;
            InstanceAdvisor advisor;
            Interceptor interceptor;
            Object callingObject = ((CallerInvocation)invocation).getCallingObject();
            if (callingObject != null && (interceptor = (Interceptor)(advisor = (advised = (Advised)callingObject)._getInstanceAdvisor()).getPerInstanceAspect(this.aspectDefinition)) != null) {
                return interceptor.invoke(invocation);
            }
        } else {
            Interceptor interceptor;
            Object targetObject = invocation.getTargetObject();
            InstanceAdvisor instanceAdvisor = null;
            if (targetObject != null) {
                instanceAdvisor = this.getInstanceAdvisor(invocation, targetObject);
            }
            if (instanceAdvisor != null && (interceptor = this.getAspectInstance(instanceAdvisor)) != null) {
                return interceptor.invoke(invocation);
            }
        }
        return invocation.invokeNext();
    }

    private InstanceAdvisor getInstanceAdvisor(Invocation invocation, Object targetObject) {
        if (targetObject instanceof Advised) {
            Advised advised = (Advised)targetObject;
            return advised._getInstanceAdvisor();
        }
        Advisor advisor = invocation.getAdvisor();
        if (advisor != null) {
            if (advisor instanceof InstanceAdvisor) {
                return (InstanceAdvisor)((Object)advisor);
            }
            if (advisor instanceof ClassProxyContainer && invocation instanceof ContainerProxyMethodInvocation) {
                ContainerProxyMethodInvocation pi = (ContainerProxyMethodInvocation)invocation;
                return pi.getProxy().getInstanceAdvisor();
            }
        }
        return null;
    }

    public Interceptor getAspectInstance(InstanceAdvisor ia) {
        return (Interceptor)ia.getPerInstanceAspect(this.aspectDefinition);
    }
}

