/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.introduction;

import java.io.StringReader;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import javassist.CtClass;
import org.jboss.aop.Advisor;
import org.jboss.aop.pointcut.TypeMatcher;
import org.jboss.aop.pointcut.Util;
import org.jboss.aop.pointcut.ast.ASTStart;
import org.jboss.aop.pointcut.ast.ClassExpression;
import org.jboss.aop.pointcut.ast.ParseException;
import org.jboss.aop.pointcut.ast.TypeExpressionParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterfaceIntroduction {
    protected String name;
    protected ArrayList<WeakReference<Advisor>> advisors = new ArrayList();
    protected String[] interfaces;
    protected ArrayList<Mixin> mixins = new ArrayList();
    protected ClassExpression classExpr;
    protected ASTStart ast;
    protected String constructorClass;
    protected String constructorMethod;

    public InterfaceIntroduction() {
    }

    public InterfaceIntroduction(String name, String exp, String[] interfaces) {
        this.name = name;
        this.interfaces = interfaces;
        this.classExpr = new ClassExpression(exp);
    }

    public InterfaceIntroduction(String name, String exp, String[] interfaces, String constructorClass, String constructorMethod) {
        this(name, exp, interfaces);
        this.constructorClass = constructorClass;
        this.constructorMethod = constructorMethod;
    }

    public InterfaceIntroduction(String name, ASTStart ast, String[] interfaces) {
        this.name = name;
        this.ast = ast;
        this.interfaces = interfaces;
    }

    public InterfaceIntroduction(String name, ASTStart ast, String[] interfaces, String constructorClass, String constructorMethod) {
        this(name, ast, interfaces);
        this.constructorClass = constructorClass;
        this.constructorMethod = constructorMethod;
    }

    public void setClassExpression(String exp) {
        this.classExpr = new ClassExpression(exp);
    }

    public void setTypeExpression(String exp) {
        try {
            this.ast = new TypeExpressionParser(new StringReader(exp)).Start();
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public void setMixins(ArrayList<Mixin> mixins) {
        this.mixins = mixins;
    }

    public void addMixin(Mixin mixin) {
        this.mixins.add(mixin);
    }

    public void setInterfaces(String[] interfaces) {
        this.interfaces = interfaces;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String[] getInterfaces() {
        return this.interfaces;
    }

    public ArrayList<Mixin> getMixins() {
        return this.mixins;
    }

    public String getConstructorClass() {
        return this.constructorClass;
    }

    public String getConstructorMethod() {
        return this.constructorMethod;
    }

    public void addAdvisor(Advisor advisor) {
        this.advisors.add(new WeakReference<Advisor>(advisor));
        advisor.addInterfaceIntroduction(this);
    }

    public void clearAdvisors() {
        for (int i = 0; i < this.advisors.size(); ++i) {
            Advisor advisor = (Advisor)this.advisors.get(i).get();
            if (advisor == null) continue;
            advisor.removeInterfaceIntroduction(this);
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof InterfaceIntroduction)) {
            return false;
        }
        return ((InterfaceIntroduction)obj).getName().equals(this.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String getClassExpr() {
        if (this.classExpr == null) {
            return null;
        }
        return this.classExpr.getOriginal();
    }

    public ASTStart getAst() {
        return this.ast;
    }

    public boolean matches(Advisor advisor, CtClass clazz) throws Exception {
        if (this.classExpr != null) {
            return Util.matchesClassExpr(this.classExpr, clazz, advisor);
        }
        TypeMatcher matcher = new TypeMatcher(advisor, clazz);
        return (Boolean)this.ast.jjtAccept(matcher, null);
    }

    public boolean matches(Advisor advisor, Class<?> clazz) {
        if (this.classExpr != null) {
            return Util.matchesClassExpr(this.classExpr, clazz, advisor);
        }
        TypeMatcher matcher = new TypeMatcher(advisor, clazz);
        return (Boolean)this.ast.jjtAccept(matcher, null);
    }

    public static class Mixin {
        protected String classname;
        protected String[] interfaces;
        protected String construction;
        protected boolean trans;

        public Mixin() {
        }

        public Mixin(String classname, String[] interfaces, String construction, boolean trans) {
            this.classname = classname;
            this.interfaces = interfaces;
            this.construction = construction;
            this.trans = trans;
        }

        public String getClassName() {
            return this.classname;
        }

        public String[] getInterfaces() {
            return this.interfaces;
        }

        public String getConstruction() {
            return this.construction;
        }

        public boolean isTransient() {
            return this.trans;
        }

        public void setClassname(String classname) {
            this.classname = classname;
        }

        public void setInterfaces(String[] interfaces) {
            this.interfaces = interfaces;
        }

        public void setConstruction(String construction) {
            this.construction = construction;
        }

        public void setTrans(boolean trans) {
            this.trans = trans;
        }
    }
}

