/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.apiviz;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.DocErrorReporter;
import com.sun.javadoc.LanguageVersion;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.RootDoc;
import com.sun.tools.doclets.standard.Standard;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jdepend.framework.JDepend;
import jdepend.framework.PackageFilter;
import org.jboss.apiviz.APIvizRootDoc;
import org.jboss.apiviz.ClassDocGraph;
import org.jboss.apiviz.Constant;
import org.jboss.apiviz.FileUtil;
import org.jboss.apiviz.Graphviz;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class APIviz {
    private static final Pattern INSERTION_POINT_PATTERN = Pattern.compile("((<\\/PRE>)(?=\\s*<P>)|(?=<TABLE BORDER=\"1\"))");

    public static boolean start(RootDoc root) {
        if (!Standard.start((RootDoc)(root = new APIvizRootDoc(root)))) {
            return false;
        }
        if (!Graphviz.isAvailable()) {
            root.printWarning("Graphviz is not found in the system path.");
            root.printWarning("Skipping diagram generation.");
            return true;
        }
        try {
            File outputDirectory = APIviz.getOutputDirectory(root.options());
            ClassDocGraph graph = new ClassDocGraph(root);
            APIviz.generateOverviewSummary(root, graph, outputDirectory);
            APIviz.generatePackageSummaries(root, graph, outputDirectory);
            APIviz.generateClassDiagrams(root, graph, outputDirectory);
        }
        catch (Throwable t) {
            root.printError("An error occurred during diagram generation: " + t.toString());
            t.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean validOptions(String[][] options, DocErrorReporter errorReporter) {
        return Standard.validOptions((String[][])options, (DocErrorReporter)errorReporter);
    }

    public static int optionLength(String option) {
        return Standard.optionLength((String)option);
    }

    public static LanguageVersion languageVersion() {
        return Standard.languageVersion();
    }

    private static void generateOverviewSummary(RootDoc root, ClassDocGraph graph, File outputDirectory) throws IOException {
        File[] classPath;
        final Set<String> packageNames = APIviz.getPackages(root).keySet();
        PackageFilter packageFilter = new PackageFilter(){

            public boolean accept(String packageName) {
                return packageNames.contains(packageName);
            }
        };
        JDepend jdepend = new JDepend(packageFilter);
        for (File e : classPath = APIviz.getClassPath(root.options())) {
            if (e.isDirectory()) {
                jdepend.addDirectory(e.toString());
                continue;
            }
            root.printNotice("Excluding from dependency analysis: " + e);
        }
        jdepend.analyze();
        APIviz.instrumentDiagram(root, outputDirectory, "overview-summary", graph.getOverviewSummaryDiagram(jdepend));
    }

    private static void generatePackageSummaries(RootDoc root, ClassDocGraph graph, File outputDirectory) throws IOException {
        for (PackageDoc p : APIviz.getPackages(root).values()) {
            APIviz.instrumentDiagram(root, outputDirectory, p.name().replace('.', File.separatorChar) + File.separatorChar + "package-summary", graph.getPackageSummaryDiagram(p));
        }
    }

    private static void generateClassDiagrams(RootDoc root, ClassDocGraph graph, File outputDirectory) throws IOException {
        for (ClassDoc c : root.classes()) {
            APIviz.instrumentDiagram(root, outputDirectory, c.qualifiedName().replace('.', File.separatorChar), graph.getClassDiagram(c));
        }
    }

    static Map<String, PackageDoc> getPackages(RootDoc root) {
        TreeMap<String, PackageDoc> packages = new TreeMap<String, PackageDoc>();
        for (ClassDoc c : root.classes()) {
            PackageDoc p = c.containingPackage();
            if (packages.containsKey(p.name())) continue;
            packages.put(p.name(), p);
        }
        return packages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void instrumentDiagram(RootDoc root, File outputDirectory, String filename, String diagram) throws IOException {
        boolean needsBottomMargin = filename.contains("overview-summary") || filename.contains("package-summary");
        File htmlFile = new File(outputDirectory, filename + ".html");
        File pngFile = new File(outputDirectory, filename + ".png");
        File mapFile = new File(outputDirectory, filename + ".map");
        if (!htmlFile.exists()) {
            do {
                int idx;
                if ((idx = filename.lastIndexOf(File.separatorChar)) <= 0) {
                    return;
                }
                filename = filename.substring(0, idx) + '.' + filename.substring(idx + 1);
            } while (!(htmlFile = new File(outputDirectory, filename + ".html")).exists());
            pngFile = new File(outputDirectory, filename + ".png");
            mapFile = new File(outputDirectory, filename + ".map");
        }
        root.printNotice("Generating " + pngFile + "...");
        Graphviz.writeImageAndMap(diagram, outputDirectory, filename);
        try {
            String oldContent = FileUtil.readFile(htmlFile);
            String mapContent = FileUtil.readFile(mapFile);
            Matcher matcher = INSERTION_POINT_PATTERN.matcher(oldContent);
            if (!matcher.find()) {
                throw new IllegalStateException("Failed to find an insertion point.");
            }
            String newContent = oldContent.substring(0, matcher.end()) + mapContent + Constant.NEWLINE + "<CENTER><IMG SRC=\"" + pngFile.getName() + "\" USEMAP=\"#APIVIZ\" BORDER=\"0\"></CENTER>" + Constant.NEWLINE + (needsBottomMargin ? "<BR>" : "") + Constant.NEWLINE + oldContent.substring(matcher.end());
            FileUtil.writeFile(htmlFile, newContent);
        }
        finally {
            mapFile.delete();
        }
    }

    private static File getOutputDirectory(String[][] options) {
        for (String[] o : options) {
            if (!o[0].equals("-d")) continue;
            return new File(o[1]);
        }
        return new File(System.getProperty("user.dir", "."));
    }

    private static File[] getClassPath(String[][] options) {
        for (String[] o : options) {
            if (!o[0].equals("-classpath")) continue;
            String[] cps = o[1].split(File.pathSeparator);
            File[] cpf = new File[cps.length];
            for (int i = 0; i < cpf.length; ++i) {
                cpf[i] = new File(cps[i]);
            }
            return cpf;
        }
        return new File[]{new File(System.getProperty("user.dir", "."))};
    }
}

