/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.apiviz;

import com.sun.javadoc.ClassDoc;
import java.util.Comparator;
import org.jboss.apiviz.ClassDocGraph;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ClassDocComparator
implements Comparator<ClassDoc> {
    private final boolean portrait;

    ClassDocComparator(boolean portrait) {
        this.portrait = portrait;
    }

    @Override
    public int compare(ClassDoc a, ClassDoc b) {
        int precedenceDiff = ClassDocComparator.getPrecedence(a) - ClassDocComparator.getPrecedence(b);
        if (precedenceDiff != 0) {
            if (this.portrait) {
                return -precedenceDiff;
            }
            return precedenceDiff;
        }
        return a.name().compareTo(b.name());
    }

    private static int getPrecedence(ClassDoc c) {
        if (c.isAnnotationType()) {
            return 0;
        }
        if (c.isEnum()) {
            return 1;
        }
        if (ClassDocGraph.isStaticType(c)) {
            return 2;
        }
        if (c.isInterface()) {
            return 3;
        }
        if (c.isAbstract()) {
            return 4;
        }
        if (c.isError() || c.isException()) {
            return 100;
        }
        return 50;
    }
}

