/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.apiviz;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.Tag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Pattern;
import jdepend.framework.JDepend;
import jdepend.framework.JavaPackage;
import org.jboss.apiviz.APIviz;
import org.jboss.apiviz.ClassDocComparator;
import org.jboss.apiviz.Constant;
import org.jboss.apiviz.Edge;
import org.jboss.apiviz.EdgeType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassDocGraph {
    private final RootDoc root;
    private final Map<String, ClassDoc> nodes = new TreeMap<String, ClassDoc>();
    private final Map<ClassDoc, Set<Edge>> edges = new HashMap<ClassDoc, Set<Edge>>();
    private final Map<ClassDoc, Set<Edge>> reversedEdges = new HashMap<ClassDoc, Set<Edge>>();

    public ClassDocGraph(RootDoc root) {
        this.root = root;
        root.printNotice("Building graph for all classes...");
        for (ClassDoc node : root.classes()) {
            this.addNode(node, true);
        }
    }

    private void addNode(ClassDoc node, boolean addRelatedClasses) {
        String key = node.qualifiedName();
        if (!this.nodes.containsKey(key)) {
            this.nodes.put(key, node);
            this.edges.put(node, new TreeSet());
        }
        if (addRelatedClasses) {
            this.addRelatedClasses(node);
        }
    }

    private void addRelatedClasses(ClassDoc type) {
        ClassDoc superType = type.superclass();
        if (!(superType == null || superType.qualifiedName().equals("java.lang.Object") || superType.qualifiedName().equals("java.lang.Annotation") || superType.qualifiedName().equals("java.lang.Enum"))) {
            this.addNode(superType, false);
            this.addEdge(new Edge(EdgeType.GENERALIZATION, (Doc)type, (Doc)superType));
        }
        for (ClassDoc classDoc : type.interfaces()) {
            if (classDoc.qualifiedName().equals("java.lang.annotation.Annotation")) continue;
            this.addNode(classDoc, false);
            this.addEdge(new Edge(EdgeType.REALIZATION, (Doc)type, (Doc)classDoc));
        }
        for (ClassDoc classDoc : type.tags()) {
            if (classDoc.name().equals("@apiviz.uses")) {
                this.addEdge(new Edge(this.root, EdgeType.DEPENDENCY, (Doc)type, classDoc.text()));
                continue;
            }
            if (classDoc.name().equals("@apiviz.has")) {
                this.addEdge(new Edge(this.root, EdgeType.NAVIGABILITY, (Doc)type, classDoc.text()));
                continue;
            }
            if (classDoc.name().equals("@apiviz.owns")) {
                this.addEdge(new Edge(this.root, EdgeType.AGGREGATION, (Doc)type, classDoc.text()));
                continue;
            }
            if (!classDoc.name().equals("@apiviz.composedOf")) continue;
            this.addEdge(new Edge(this.root, EdgeType.COMPOSITION, (Doc)type, classDoc.text()));
        }
        for (ClassDoc classDoc : type.seeTags()) {
            try {
                if (classDoc.referencedClass() == null) {
                }
            }
            catch (Exception e) {}
            continue;
            String a = type.qualifiedName();
            String b = classDoc.referencedClass().qualifiedName();
            this.addNode(classDoc.referencedClass(), false);
            if (a.compareTo(b) == 0) continue;
            if (a.compareTo(b) < 0) {
                this.addEdge(new Edge(this.root, EdgeType.SEE_ALSO, (Doc)type, b + " - - &#171;see also&#187;"));
                continue;
            }
            this.addEdge(new Edge(this.root, EdgeType.SEE_ALSO, (Doc)classDoc.referencedClass(), a + " - - &#171;see also&#187;"));
        }
    }

    private void addEdge(Edge edge) {
        this.edges.get(edge.getSource()).add(edge);
        Set<Edge> reversedEdgeSubset = this.reversedEdges.get(edge.getTarget());
        if (reversedEdgeSubset == null) {
            reversedEdgeSubset = new TreeSet<Edge>();
            this.reversedEdges.put((ClassDoc)edge.getTarget(), reversedEdgeSubset);
        }
        reversedEdgeSubset.add(edge);
    }

    public String getOverviewSummaryDiagram(JDepend jdepend) {
        int prefixLen;
        TreeMap<String, PackageDoc> packages = new TreeMap<String, PackageDoc>();
        TreeSet<Edge> edgesToRender = new TreeSet<Edge>();
        this.addPackageDependencies(jdepend, packages, edgesToRender);
        HashMap<Doc, Set<Doc>> dependencies = new HashMap<Doc, Set<Doc>>();
        for (Edge edge : edgesToRender) {
            HashSet<Doc> nextDependencies = (HashSet<Doc>)dependencies.get(edge.getSource());
            if (nextDependencies == null) {
                nextDependencies = new HashSet<Doc>();
                dependencies.put(edge.getSource(), nextDependencies);
            }
            nextDependencies.add(edge.getTarget());
        }
        block1: for (int i = edgesToRender.size(); i > 0; --i) {
            for (Edge edge : edgesToRender) {
                if (!ClassDocGraph.isIndirectlyReachable(dependencies, edge.getSource(), edge.getTarget())) continue;
                edgesToRender.remove(edge);
                Set targets = (Set)dependencies.get(edge.getSource());
                if (targets == null) continue block1;
                targets.remove(edge.getTarget());
                continue block1;
            }
        }
        int minPackageNameLen = Integer.MAX_VALUE;
        int maxPackageNameLen = Integer.MIN_VALUE;
        for (String pname : packages.keySet()) {
            if (pname.length() > maxPackageNameLen) {
                maxPackageNameLen = pname.length();
            }
            if (pname.length() >= minPackageNameLen) continue;
            minPackageNameLen = pname.length();
        }
        if (minPackageNameLen == 0) {
            throw new IllegalStateException("Unexpected empty package name");
        }
        String firstPackageName = (String)packages.keySet().iterator().next();
        for (prefixLen = minPackageNameLen; prefixLen > 0; --prefixLen) {
            if (firstPackageName.charAt(prefixLen - 1) != '.') continue;
            String candidatePrefix = firstPackageName.substring(0, prefixLen);
            boolean found = true;
            for (String pname : packages.keySet()) {
                if (pname.startsWith(candidatePrefix)) continue;
                found = false;
                break;
            }
            if (found) break;
        }
        StringBuilder buf = new StringBuilder(16384);
        buf.append("digraph APIVIZ {" + Constant.NEWLINE + "rankdir=LR;" + Constant.NEWLINE + "ranksep=0.3;" + Constant.NEWLINE + "nodesep=0.3;" + Constant.NEWLINE + "mclimit=128;" + Constant.NEWLINE + "outputorder=edgesfirst;" + Constant.NEWLINE + "center=1;" + Constant.NEWLINE + "remincross=true;" + Constant.NEWLINE + "searchsize=65536;" + Constant.NEWLINE + "edge [fontsize=10, fontname=\"" + "Helvetica" + "\", " + "style=\"setlinewidth(0.6)\"]; " + Constant.NEWLINE + "node [shape=box, fontsize=10, fontname=\"" + "Helvetica" + "\", " + "width=0.1, height=0.1, style=\"setlinewidth(0.6)\"]; " + Constant.NEWLINE);
        for (PackageDoc pkg : packages.values()) {
            ClassDocGraph.renderPackage(buf, pkg, prefixLen);
        }
        for (Edge edge : edgesToRender) {
            this.renderEdge(null, buf, edge);
        }
        buf.append("}" + Constant.NEWLINE);
        return buf.toString();
    }

    private void addPackageDependencies(JDepend jdepend, Map<String, PackageDoc> packages, Set<Edge> edgesToRender) {
        Map<String, PackageDoc> allPackages = APIviz.getPackages(this.root);
        for (String pname : allPackages.keySet()) {
            if (ClassDocGraph.isHidden((Doc)allPackages.get(pname))) continue;
            packages.put(pname, allPackages.get(pname));
            JavaPackage pkg = jdepend.getPackage(pname);
            Collection epkgs = pkg.getEfferents();
            for (JavaPackage epkg : epkgs) {
                if (ClassDocGraph.isHidden((Doc)allPackages.get(epkg.getName()))) continue;
                ClassDocGraph.addPackageDependency(edgesToRender, allPackages.get(pname), allPackages.get(epkg.getName()));
            }
        }
    }

    private static boolean isHidden(Doc node) {
        if (node.tags("@apiviz.hidden").length > 0) {
            return true;
        }
        Tag[] tags = node.tags("@apiviz.exclude");
        if (tags == null) {
            return false;
        }
        for (Tag t : tags) {
            if (t.text() != null && t.text().trim().length() != 0) continue;
            return true;
        }
        return false;
    }

    private static void addPackageDependency(Set<Edge> edgesToRender, PackageDoc source, PackageDoc target) {
        if (source != target && source.isIncluded() && target.isIncluded()) {
            edgesToRender.add(new Edge(EdgeType.DEPENDENCY, (Doc)source, (Doc)target));
        }
    }

    private static boolean isIndirectlyReachable(Map<Doc, Set<Doc>> dependencyGraph, Doc source, Doc target) {
        Set<Doc> intermediaryTargets = dependencyGraph.get(source);
        if (intermediaryTargets == null || intermediaryTargets.isEmpty()) {
            return false;
        }
        HashSet<Doc> visited = new HashSet<Doc>();
        visited.add(source);
        for (Doc t : intermediaryTargets) {
            if (t == target || !ClassDocGraph.isIndirectlyReachable(dependencyGraph, t, target, visited)) continue;
            return true;
        }
        return false;
    }

    private static boolean isIndirectlyReachable(Map<Doc, Set<Doc>> dependencyGraph, Doc source, Doc target, Set<Doc> visited) {
        if (visited.contains(source)) {
            return false;
        }
        visited.add(source);
        Set<Doc> intermediaryTargets = dependencyGraph.get(source);
        if (intermediaryTargets == null || intermediaryTargets.isEmpty()) {
            return false;
        }
        for (Doc t : intermediaryTargets) {
            if (t == target) {
                return true;
            }
            if (!ClassDocGraph.isIndirectlyReachable(dependencyGraph, t, target, visited)) continue;
            return true;
        }
        return false;
    }

    public String getPackageSummaryDiagram(PackageDoc pkg) {
        StringBuilder buf = new StringBuilder(16384);
        buf.append("digraph APIVIZ {" + Constant.NEWLINE + "rankdir=LR;" + Constant.NEWLINE + "ranksep=0.3;" + Constant.NEWLINE + "nodesep=0.3;" + Constant.NEWLINE + "mclimit=1024;" + Constant.NEWLINE + "outputorder=edgesfirst;" + Constant.NEWLINE + "center=1;" + Constant.NEWLINE + "remincross=true;" + Constant.NEWLINE + "searchsize=65536;" + Constant.NEWLINE + "edge [fontsize=10, fontname=\"" + "Helvetica" + "\", " + "style=\"setlinewidth(0.6)\"]; " + Constant.NEWLINE + "node [shape=box, fontsize=10, fontname=\"" + "Helvetica" + "\", " + "width=0.1, height=0.1, style=\"setlinewidth(0.6)\"]; " + Constant.NEWLINE);
        TreeMap<String, ClassDoc> nodesToRender = new TreeMap<String, ClassDoc>();
        TreeSet<Edge> edgesToRender = new TreeSet<Edge>();
        for (ClassDoc node : this.nodes.values()) {
            this.fetchSubgraph(pkg, node, nodesToRender, edgesToRender, true, false, true);
        }
        this.renderSubgraph(pkg, null, buf, nodesToRender, edgesToRender, true);
        buf.append("}" + Constant.NEWLINE);
        return buf.toString();
    }

    private void fetchSubgraph(PackageDoc pkg, ClassDoc cls, Map<String, ClassDoc> nodesToRender, Set<Edge> edgesToRender, boolean useHidden, boolean useSee, boolean forceInherit) {
        if (useHidden && ClassDocGraph.isHidden((Doc)cls)) {
            return;
        }
        if (forceInherit) {
            for (Tag t : pkg.tags("@apiviz.exclude")) {
                if (t.text() == null || t.text().trim().length() == 0 || !Pattern.compile(t.text().trim()).matcher(cls.qualifiedName()).find()) continue;
                return;
            }
        }
        if (cls.containingPackage() == pkg) {
            Set<Edge> directEdges = this.edges.get(cls);
            nodesToRender.put(cls.qualifiedName(), cls);
            for (Edge edge : directEdges) {
                Pattern p;
                if (!useSee && edge.getType() == EdgeType.SEE_ALSO) continue;
                ClassDoc source = (ClassDoc)edge.getSource();
                ClassDoc target = (ClassDoc)edge.getTarget();
                boolean excluded = false;
                if (forceInherit || cls.tags("@apiviz.inherit").length > 0) {
                    for (Tag t : pkg.tags("@apiviz.exclude")) {
                        if (t.text() == null || t.text().trim().length() == 0) continue;
                        p = Pattern.compile(t.text().trim());
                        if (p.matcher(source.qualifiedName()).find()) {
                            excluded = true;
                            break;
                        }
                        if (!p.matcher(target.qualifiedName()).find()) continue;
                        excluded = true;
                        break;
                    }
                    if (excluded) continue;
                }
                for (Tag t : cls.tags("@apiviz.exclude")) {
                    if (t.text() == null || t.text().trim().length() == 0) continue;
                    p = Pattern.compile(t.text().trim());
                    if (p.matcher(source.qualifiedName()).find()) {
                        excluded = true;
                        break;
                    }
                    if (!p.matcher(target.qualifiedName()).find()) continue;
                    excluded = true;
                    break;
                }
                if (excluded) continue;
                if (!useHidden || !ClassDocGraph.isHidden((Doc)source) && !ClassDocGraph.isHidden((Doc)target)) {
                    edgesToRender.add(edge);
                }
                if (!useHidden || !ClassDocGraph.isHidden((Doc)source)) {
                    nodesToRender.put(source.qualifiedName(), source);
                }
                if (useHidden && ClassDocGraph.isHidden((Doc)target)) continue;
                nodesToRender.put(target.qualifiedName(), target);
            }
            Set<Edge> reversedDirectEdges = this.reversedEdges.get(cls);
            if (reversedDirectEdges != null) {
                for (Edge edge : reversedDirectEdges) {
                    Pattern p;
                    if (!useSee && edge.getType() == EdgeType.SEE_ALSO || cls.tags("@apiviz.excludeSubtypes").length > 0 && (edge.getType() == EdgeType.GENERALIZATION || edge.getType() == EdgeType.REALIZATION)) continue;
                    ClassDoc source = (ClassDoc)edge.getSource();
                    ClassDoc target = (ClassDoc)edge.getTarget();
                    boolean excluded = false;
                    if (forceInherit || cls.tags("@apiviz.inherit").length > 0) {
                        for (Tag t : pkg.tags("@apiviz.exclude")) {
                            if (t.text() == null || t.text().trim().length() == 0) continue;
                            p = Pattern.compile(t.text().trim());
                            if (p.matcher(source.qualifiedName()).find()) {
                                excluded = true;
                                break;
                            }
                            if (!p.matcher(target.qualifiedName()).find()) continue;
                            excluded = true;
                            break;
                        }
                        if (excluded) continue;
                    }
                    for (Tag t : cls.tags("@apiviz.exclude")) {
                        if (t.text() == null || t.text().trim().length() == 0) continue;
                        p = Pattern.compile(t.text().trim());
                        if (p.matcher(source.qualifiedName()).find()) {
                            excluded = true;
                            break;
                        }
                        if (!p.matcher(target.qualifiedName()).find()) continue;
                        excluded = true;
                        break;
                    }
                    if (excluded) continue;
                    if (!useHidden || !ClassDocGraph.isHidden((Doc)source) && !ClassDocGraph.isHidden((Doc)target)) {
                        edgesToRender.add(edge);
                    }
                    if (!useHidden || !ClassDocGraph.isHidden((Doc)source)) {
                        nodesToRender.put(source.qualifiedName(), source);
                    }
                    if (useHidden && ClassDocGraph.isHidden((Doc)target)) continue;
                    nodesToRender.put(target.qualifiedName(), target);
                }
            }
        }
    }

    public String getClassDiagram(ClassDoc cls) {
        boolean portrait;
        PackageDoc pkg = cls.containingPackage();
        StringBuilder buf = new StringBuilder(16384);
        TreeMap<String, ClassDoc> nodesToRender = new TreeMap<String, ClassDoc>();
        TreeSet<Edge> edgesToRender = new TreeSet<Edge>();
        this.fetchSubgraph(pkg, cls, nodesToRender, edgesToRender, false, true, false);
        buf.append("digraph APIVIZ {" + Constant.NEWLINE);
        int nodesAbove = 0;
        int nodesBelow = 0;
        for (Edge e : edgesToRender) {
            if (e.getType().isReversed()) {
                if (e.getSource() == cls) {
                    ++nodesAbove;
                    continue;
                }
                ++nodesBelow;
                continue;
            }
            if (e.getSource() == cls) {
                ++nodesBelow;
                continue;
            }
            ++nodesAbove;
        }
        if (Math.max(nodesAbove, nodesBelow) <= 5) {
            buf.append("rankdir=TB;" + Constant.NEWLINE + "ranksep=0.4;" + Constant.NEWLINE + "nodesep=0.3;" + Constant.NEWLINE);
            portrait = false;
        } else {
            buf.append("rankdir=LR;" + Constant.NEWLINE + "ranksep=1.0;" + Constant.NEWLINE + "nodesep=0.2;" + Constant.NEWLINE);
            portrait = true;
        }
        buf.append("mclimit=128;" + Constant.NEWLINE + "outputorder=edgesfirst;" + Constant.NEWLINE + "center=1;" + Constant.NEWLINE + "remincross=true;" + Constant.NEWLINE + "searchsize=65536;" + Constant.NEWLINE + "edge [fontsize=10, fontname=\"" + "Helvetica" + "\", " + "style=\"setlinewidth(0.6)\"]; " + Constant.NEWLINE + "node [shape=box, fontsize=10, fontname=\"" + "Helvetica" + "\", " + "width=0.1, height=0.1, style=\"setlinewidth(0.6)\"]; " + Constant.NEWLINE);
        this.renderSubgraph(pkg, cls, buf, nodesToRender, edgesToRender, portrait);
        buf.append("}" + Constant.NEWLINE);
        return buf.toString();
    }

    private void renderSubgraph(PackageDoc pkg, ClassDoc cls, StringBuilder buf, Map<String, ClassDoc> nodesToRender, Set<Edge> edgesToRender, boolean portrait) {
        ArrayList<ClassDoc> nodesToRenderCopy = new ArrayList<ClassDoc>(nodesToRender.values());
        Collections.sort(nodesToRenderCopy, new ClassDocComparator(portrait));
        for (ClassDoc node : nodesToRenderCopy) {
            ClassDocGraph.renderClass(pkg, cls, buf, node);
        }
        for (Edge edge : edgesToRender) {
            this.renderEdge(pkg, buf, edge);
        }
    }

    private static void renderPackage(StringBuilder buf, PackageDoc pkg, int prefixLen) {
        String href = pkg.name().replace('.', '/') + "/package-summary.html";
        buf.append(ClassDocGraph.getNodeId((Doc)pkg));
        buf.append(" [label=\"");
        buf.append(pkg.name().substring(prefixLen));
        buf.append("\", style=\"filled");
        if (pkg.tags("@deprecated").length > 0) {
            buf.append(",dotted");
        }
        buf.append("\", fillcolor=\"");
        buf.append(ClassDocGraph.getFillColor(pkg));
        buf.append("\", href=\"");
        buf.append(href);
        buf.append("\"];");
        buf.append(Constant.NEWLINE);
    }

    private static void renderClass(PackageDoc pkg, ClassDoc cls, StringBuilder buf, ClassDoc node) {
        String fillColor = ClassDocGraph.getFillColor(pkg, cls, node);
        String lineColor = ClassDocGraph.getLineColor(pkg, node);
        String fontColor = ClassDocGraph.getFontColor(pkg, node);
        String href = ClassDocGraph.getPath(pkg, node);
        buf.append(ClassDocGraph.getNodeId((Doc)node));
        buf.append(" [label=\"");
        buf.append(ClassDocGraph.getNodeLabel(pkg, node));
        buf.append("\", tooltip=\"");
        buf.append(ClassDocGraph.escape(ClassDocGraph.getNodeLabel(pkg, node)));
        buf.append("\"");
        if (node.isAbstract() && !node.isInterface()) {
            buf.append(", fontname=\"");
            buf.append("Helvetica-Oblique");
            buf.append("\"");
        }
        buf.append(", style=\"filled");
        if (node.tags("@deprecated").length > 0) {
            buf.append(",dotted");
        }
        buf.append("\", color=\"");
        buf.append(lineColor);
        buf.append("\", fontcolor=\"");
        buf.append(fontColor);
        buf.append("\", fillcolor=\"");
        buf.append(fillColor);
        if (href != null) {
            buf.append("\", href=\"");
            buf.append(href);
        }
        buf.append("\"];");
        buf.append(Constant.NEWLINE);
    }

    private void renderEdge(PackageDoc pkg, StringBuilder buf, Edge edge) {
        EdgeType type = edge.getType();
        String lineColor = ClassDocGraph.getLineColor(pkg, edge);
        String fontColor = ClassDocGraph.getFontColor(pkg, edge);
        boolean reverse = edge.getType().isReversed();
        if (reverse) {
            buf.append(ClassDocGraph.getNodeId(edge.getTarget()));
            buf.append(" -> ");
            buf.append(ClassDocGraph.getNodeId(edge.getSource()));
            buf.append(" [arrowhead=\"");
            buf.append(type.getArrowTail());
            buf.append("\", arrowtail=\"");
            buf.append(type.getArrowHead() == null ? (edge.isOneway() ? "open" : "none") : type.getArrowHead());
        } else {
            buf.append(ClassDocGraph.getNodeId(edge.getSource()));
            buf.append(" -> ");
            buf.append(ClassDocGraph.getNodeId(edge.getTarget()));
            buf.append(" [arrowhead=\"");
            buf.append(type.getArrowHead() == null ? (edge.isOneway() ? "open" : "none") : type.getArrowHead());
            buf.append("\", arrowtail=\"");
            buf.append(type.getArrowTail());
        }
        buf.append("\", style=\"" + type.getStyle());
        buf.append("\", color=\"");
        buf.append(lineColor);
        buf.append("\", fontcolor=\"");
        buf.append(fontColor);
        buf.append("\", label=\"");
        buf.append(ClassDocGraph.escape(edge.getEdgeLabel()));
        buf.append("\", headlabel=\"");
        buf.append(ClassDocGraph.escape(edge.getTargetLabel()));
        buf.append("\", taillabel=\"");
        buf.append(ClassDocGraph.escape(edge.getSourceLabel()));
        buf.append("\" ];");
        buf.append(Constant.NEWLINE);
    }

    private static String getStereotype(ClassDoc node) {
        String stereotype;
        String string = stereotype = node.isInterface() ? "interface" : null;
        if (node.isException() || node.isError()) {
            stereotype = "exception";
        } else if (node.isAnnotationType()) {
            stereotype = "annotation";
        } else if (node.isEnum()) {
            stereotype = "enum";
        } else if (ClassDocGraph.isStaticType(node)) {
            stereotype = "static";
        }
        if (node.tags("@apiviz.stereotype").length > 0) {
            stereotype = node.tags("@apiviz.stereotype")[0].text();
        }
        return ClassDocGraph.escape(stereotype);
    }

    static boolean isStaticType(ClassDoc node) {
        boolean staticType = true;
        int methods = 0;
        for (MethodDoc m : node.methods()) {
            if (m.isConstructor()) continue;
            ++methods;
            if (m.isStatic()) continue;
            staticType = false;
            break;
        }
        return staticType && methods > 0;
    }

    private static String getFillColor(PackageDoc pkg) {
        String color = "white";
        if (pkg.tags("@apiviz.landmark").length > 0) {
            color = "khaki1";
        }
        return color;
    }

    private static String getFillColor(PackageDoc pkg, ClassDoc cls, ClassDoc node) {
        String color = "white";
        if (cls == null) {
            if (node.containingPackage() == pkg && node.tags("@apiviz.landmark").length > 0) {
                color = "khaki1";
            }
        } else if (cls == node) {
            color = "khaki1";
        }
        return color;
    }

    private static String getLineColor(PackageDoc pkg, ClassDoc doc) {
        String color = "black";
        if (doc.containingPackage() != pkg) {
            color = "gray";
        }
        return color;
    }

    private static String getLineColor(PackageDoc pkg, Edge edge) {
        if (edge.getTarget() instanceof ClassDoc) {
            return ClassDocGraph.getLineColor(pkg, (ClassDoc)edge.getTarget());
        }
        return "black";
    }

    private static String getFontColor(PackageDoc pkg, ClassDoc doc) {
        String color = "black";
        if (doc.containingPackage() != pkg) {
            color = "gray30";
        }
        return color;
    }

    private static String getFontColor(PackageDoc pkg, Edge edge) {
        if (edge.getTarget() instanceof ClassDoc) {
            return ClassDocGraph.getFontColor(pkg, (ClassDoc)edge.getTarget());
        }
        return "black";
    }

    private static String getNodeId(Doc node) {
        String name = node instanceof ClassDoc ? ((ClassDoc)node).qualifiedName() : node.name();
        return name.replace('.', '_');
    }

    private static String getNodeLabel(PackageDoc pkg, ClassDoc node) {
        StringBuilder buf = new StringBuilder(256);
        String stereotype = ClassDocGraph.getStereotype(node);
        if (stereotype != null) {
            buf.append("&#171;");
            buf.append(stereotype);
            buf.append("&#187;\\n");
        }
        if (node.containingPackage() == pkg) {
            buf.append(node.name());
        } else {
            String name = node.qualifiedName();
            int dotIndex = name.lastIndexOf(46);
            if (dotIndex < 0) {
                buf.append(name);
            } else {
                buf.append(name.substring(dotIndex + 1));
                buf.append("\\n(");
                buf.append(name.substring(0, dotIndex));
                buf.append(')');
            }
        }
        return buf.toString();
    }

    private static String escape(String text) {
        if (text != null) {
            text = text.replaceAll("(\"|'|\\\\.?|\\s)+", " ");
        }
        return text;
    }

    private static String getPath(PackageDoc pkg, ClassDoc node) {
        int i;
        int commonLength;
        if (!node.isIncluded()) {
            return null;
        }
        String sourcePath = pkg.name().replace('.', '/');
        String targetPath = node.qualifiedName().replace('.', '/') + ".html";
        String[] sourcePathElements = sourcePath.split("[\\/\\\\]+");
        String[] targetPathElements = targetPath.split("[\\/\\\\]+");
        int maxCommonLength = Math.min(sourcePathElements.length, targetPathElements.length);
        for (commonLength = 0; commonLength < maxCommonLength && sourcePathElements[commonLength].equals(targetPathElements[commonLength]); ++commonLength) {
        }
        StringBuilder buf = new StringBuilder();
        for (i = 0; i < sourcePathElements.length - commonLength; ++i) {
            buf.append("/..");
        }
        for (i = commonLength; i < targetPathElements.length; ++i) {
            buf.append('/');
            buf.append(targetPathElements[i]);
        }
        return buf.substring(1);
    }
}

