/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.apiviz;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.RootDoc;
import org.jboss.apiviz.EdgeType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Edge
implements Comparable<Edge> {
    private final EdgeType type;
    private final Doc source;
    private final Doc target;
    private final String sourceLabel;
    private final String targetLabel;
    private final String edgeLabel;
    private final boolean oneway;
    private final int hashCode;

    public Edge(EdgeType type, Doc source, Doc target) {
        this.type = type;
        this.source = source;
        this.target = target;
        this.sourceLabel = "";
        this.targetLabel = "";
        this.edgeLabel = "";
        this.oneway = true;
        this.hashCode = this.calculateHashCode();
    }

    private int calculateHashCode() {
        return ((((((this.oneway ? 31 : 0) + this.type.hashCode()) * 31 + this.getSourceName().hashCode()) * 31 + this.getTargetName().hashCode()) * 31 + this.sourceLabel.hashCode()) * 31 + this.targetLabel.hashCode()) * 31 + this.edgeLabel.hashCode();
    }

    private String getSourceName() {
        if (this.source instanceof ClassDoc) {
            return ((ClassDoc)this.source).qualifiedName();
        }
        return this.source.name();
    }

    private String getTargetName() {
        if (this.target instanceof ClassDoc) {
            return ((ClassDoc)this.target).qualifiedName();
        }
        return this.target.name();
    }

    public Edge(RootDoc rootDoc, EdgeType type, Doc source, String spec) {
        if (spec == null) {
            spec = "";
        }
        this.type = type;
        this.source = source;
        String[] args = spec.replaceAll("\\s+", " ").trim().split(" ");
        for (int i = 1; i < Math.min(4, args.length); ++i) {
            if (!args[i].equals("-")) continue;
            args[i] = "";
        }
        if (args.length == 1) {
            this.target = rootDoc.classNamed(args[0]);
            this.sourceLabel = "";
            this.targetLabel = "";
            this.edgeLabel = "";
            this.oneway = true;
        } else if (args.length >= 3) {
            this.target = rootDoc.classNamed(args[0]);
            if (args.length > 3) {
                int startIndex;
                if (args[1].equalsIgnoreCase("oneway")) {
                    this.oneway = true;
                    this.sourceLabel = args[2];
                    this.targetLabel = args[3];
                    startIndex = 4;
                } else {
                    this.oneway = false;
                    this.sourceLabel = args[1];
                    this.targetLabel = args[2];
                    startIndex = 3;
                }
                StringBuilder buf = new StringBuilder();
                for (int i = startIndex; i < args.length; ++i) {
                    buf.append(' ');
                    buf.append(args[i]);
                }
                this.edgeLabel = buf.length() == 0 ? "" : buf.substring(1);
            } else {
                this.oneway = false;
                this.sourceLabel = args[1];
                this.targetLabel = args[2];
                this.edgeLabel = "";
            }
        } else {
            throw new IllegalArgumentException("Invalid relationship syntax: " + spec);
        }
        if (this.target == null) {
            throw new IllegalArgumentException("Invalid relationship syntax: " + spec + " (Unknown package or class name)");
        }
        this.hashCode = this.calculateHashCode();
    }

    public EdgeType getType() {
        return this.type;
    }

    public Doc getSource() {
        return this.source;
    }

    public Doc getTarget() {
        return this.target;
    }

    public String getSourceLabel() {
        return this.sourceLabel;
    }

    public String getTargetLabel() {
        return this.targetLabel;
    }

    public String getEdgeLabel() {
        return this.edgeLabel;
    }

    public boolean isOneway() {
        return this.oneway;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Edge)) {
            return false;
        }
        Edge that = (Edge)o;
        return this.type == that.type && this.oneway == that.oneway && this.source == that.source && this.target == that.target && this.edgeLabel.equals(that.edgeLabel) && this.sourceLabel.equals(that.sourceLabel) && this.targetLabel.equals(that.targetLabel);
    }

    @Override
    public int compareTo(Edge that) {
        int v = this.type.compareTo(that.type);
        if (v != 0) {
            return v;
        }
        v = this.getSourceName().compareTo(that.getSourceName());
        if (v != 0) {
            return v;
        }
        v = this.getTargetName().compareTo(that.getTargetName());
        if (v != 0) {
            return v;
        }
        v = Boolean.valueOf(this.oneway).compareTo(that.oneway);
        if (v != 0) {
            return v;
        }
        v = this.edgeLabel.compareTo(that.edgeLabel);
        if (v != 0) {
            return v;
        }
        v = this.sourceLabel.compareTo(that.sourceLabel);
        if (v != 0) {
            return v;
        }
        v = this.targetLabel.compareTo(that.targetLabel);
        return v;
    }
}

