/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.apiviz;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;

public class Graphviz {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isAvailable() {
        Process p;
        String executable = Graphviz.getExecutable();
        File home = Graphviz.getHome();
        ProcessBuilder pb = new ProcessBuilder(executable, "-V");
        pb.redirectErrorStream(true);
        if (home != null) {
            System.out.println("Graphviz Home: " + home);
            pb.directory(home);
        }
        System.out.println("Graphviz Executable: " + executable);
        try {
            p = pb.start();
        }
        catch (IOException e) {
            return false;
        }
        BufferedReader in = new BufferedReader(new InputStreamReader(p.getInputStream()));
        OutputStream out = p.getOutputStream();
        try {
            out.close();
            String line = null;
            while ((line = in.readLine()) != null) {
                if (line.indexOf("Graphviz") < 0) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                out.close();
            }
            catch (IOException e) {}
            try {
                in.close();
            }
            catch (IOException e) {}
            while (true) {
                try {
                    p.waitFor();
                }
                catch (InterruptedException e) {
                    continue;
                }
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeImageAndMap(String diagram, File outputDirectory, String filename) throws IOException {
        File pngFile = new File(outputDirectory, filename + ".png");
        File mapFile = new File(outputDirectory, filename + ".map");
        pngFile.delete();
        mapFile.delete();
        ProcessBuilder pb = new ProcessBuilder(Graphviz.getExecutable(), "-Tcmapx", "-o", mapFile.getAbsolutePath(), "-Tpng", "-o", pngFile.getAbsolutePath());
        pb.redirectErrorStream(true);
        File home = Graphviz.getHome();
        if (home != null) {
            pb.directory(home);
        }
        Process p = pb.start();
        BufferedReader in = new BufferedReader(new InputStreamReader(p.getInputStream()));
        OutputStreamWriter out = new OutputStreamWriter(p.getOutputStream(), "UTF-8");
        try {
            out.write(diagram);
            ((Writer)out).close();
            String line = null;
            while ((line = in.readLine()) != null) {
                System.err.println(line);
            }
        }
        finally {
            try {
                ((Writer)out).close();
            }
            catch (IOException e) {}
            try {
                in.close();
            }
            catch (IOException e) {}
            while (true) {
                try {
                    int result = p.waitFor();
                    if (result != 0) {
                        throw new IllegalStateException("Graphviz exited with a non-zero return value: " + result);
                    }
                }
                catch (InterruptedException e) {
                    continue;
                }
                break;
            }
        }
    }

    private static String getExecutable() {
        String command = "dot";
        try {
            String osName = System.getProperty("os.name");
            if (osName != null && osName.indexOf("Windows") >= 0) {
                File path = Graphviz.getHome();
                command = path != null ? path.getAbsolutePath() + File.separator + "dot.exe" : "dot.exe";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return command;
    }

    private static File getHome() {
        File graphvizDir = null;
        try {
            String graphvizHome = System.getProperty("graphviz.home");
            if (!(graphvizHome == null || (graphvizDir = new File(graphvizHome)).exists() && graphvizDir.isDirectory())) {
                return null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return graphvizDir;
    }

    private Graphviz() {
    }
}

