/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.ajocado.ajaxaware;

import com.thoughtworks.selenium.SeleniumException;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.jboss.arquillian.ajocado.interception.CommandContext;
import org.jboss.arquillian.ajocado.interception.CommandInterceptionException;
import org.jboss.arquillian.ajocado.interception.CommandInterceptor;
import org.jboss.arquillian.ajocado.waiting.Wait;
import org.jboss.arquillian.ajocado.waiting.selenium.SeleniumWaiting;

public class AjaxAwareInterceptor
implements CommandInterceptor {
    private static final String[] PERMISSION_DENIED = new String[]{"ERROR: Threw an exception: Permission denied", "ERROR: Command execution failure. Please search the forum at http://clearspace.openqa.org for error details from the log window.  The error message is: Permission denied", "ERROR: Threw an exception: Error executing strategy function jquery: Permission denied"};
    private final long interval = 1000L;
    private final long timeout = 30000L;

    public void intercept(CommandContext ctx) throws CommandInterceptionException {
        long end = System.currentTimeMillis() + 30000L;
        boolean exceptionLogged = false;
        while (System.currentTimeMillis() < end) {
            try {
                ctx.invoke();
                return;
            }
            catch (SeleniumException e) {
                String message = StringUtils.defaultString((String)e.getMessage());
                if (ArrayUtils.contains((Object[])PERMISSION_DENIED, (Object)message)) {
                    System.err.println(message);
                    if (!exceptionLogged) {
                        exceptionLogged = true;
                        System.err.println(ctx.toString());
                        e.printStackTrace();
                    }
                    ((SeleniumWaiting)Wait.waitSelenium.timeout(1000L)).waitForTimeout();
                    continue;
                }
                throw e;
            }
        }
        throw new PermissionDeniedException("Fails with 'Permission denied' errors when trying to execute jQuery");
    }

    public static class PermissionDeniedException
    extends RuntimeException {
        private static final long serialVersionUID = 501755400552888059L;

        public PermissionDeniedException(String message) {
            super(message);
        }
    }
}

