/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.ajocado.framework;

import java.io.File;
import java.net.URL;
import org.apache.commons.lang.Validate;
import org.jboss.arquillian.ajocado.browser.Browser;
import org.jboss.arquillian.ajocado.framework.AjocadoConfiguration;
import org.jboss.arquillian.ajocado.utils.PrimitiveUtils;
import org.jboss.arquillian.ajocado.utils.URLUtils;

public class SystemPropertiesConfiguration
implements AjocadoConfiguration {
    public URL getContextRoot() {
        String contextRoot = System.getProperty("context.root");
        Validate.notNull((Object)contextRoot, (String)"context.root system property should be set");
        return URLUtils.buildUrl(contextRoot, new String[0]);
    }

    public URL getContextPath() {
        String contextPath = System.getProperty("context.path");
        Validate.notNull((Object)contextPath, (String)"context.path system property should be set");
        return URLUtils.buildUrl(this.getContextRoot(), contextPath);
    }

    public Browser getBrowser() {
        String browser = System.getProperty("browser");
        Validate.notNull((Object)browser, (String)"browser system property should be set");
        return new Browser(browser);
    }

    public File getResourcesDirectory() {
        return new File(System.getProperty("maven.resources.dir", "./target/test-classes/"));
    }

    public File getBuildDirectory() {
        return new File(System.getProperty("maven.project.build.directory", "./target/"));
    }

    public String getSeleniumHost() {
        String seleniumHost = System.getProperty("selenium.host", "localhost");
        Validate.notNull((Object)seleniumHost, (String)"selenium.host system property should be set");
        return seleniumHost;
    }

    public int getSeleniumPort() {
        String seleniumPort = System.getProperty("selenium.port");
        Validate.notNull((Object)seleniumPort, (String)"selenium.port system property should be set");
        return PrimitiveUtils.asInteger(seleniumPort);
    }

    public boolean isSeleniumMaximize() {
        return PrimitiveUtils.asBoolean(System.getProperty("selenium.maximize", "false"));
    }

    public boolean isSeleniumDebug() {
        return PrimitiveUtils.asBoolean(System.getProperty("selenium.debug", "false"));
    }

    public int getSeleniumSpeed() {
        return PrimitiveUtils.asInteger(System.getProperty("selenium.speed", "0"));
    }

    public boolean isSeleniumNetworkTrafficEnabled() {
        return PrimitiveUtils.asBoolean(System.getProperty("selenium.network.traffic", "false"));
    }

    public long getTimeout(AjocadoConfiguration.TimeoutType type) {
        Validate.notNull((Object)type);
        String seleniumTimeout = System.getProperty("selenium.timeout." + type.toString().toLowerCase());
        if (seleniumTimeout == null) {
            return type.getDefaultTimeout();
        }
        return PrimitiveUtils.asLong(seleniumTimeout);
    }
}

