/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.ajocado.framework;

import com.thoughtworks.selenium.Selenium;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.imageio.ImageIO;
import org.apache.commons.codec.binary.Base64;
import org.jboss.arquillian.ajocado.cookie.Cookie;
import org.jboss.arquillian.ajocado.cookie.CreateCookieOptions;
import org.jboss.arquillian.ajocado.cookie.DeleteCookieOptions;
import org.jboss.arquillian.ajocado.dom.Event;
import org.jboss.arquillian.ajocado.encapsulated.Frame;
import org.jboss.arquillian.ajocado.encapsulated.FrameLocator;
import org.jboss.arquillian.ajocado.encapsulated.JavaScript;
import org.jboss.arquillian.ajocado.encapsulated.LogLevel;
import org.jboss.arquillian.ajocado.encapsulated.NetworkTraffic;
import org.jboss.arquillian.ajocado.encapsulated.NetworkTrafficType;
import org.jboss.arquillian.ajocado.encapsulated.Window;
import org.jboss.arquillian.ajocado.encapsulated.WindowId;
import org.jboss.arquillian.ajocado.encapsulated.XpathLibrary;
import org.jboss.arquillian.ajocado.framework.AjocadoConfiguration;
import org.jboss.arquillian.ajocado.framework.AjocadoConfigurationContext;
import org.jboss.arquillian.ajocado.framework.TypedSelenium;
import org.jboss.arquillian.ajocado.framework.internal.UnsupportedTypedSelenium;
import org.jboss.arquillian.ajocado.geometry.Dimension;
import org.jboss.arquillian.ajocado.geometry.Offset;
import org.jboss.arquillian.ajocado.geometry.Point;
import org.jboss.arquillian.ajocado.locator.Attribute;
import org.jboss.arquillian.ajocado.locator.AttributeLocator;
import org.jboss.arquillian.ajocado.locator.ElementLocationStrategy;
import org.jboss.arquillian.ajocado.locator.ElementLocator;
import org.jboss.arquillian.ajocado.locator.IdLocator;
import org.jboss.arquillian.ajocado.locator.IterableLocator;
import org.jboss.arquillian.ajocado.locator.option.OptionLocator;
import org.jboss.arquillian.ajocado.request.RequestHeader;
import org.jboss.arquillian.ajocado.utils.SimplifiedFormat;
import org.jboss.arquillian.ajocado.utils.array.ArrayTransform;

public class TypedSeleniumImpl
implements TypedSelenium,
UnsupportedTypedSelenium {
    Selenium selenium;
    AjocadoConfiguration configuration = AjocadoConfigurationContext.getProxy();
    private ArrayTransform<String, Integer> transformArrayOfStringToInteger = new ArrayTransform<String, Integer>(Integer.class){

        @Override
        public Integer transformation(String source) {
            return Integer.valueOf(source);
        }
    };

    public void addLocationStrategy(ElementLocationStrategy locationStrategy, JavaScript strategyDefinition) {
        this.selenium.addLocationStrategy(locationStrategy.getStrategyName(), strategyDefinition.toString());
    }

    public void addScript(JavaScript javaScript) {
        this.selenium.addScript(javaScript.getAsString(), javaScript.getIdentification());
    }

    public void addSelection(ElementLocator<?> elementLocator, OptionLocator<?> optionLocator) {
        this.selenium.addSelection(elementLocator.getAsString(), optionLocator.getAsString());
    }

    public void allowNativeXpath(boolean allow) {
        this.selenium.allowNativeXpath(String.valueOf(allow));
    }

    public void altKeyDown() {
        this.selenium.altKeyDown();
    }

    public void altKeyUp() {
        this.selenium.altKeyUp();
    }

    public void answerOnNextPrompt(String answer) {
        this.selenium.answerOnNextPrompt(answer);
    }

    public IdLocator assignId(ElementLocator<?> elementLocator, String identifier) {
        this.selenium.assignId(elementLocator.getAsString(), identifier);
        return new IdLocator(identifier);
    }

    @Override
    public void attachFile(ElementLocator<?> fieldLocator, File fileLocator) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void attachFile(ElementLocator<?> fieldLocator, URL fileLocator) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void captureEntirePageScreenshot(File filename) {
        throw new UnsupportedOperationException();
    }

    public BufferedImage captureEntirePageScreenshot() {
        return this.decodeBase64Screenshot(this.selenium.captureEntirePageScreenshotToString(""));
    }

    public NetworkTraffic captureNetworkTraffic(NetworkTrafficType type) {
        String traffic = this.selenium.captureNetworkTraffic(type.getType());
        return new NetworkTraffic(type, traffic);
    }

    @Override
    public void captureScreenshot(File filename) {
        throw new UnsupportedOperationException();
    }

    public BufferedImage captureScreenshot() {
        return this.decodeBase64Screenshot(this.selenium.captureScreenshotToString());
    }

    public void check(ElementLocator<?> elementLocator) {
        this.selenium.check(elementLocator.getAsString());
    }

    public void chooseCancelOnNextConfirmation() {
        this.selenium.chooseCancelOnNextConfirmation();
    }

    public void chooseOkOnNextConfirmation() {
        this.selenium.chooseOkOnNextConfirmation();
    }

    public void click(ElementLocator<?> elementLocator) {
        this.selenium.click(elementLocator.getAsString());
    }

    public void clickAt(ElementLocator<?> elementLocator, Point point) {
        this.selenium.clickAt(elementLocator.getAsString(), point.getCoords());
    }

    public void close() {
        this.selenium.close();
    }

    public boolean containsScript(JavaScript javaScript) {
        String identification = javaScript.getIdentification();
        String evaluated = this.selenium.getEval(SimplifiedFormat.format((String)"document.getElementById('{0}') ? true : false", (Object[])new Object[]{identification}));
        return Boolean.valueOf(evaluated);
    }

    public void contextMenu(ElementLocator<?> elementLocator) {
        this.selenium.contextMenu(elementLocator.getAsString());
    }

    public void contextMenuAt(ElementLocator<?> elementLocator, Point point) {
        this.selenium.contextMenuAt(elementLocator.getAsString(), point.getCoords());
    }

    public void controlKeyDown() {
        this.selenium.controlKeyDown();
    }

    public void controlKeyUp() {
        this.selenium.controlKeyUp();
    }

    public void deleteAllVisibleCookies() {
        this.selenium.deleteAllVisibleCookies();
    }

    public void deselectPopUp() {
        this.selenium.deselectPopUp();
    }

    public void doubleClick(ElementLocator<?> elementLocator) {
        this.selenium.doubleClick(elementLocator.getAsString());
    }

    public void doubleClickAt(ElementLocator<?> elementLocator, Point point) {
        this.selenium.doubleClickAt(elementLocator.getAsString(), point.getCoords());
    }

    public void dragAndDrop(ElementLocator<?> elementLocator, Offset offset) {
        this.selenium.dragAndDrop(elementLocator.getAsString(), offset.getMovement());
    }

    public void dragAndDropToObject(ElementLocator<?> elementLocatorOfObjectToBeDragged, ElementLocator<?> elementLocatorOfDragDestinationObject) {
        this.selenium.dragAndDropToObject(elementLocatorOfDragDestinationObject.getAsString(), elementLocatorOfObjectToBeDragged.getAsString());
    }

    public void dragdrop(ElementLocator<?> elementLocator, Offset offset) {
        this.selenium.dragdrop(elementLocator.getAsString(), offset.getMovement());
    }

    public void fireEvent(ElementLocator<?> elementLocator, Event event) {
        this.selenium.fireEvent(elementLocator.getAsString(), event.getEventName());
    }

    public void focus(ElementLocator<?> elementLocator) {
        this.selenium.focus(elementLocator.getAsString());
    }

    public String getAlert() {
        return this.selenium.getAlert();
    }

    @Override
    public List<ElementLocator<?>> getAllButtons() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<ElementLocator<?>> getAllFields() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<ElementLocator<?>> getAllLinks() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<WindowId> getAllWindowIds() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<String> getAllWindowNames() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<String> getAllWindowTitles() {
        throw new UnsupportedOperationException();
    }

    public String getAttribute(AttributeLocator<?> attributeLocator) {
        return this.selenium.getAttribute(attributeLocator.getAsString());
    }

    @Override
    public List<String> getAttributeFromAllWindows(Attribute attribute) {
        throw new UnsupportedOperationException();
    }

    public String getBodyText() {
        return this.selenium.getBodyText();
    }

    public String getConfirmation() {
        return this.selenium.getConfirmation();
    }

    public int getCount(IterableLocator<?> locator) {
        if (locator.getLocationStrategy() != ElementLocationStrategy.XPATH) {
            throw new UnsupportedOperationException("Only XPath locators are supported for counting");
        }
        return this.selenium.getXpathCount(locator.getRawLocator()).intValue();
    }

    public int getCursorPosition(ElementLocator<?> elementLocator) {
        return this.selenium.getCursorPosition(elementLocator.getAsString()).intValue();
    }

    public Dimension getElementDimension(ElementLocator<?> elementLocator) {
        return new Dimension(this.getElementWidth(elementLocator), this.getElementHeight(elementLocator));
    }

    public int getElementHeight(ElementLocator<?> elementLocator) {
        return this.selenium.getElementHeight(elementLocator.getAsString()).intValue();
    }

    public int getElementIndex(ElementLocator<?> elementLocator) {
        return this.selenium.getElementIndex(elementLocator.getAsString()).intValue();
    }

    public Point getElementPosition(ElementLocator<?> elementLocator) {
        return new Point(this.getElementPositionLeft(elementLocator), this.getElementPositionTop(elementLocator));
    }

    public int getElementPositionLeft(ElementLocator<?> elementLocator) {
        return this.selenium.getElementPositionLeft(elementLocator.getAsString()).intValue();
    }

    public int getElementPositionTop(ElementLocator<?> elementLocator) {
        return this.selenium.getElementPositionTop(elementLocator.getAsString()).intValue();
    }

    public int getElementWidth(ElementLocator<?> elementLocator) {
        return this.selenium.getElementWidth(elementLocator.getAsString()).intValue();
    }

    public String getEval(JavaScript script) {
        return this.selenium.getEval(script.toString());
    }

    @Override
    public JavaScript getExpression(JavaScript expression) {
        throw new UnsupportedOperationException("not implemented yet");
    }

    public String getHtmlSource() {
        return this.selenium.getHtmlSource();
    }

    public URL getLocation() {
        try {
            return new URL(this.selenium.getLocation());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public int getMouseSpeed() {
        return this.selenium.getMouseSpeed().intValue();
    }

    public String getPrompt() {
        return this.selenium.getPrompt();
    }

    public List<String> getSelectOptions(ElementLocator<?> selectLocator) {
        return Arrays.asList(this.selenium.getSelectOptions(selectLocator.getAsString()));
    }

    public String getSelectedId(ElementLocator<?> selectLocator) {
        return this.selenium.getSelectedId(selectLocator.getAsString());
    }

    public List<String> getSelectedIds(ElementLocator<?> selectLocator) {
        return Arrays.asList(this.selenium.getSelectedIds(selectLocator.getAsString()));
    }

    public int getSelectedIndex(ElementLocator<?> selectLocator) {
        return Integer.valueOf(this.selenium.getSelectedIndex(selectLocator.getAsString()));
    }

    public List<Integer> getSelectedIndexes(ElementLocator<?> selectLocator) {
        return Arrays.asList(this.transformArrayOfStringToInteger.transform((String[])this.selenium.getSelectedIndexes(selectLocator.getAsString())));
    }

    public String getSelectedLabel(ElementLocator<?> selectLocator) {
        return this.selenium.getSelectedLabel(selectLocator.getAsString());
    }

    public List<String> getSelectedLabels(ElementLocator<?> selectLocator) {
        return Arrays.asList(this.selenium.getSelectedLabels(selectLocator.getAsString()));
    }

    public String getSelectedValue(ElementLocator<?> selectLocator) {
        return this.selenium.getSelectedValue(this.selenium.getSelectedValue(selectLocator.getAsString()));
    }

    public List<String> getSelectedValues(ElementLocator<?> selectLocator) {
        return Arrays.asList(this.selenium.getSelectedValues(selectLocator.getAsString()));
    }

    public long getSpeed() {
        return Long.valueOf(this.selenium.getSpeed());
    }

    public String getText(ElementLocator<?> elementLocator) {
        return this.selenium.getText(elementLocator.getAsString());
    }

    public String getTitle() {
        return this.selenium.getTitle();
    }

    public String getValue(ElementLocator<?> elementLocator) {
        return this.selenium.getValue(elementLocator.getAsString());
    }

    @Override
    public boolean getWhetherThisFrameMatchFrameExpression(Frame currentFrame, Frame targetFrame) {
        throw new UnsupportedOperationException("not implemented yet");
    }

    @Override
    public boolean getWhetherThisWindowMatchWindowExpression(Window currentWindowString, Window target) {
        throw new UnsupportedOperationException("not implemented yet");
    }

    public void goBack() {
        this.selenium.goBack();
    }

    public void highlight(ElementLocator<?> elementLocator) {
        this.selenium.highlight(elementLocator.getAsString());
    }

    public void ignoreAttributesWithoutValue(boolean ignore) {
        this.selenium.ignoreAttributesWithoutValue(String.valueOf(ignore));
    }

    public boolean isAlertPresent() {
        return this.selenium.isAlertPresent();
    }

    public boolean isChecked(ElementLocator<?> elementLocator) {
        return this.selenium.isChecked(elementLocator.getAsString());
    }

    public boolean isConfirmationPresent() {
        return this.selenium.isConfirmationPresent();
    }

    public boolean isEditable(ElementLocator<?> elementLocator) {
        return this.selenium.isEditable(elementLocator.getAsString());
    }

    public boolean isElementPresent(ElementLocator<?> elementLocator) {
        return this.selenium.isElementPresent(elementLocator.getAsString());
    }

    public boolean isOrdered(ElementLocator<?> elementLocator1, ElementLocator<?> elementLocator2) {
        return this.selenium.isOrdered(elementLocator1.getAsString(), elementLocator2.getAsString());
    }

    public boolean isPromptPresent() {
        return this.selenium.isPromptPresent();
    }

    public boolean isSomethingSelected(ElementLocator<?> selectLocator) {
        return this.selenium.isSomethingSelected(selectLocator.getAsString());
    }

    public boolean isTextPresent(String text) {
        return this.selenium.isTextPresent(text);
    }

    public boolean isVisible(ElementLocator<?> elementLocator) {
        return this.selenium.isVisible(elementLocator.getAsString());
    }

    public void keyDown(ElementLocator<?> elementLocator, String keySequence) {
        this.selenium.keyDown(elementLocator.getAsString(), keySequence);
    }

    public void keyDownNative(String keycode) {
        this.selenium.keyDownNative(keycode);
    }

    public void keyPress(ElementLocator<?> elementLocator, String keySequence) {
        this.selenium.keyPress(elementLocator.getAsString(), keySequence);
    }

    public void keyPressNative(String keycode) {
        this.selenium.keyPressNative(keycode);
    }

    public void keyUp(ElementLocator<?> elementLocator, String keySequence) {
        this.selenium.keyUp(elementLocator.getAsString(), keySequence);
    }

    public void keyUpNative(String keycode) {
        this.selenium.keyUpNative(keycode);
    }

    public void logToBrowser(String textToLog) {
        this.selenium.setContext(textToLog);
    }

    public void metaKeyDown() {
        this.selenium.metaKeyDown();
    }

    public void metaKeyUp() {
        this.selenium.metaKeyUp();
    }

    public void mouseDown(ElementLocator<?> elementLocator) {
        this.selenium.mouseDown(elementLocator.getAsString());
    }

    public void mouseDownAt(ElementLocator<?> elementLocator, Point point) {
        this.selenium.mouseDownAt(elementLocator.getAsString(), point.getCoords());
    }

    public void mouseDownRight(ElementLocator<?> elementLocator) {
        this.selenium.mouseDownRight(elementLocator.getAsString());
    }

    public void mouseDownRightAt(ElementLocator<?> elementLocator, Point point) {
        this.selenium.mouseDownRightAt(elementLocator.getAsString(), point.getCoords());
    }

    public void mouseMove(ElementLocator<?> elementLocator) {
        this.selenium.mouseMove(elementLocator.getAsString());
    }

    public void mouseMoveAt(ElementLocator<?> elementLocator, Point point) {
        this.selenium.mouseMoveAt(elementLocator.getAsString(), point.getCoords());
    }

    public void mouseOut(ElementLocator<?> elementLocator) {
        this.selenium.mouseOut(elementLocator.getAsString());
    }

    public void mouseOver(ElementLocator<?> elementLocator) {
        this.selenium.mouseOver(elementLocator.getAsString());
    }

    public void mouseUp(ElementLocator<?> elementLocator) {
        this.selenium.mouseUp(elementLocator.getAsString());
    }

    public void mouseUpAt(ElementLocator<?> elementLocator, Point point) {
        this.selenium.mouseUpAt(elementLocator.getAsString(), point.getCoords());
    }

    public void mouseUpRight(ElementLocator<?> elementLocator) {
        this.selenium.mouseUpRight(elementLocator.getAsString());
    }

    public void mouseUpRightAt(ElementLocator<?> elementLocator, Point point) {
        this.selenium.mouseUpRightAt(elementLocator.getAsString(), point.getCoords());
    }

    public void open(URL url) {
        this.selenium.open(url.toString());
    }

    @Override
    public void openWindow(URL url, WindowId windowID) {
        throw new UnsupportedOperationException("not implemented yet");
    }

    public void refresh() {
        this.selenium.refresh();
    }

    public void removeAllSelections(ElementLocator<?> elementLocator) {
        this.selenium.removeAllSelections(elementLocator.getAsString());
    }

    public void removeScript(JavaScript javaScript) {
        this.selenium.removeScript(javaScript.getIdentification());
    }

    public void removeSelection(ElementLocator<?> elementLocator, OptionLocator<?> optionLocator) {
        this.selenium.removeSelection(elementLocator.getAsString(), optionLocator.getAsString());
    }

    public String retrieveLastRemoteControlLogs() {
        return this.selenium.retrieveLastRemoteControlLogs();
    }

    public void runScript(JavaScript script) {
        this.selenium.runScript(script.getAsString());
    }

    public void select(ElementLocator<?> selectLocator, OptionLocator<?> optionLocator) {
        this.selenium.select(selectLocator.getAsString(), optionLocator.getAsString());
    }

    public void selectFrame(FrameLocator frameLocator) {
        this.selenium.selectFrame(frameLocator.getAsString());
    }

    @Override
    public void selectPopUp(WindowId windowID) {
        throw new UnsupportedOperationException("not implemented yet");
    }

    @Override
    public void selectWindow(WindowId windowID) {
        throw new UnsupportedOperationException("not implemented yet");
    }

    public void setBrowserLogLevel(LogLevel logLevel) {
        this.selenium.setBrowserLogLevel(logLevel.getLogLevelName());
    }

    public void setCursorPosition(ElementLocator<?> elementLocator, int position) {
        this.selenium.setCursorPosition(elementLocator.getAsString(), String.valueOf(position));
    }

    @Override
    public void setExtensionJs(JavaScript extensionJs) {
        throw new UnsupportedOperationException("not implemented yet");
    }

    public void setMouseSpeed(int pixels) {
        this.selenium.setMouseSpeed(String.valueOf(pixels));
    }

    public void setSpeed(long speedInMilis) {
        this.selenium.setSpeed(String.valueOf(speedInMilis));
    }

    public void setTimeout(long timeoutInMilis) {
        this.selenium.setTimeout(String.valueOf(timeoutInMilis));
    }

    public void shiftKeyDown() {
        this.selenium.shiftKeyDown();
    }

    public void shiftKeyUp() {
        this.selenium.shiftKeyUp();
    }

    public void shutDownSeleniumServer() {
        this.selenium.shutDownSeleniumServer();
    }

    public void start() {
        this.selenium.start();
    }

    public void stop() {
        this.selenium.stop();
    }

    public void submit(ElementLocator<?> formLocator) {
        this.selenium.submit(formLocator.getAsString());
    }

    public void type(ElementLocator<?> elementLocator, String value) {
        this.selenium.type(elementLocator.getAsString(), value);
    }

    public void typeKeys(ElementLocator<?> elementLocator, String value) {
        this.selenium.type(elementLocator.getAsString(), value);
    }

    public void uncheck(ElementLocator<?> elementLocator) {
        this.selenium.uncheck(elementLocator.getAsString());
    }

    public void useXpathLibrary(XpathLibrary xpathLibrary) {
        this.selenium.useXpathLibrary(xpathLibrary.getXpathLibraryName());
    }

    public void waitForCondition(JavaScript script) {
        String timeout = String.valueOf(this.configuration.getTimeout(AjocadoConfiguration.TimeoutType.DEFAULT));
        this.selenium.waitForCondition(script.getAsString(), timeout);
    }

    public void waitForCondition(JavaScript script, long timeout) {
        this.selenium.waitForCondition(script.getAsString(), String.valueOf(timeout));
    }

    public void waitForFrameToLoad(URL frameURL) {
        String timeout = String.valueOf(this.configuration.getTimeout(AjocadoConfiguration.TimeoutType.DEFAULT));
        this.selenium.waitForFrameToLoad(frameURL.toString(), timeout);
    }

    public void waitForFrameToLoad(URL frameURL, long timeout) {
        this.selenium.waitForFrameToLoad(frameURL.toString(), String.valueOf(timeout));
    }

    public void waitForPageToLoad() {
        String timeout = String.valueOf(this.configuration.getTimeout(AjocadoConfiguration.TimeoutType.DEFAULT));
        this.selenium.waitForPageToLoad(timeout);
    }

    public void waitForPageToLoad(long timeout) {
        this.selenium.waitForPageToLoad(String.valueOf(timeout));
    }

    @Override
    public void waitForPopUp(WindowId windowId, long timeoutInMilis) {
        throw new UnsupportedOperationException("not implemented yet");
    }

    public void windowFocus() {
        this.selenium.windowFocus();
    }

    public void windowMaximize() {
        this.selenium.windowMaximize();
    }

    private BufferedImage decodeBase64Screenshot(String screenshotInBase64) {
        BufferedImage result;
        byte[] screenshotPng = Base64.decodeBase64((String)screenshotInBase64);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(screenshotPng);
        try {
            result = ImageIO.read(inputStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public Set<Cookie> getAllCookies() {
        throw new UnsupportedOperationException("not implemented yet");
    }

    public Cookie getCookieByName(String cookieName) {
        String value = this.selenium.getCookieByName(cookieName);
        return new Cookie(cookieName, value);
    }

    public boolean isCookiePresent(String cookieName) {
        return this.selenium.isCookiePresent(cookieName);
    }

    public void createCookie(Cookie cookie) {
        this.createCookie(cookie, new CreateCookieOptions());
    }

    public void createCookie(Cookie cookie, CreateCookieOptions options) {
        this.selenium.createCookie(cookie.getAsNameValuePair(), options.getAsString());
    }

    public void deleteCookie(String cookieName, DeleteCookieOptions options) {
        this.selenium.deleteCookie(cookieName, options.getAsString());
    }

    public void addCustomRequestHeader(RequestHeader header) {
        this.selenium.addCustomRequestHeader(header.getName(), header.getValue());
    }
}

