/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.ajocado.guard.request;

import org.jboss.arquillian.ajocado.framework.AjaxSelenium;
import org.jboss.arquillian.ajocado.guard.request.RequestTypeGuard;
import org.jboss.arquillian.ajocado.interception.CommandInterceptor;
import org.jboss.arquillian.ajocado.request.RequestType;

public final class RequestTypeGuardFactory {
    private RequestTypeGuardFactory() {
    }

    public static AjaxSelenium guard(AjaxSelenium selenium, RequestType requestExpected) {
        AjaxSelenium copy;
        if (requestExpected == null) {
            return selenium;
        }
        try {
            copy = selenium.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
        copy.getInterceptionProxy().unregisterInterceptorType(RequestTypeGuard.class);
        copy.getInterceptionProxy().registerInterceptor((CommandInterceptor)new RequestTypeGuard(requestExpected, false));
        return copy;
    }

    public static AjaxSelenium guardInterlayed(AjaxSelenium selenium, RequestType requestExpected) {
        AjaxSelenium copy;
        try {
            copy = selenium.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
        copy.getInterceptionProxy().unregisterInterceptorType(RequestTypeGuard.class);
        copy.getInterceptionProxy().registerInterceptor((CommandInterceptor)new RequestTypeGuard(requestExpected, true));
        return copy;
    }

    public static AjaxSelenium guardXhr(AjaxSelenium selenium) {
        return RequestTypeGuardFactory.guard(selenium, RequestType.XHR);
    }

    public static AjaxSelenium guardHttp(AjaxSelenium selenium) {
        return RequestTypeGuardFactory.guard(selenium, RequestType.HTTP);
    }

    public static AjaxSelenium guardNoRequest(AjaxSelenium selenium) {
        return RequestTypeGuardFactory.guard(selenium, RequestType.NONE);
    }

    public static AjaxSelenium waitXhr(AjaxSelenium selenium) {
        return RequestTypeGuardFactory.guardInterlayed(selenium, RequestType.XHR);
    }

    public static AjaxSelenium waitHttp(AjaxSelenium selenium) {
        return RequestTypeGuardFactory.guardInterlayed(selenium, RequestType.HTTP);
    }
}

