/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.ajocado.locator;

import org.apache.commons.lang.Validate;
import org.jboss.arquillian.ajocado.locator.AbstractLocator;
import org.jboss.arquillian.ajocado.locator.Attribute;
import org.jboss.arquillian.ajocado.locator.AttributeLocator;
import org.jboss.arquillian.ajocado.locator.ElementLocationStrategy;
import org.jboss.arquillian.ajocado.locator.ElementLocator;
import org.jboss.arquillian.ajocado.utils.SimplifiedFormat;

public class DefaultAttributeLocator<E extends ElementLocator<E>>
extends AbstractLocator<AttributeLocator<E>>
implements AttributeLocator<E> {
    ElementLocator<E> elementLocator;
    Attribute attribute;

    public DefaultAttributeLocator(ElementLocator<E> elementLocator, Attribute attribute) {
        super("not-used");
        Validate.notNull((Object)attribute);
        this.elementLocator = elementLocator;
        this.attribute = attribute;
    }

    @Override
    public String getRawLocator() {
        return SimplifiedFormat.format((String)"{0}@{1}", (Object[])new Object[]{this.elementLocator.getRawLocator(), this.attribute.getAttributeName()});
    }

    public ElementLocationStrategy getLocationStrategy() {
        return this.elementLocator.getLocationStrategy();
    }

    public ElementLocator<E> getAssociatedElement() {
        return this.elementLocator;
    }

    public Attribute getAttribute() {
        return this.attribute;
    }

    @Override
    public AttributeLocator<E> format(Object ... args) {
        ElementLocator derivedElementLocator = this.elementLocator.format(args);
        return new DefaultAttributeLocator<E>(derivedElementLocator, this.attribute);
    }
}

