/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.ajocado.waiting.ajax;

import com.thoughtworks.selenium.SeleniumException;
import org.apache.commons.lang.StringEscapeUtils;
import org.jboss.arquillian.ajocado.encapsulated.JavaScript;
import org.jboss.arquillian.ajocado.framework.AjaxSelenium;
import org.jboss.arquillian.ajocado.framework.AjaxSeleniumContext;
import org.jboss.arquillian.ajocado.utils.SimplifiedFormat;
import org.jboss.arquillian.ajocado.waiting.DefaultWaiting;
import org.jboss.arquillian.ajocado.waiting.ajax.JavaScriptCondition;
import org.jboss.arquillian.ajocado.waiting.ajax.JavaScriptRetriever;

public class AjaxWaiting
extends DefaultWaiting<AjaxWaiting> {
    private AjaxSelenium selenium = AjaxSeleniumContext.getProxy();

    public void until(JavaScriptCondition condition) {
        this.waitExpectingTimeout(condition.getJavaScriptCondition());
    }

    public <T> void waitForChange(T oldValue, JavaScriptRetriever<T> retriever) {
        JavaScript condition = this.prepareCondition(oldValue, retriever);
        this.waitExpectingTimeout(condition);
    }

    public <T> void waitForChange(JavaScriptRetriever<T> retriever) {
        Object retrieved = this.waitForChangeAndReturn(retriever.getValue(), retriever);
        retriever.setValue(retrieved);
    }

    public <T> T waitForChangeAndReturn(T oldValue, JavaScriptRetriever<T> retriever) {
        JavaScript script = retriever.getJavaScriptRetrieve();
        JavaScript condition = this.prepareCondition(oldValue, retriever);
        this.waitExpectingTimeout(condition);
        String retrieved = this.selenium.getEval(script);
        T converted = retriever.getConvertor().backwardConversion(retrieved);
        return converted;
    }

    public <T> T waitForChangeAndReturn(JavaScriptRetriever<T> retriever) {
        Object retrieved = this.waitForChangeAndReturn(retriever.getValue(), retriever);
        retriever.setValue(retrieved);
        return retrieved;
    }

    private <T> JavaScript prepareCondition(T oldValue, JavaScriptRetriever<T> retriever) {
        String scriptString = retriever.getJavaScriptRetrieve().getAsString();
        String oldValueString = retriever.getConvertor().forwardConversion(oldValue);
        String escapedOldValueString = StringEscapeUtils.escapeJavaScript((String)oldValueString);
        return JavaScript.js((String)SimplifiedFormat.format((String)"{0} != '{1}'", (Object[])new Object[]{scriptString, escapedOldValueString}));
    }

    private void waitExpectingTimeout(JavaScript condition) {
        try {
            this.selenium.waitForCondition(condition, this.getTimeout());
        }
        catch (SeleniumException e) {
            if (this.isTimeoutException(e)) {
                this.fail();
                return;
            }
            throw e;
        }
    }

    private boolean isTimeoutException(SeleniumException e) {
        return e.getMessage().startsWith("Timed out after");
    }
}

