/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.ajocado.waiting.retrievers;

import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.Validate;
import org.jboss.arquillian.ajocado.encapsulated.JavaScript;
import org.jboss.arquillian.ajocado.framework.AjaxSelenium;
import org.jboss.arquillian.ajocado.framework.AjaxSeleniumContext;
import org.jboss.arquillian.ajocado.locator.ElementLocator;
import org.jboss.arquillian.ajocado.utils.SimplifiedFormat;
import org.jboss.arquillian.ajocado.waiting.conversion.Convertor;
import org.jboss.arquillian.ajocado.waiting.conversion.PassOnConvertor;
import org.jboss.arquillian.ajocado.waiting.retrievers.AbstractRetriever;
import org.jboss.arquillian.ajocado.waiting.retrievers.Retriever;

public class TextRetriever
extends AbstractRetriever<String>
implements Retriever<String> {
    private AjaxSelenium selenium = AjaxSeleniumContext.getProxy();
    private ElementLocator<?> elementLocator;

    protected TextRetriever() {
    }

    @Override
    public String retrieve() {
        Validate.notNull(this.elementLocator);
        return this.selenium.getText(this.elementLocator);
    }

    @Override
    public JavaScript getJavaScriptRetrieve() {
        String escapedLocator = StringEscapeUtils.escapeJavaScript((String)this.elementLocator.getAsString());
        return JavaScript.js((String)SimplifiedFormat.format((String)"selenium.getText('{0}')", (Object[])new Object[]{escapedLocator}));
    }

    public static TextRetriever getInstance() {
        return new TextRetriever();
    }

    public TextRetriever locator(ElementLocator<?> elementLocator) {
        Validate.notNull(elementLocator);
        TextRetriever copy = this.copy();
        copy.elementLocator = elementLocator;
        return copy;
    }

    private TextRetriever copy() {
        TextRetriever copy = new TextRetriever();
        copy.elementLocator = this.elementLocator;
        return copy;
    }

    @Override
    public Convertor<String, String> getConvertor() {
        return new PassOnConvertor<String>();
    }
}

