/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.ajocado.framework;

import com.thoughtworks.selenium.Selenium;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.imageio.ImageIO;
import org.apache.commons.codec.binary.Base64;
import org.jboss.arquillian.ajocado.configuration.XPathLibrary;
import org.jboss.arquillian.ajocado.cookie.Cookie;
import org.jboss.arquillian.ajocado.cookie.CookieCreateOptions;
import org.jboss.arquillian.ajocado.cookie.CookieDeleteOptions;
import org.jboss.arquillian.ajocado.cookie.CookieOptions;
import org.jboss.arquillian.ajocado.dom.Attribute;
import org.jboss.arquillian.ajocado.dom.Event;
import org.jboss.arquillian.ajocado.framework.AjocadoConfiguration;
import org.jboss.arquillian.ajocado.framework.AjocadoConfigurationContext;
import org.jboss.arquillian.ajocado.framework.TypedSelenium;
import org.jboss.arquillian.ajocado.framework.internal.UnsupportedTypedSelenium;
import org.jboss.arquillian.ajocado.geometry.Dimension;
import org.jboss.arquillian.ajocado.geometry.Offset;
import org.jboss.arquillian.ajocado.geometry.Point;
import org.jboss.arquillian.ajocado.javascript.JavaScript;
import org.jboss.arquillian.ajocado.javascript.KeyCode;
import org.jboss.arquillian.ajocado.locator.IdLocator;
import org.jboss.arquillian.ajocado.locator.attribute.AttributeLocator;
import org.jboss.arquillian.ajocado.locator.element.ElementLocationStrategy;
import org.jboss.arquillian.ajocado.locator.element.ElementLocator;
import org.jboss.arquillian.ajocado.locator.element.IterableLocator;
import org.jboss.arquillian.ajocado.locator.frame.FrameLocator;
import org.jboss.arquillian.ajocado.locator.option.OptionLocator;
import org.jboss.arquillian.ajocado.locator.window.WindowLocator;
import org.jboss.arquillian.ajocado.locator.window.WindowNameLocator;
import org.jboss.arquillian.ajocado.log.LogLevel;
import org.jboss.arquillian.ajocado.network.NetworkTraffic;
import org.jboss.arquillian.ajocado.network.NetworkTrafficType;
import org.jboss.arquillian.ajocado.request.RequestHeader;
import org.jboss.arquillian.ajocado.utils.array.ArrayTransform;

public class TypedSeleniumImpl
implements TypedSelenium,
UnsupportedTypedSelenium {
    Selenium selenium;
    AjocadoConfiguration configuration = AjocadoConfigurationContext.getProxy();
    private ArrayTransform<String, Integer> transformArrayOfStringToInteger = new ArrayTransform<String, Integer>(Integer.class){

        @Override
        public Integer transformation(String source) {
            return Integer.valueOf(source);
        }
    };

    public void addLocationStrategy(ElementLocationStrategy locationStrategy, JavaScript strategyDefinition) {
        this.selenium.addLocationStrategy(locationStrategy.getStrategyName(), strategyDefinition.toString());
    }

    public void addScript(JavaScript javaScript) {
        this.selenium.addScript(javaScript.getAsString(), javaScript.getIdentification());
    }

    public void addSelection(ElementLocator<?> elementLocator, OptionLocator<?> optionLocator) {
        this.selenium.addSelection(elementLocator.inSeleniumRepresentation(), optionLocator.inSeleniumRepresentation());
    }

    public void allowNativeXpath(boolean allow) {
        this.selenium.allowNativeXpath(String.valueOf(allow));
    }

    public void altKeyDown() {
        this.selenium.altKeyDown();
    }

    public void altKeyUp() {
        this.selenium.altKeyUp();
    }

    public void answerOnNextPrompt(String answer) {
        this.selenium.answerOnNextPrompt(answer);
    }

    public IdLocator assignId(ElementLocator<?> elementLocator, String identifier) {
        this.selenium.assignId(elementLocator.inSeleniumRepresentation(), identifier);
        return new IdLocator(identifier);
    }

    @Override
    public void attachFile(ElementLocator<?> fieldLocator, File fileLocator) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void attachFile(ElementLocator<?> fieldLocator, URL fileLocator) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void captureEntirePageScreenshot(File filename) {
        throw new UnsupportedOperationException();
    }

    public BufferedImage captureEntirePageScreenshot() {
        return this.decodeBase64Screenshot(this.selenium.captureEntirePageScreenshotToString(""));
    }

    public NetworkTraffic captureNetworkTraffic(NetworkTrafficType type) {
        String traffic = this.selenium.captureNetworkTraffic(type.getType());
        return new NetworkTraffic(type, traffic);
    }

    @Override
    public void captureScreenshot(File filename) {
        throw new UnsupportedOperationException();
    }

    public BufferedImage captureScreenshot() {
        return this.decodeBase64Screenshot(this.selenium.captureScreenshotToString());
    }

    public void check(ElementLocator<?> elementLocator) {
        this.selenium.check(elementLocator.inSeleniumRepresentation());
    }

    public void chooseCancelOnNextConfirmation() {
        this.selenium.chooseCancelOnNextConfirmation();
    }

    public void chooseOkOnNextConfirmation() {
        this.selenium.chooseOkOnNextConfirmation();
    }

    public void click(ElementLocator<?> elementLocator) {
        this.selenium.click(elementLocator.inSeleniumRepresentation());
    }

    public void clickAt(ElementLocator<?> elementLocator, Point point) {
        this.selenium.clickAt(elementLocator.inSeleniumRepresentation(), point.inSeleniumRepresentation());
    }

    public void close() {
        this.selenium.close();
    }

    public boolean containsScript(JavaScript javaScript) {
        String identification = javaScript.getIdentification();
        String evaluated = this.selenium.getEval("document.getElementById('" + identification + "') ? true : false");
        return Boolean.valueOf(evaluated);
    }

    public void contextMenu(ElementLocator<?> elementLocator) {
        this.selenium.contextMenu(elementLocator.inSeleniumRepresentation());
    }

    public void contextMenuAt(ElementLocator<?> elementLocator, Point point) {
        this.selenium.contextMenuAt(elementLocator.inSeleniumRepresentation(), point.inSeleniumRepresentation());
    }

    public void controlKeyDown() {
        this.selenium.controlKeyDown();
    }

    public void controlKeyUp() {
        this.selenium.controlKeyUp();
    }

    public void deleteAllVisibleCookies() {
        this.selenium.deleteAllVisibleCookies();
    }

    public void deselectPopUp() {
        this.selenium.deselectPopUp();
    }

    public void doubleClick(ElementLocator<?> elementLocator) {
        this.selenium.doubleClick(elementLocator.inSeleniumRepresentation());
    }

    public void doubleClickAt(ElementLocator<?> elementLocator, Point point) {
        this.selenium.doubleClickAt(elementLocator.inSeleniumRepresentation(), point.inSeleniumRepresentation());
    }

    public void dragAndDrop(ElementLocator<?> elementLocator, Offset offset) {
        this.selenium.dragAndDrop(elementLocator.inSeleniumRepresentation(), offset.inSeleniumRepresentation());
    }

    public void dragAndDropToObject(ElementLocator<?> elementLocatorOfObjectToBeDragged, ElementLocator<?> elementLocatorOfDragDestinationObject) {
        this.selenium.dragAndDropToObject(elementLocatorOfDragDestinationObject.inSeleniumRepresentation(), elementLocatorOfObjectToBeDragged.inSeleniumRepresentation());
    }

    public void fireEvent(ElementLocator<?> elementLocator, Event event) {
        this.selenium.fireEvent(elementLocator.inSeleniumRepresentation(), event.getEventName());
    }

    public void focus(ElementLocator<?> elementLocator) {
        this.selenium.focus(elementLocator.inSeleniumRepresentation());
    }

    public String getAlert() {
        return this.selenium.getAlert();
    }

    @Override
    public List<ElementLocator<?>> getAllButtons() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<ElementLocator<?>> getAllFields() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<ElementLocator<?>> getAllLinks() {
        throw new UnsupportedOperationException();
    }

    public List<WindowNameLocator> getAllWindowIds() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<String> getAllWindowNames() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<String> getAllWindowTitles() {
        throw new UnsupportedOperationException();
    }

    public String getAttribute(AttributeLocator<?> attributeLocator) {
        return this.selenium.getAttribute(attributeLocator.inSeleniumRepresentation());
    }

    public String getAttribute(ElementLocator<?> elementLocator, Attribute attribute) {
        return this.getAttribute(elementLocator.getAttribute(attribute));
    }

    @Override
    public List<String> getAttributeFromAllWindows(Attribute attribute) {
        throw new UnsupportedOperationException();
    }

    public String getBodyText() {
        return this.selenium.getBodyText();
    }

    public String getConfirmation() {
        return this.selenium.getConfirmation();
    }

    public int getCount(IterableLocator<?> locator) {
        if (locator.getLocationStrategy() != ElementLocationStrategy.XPATH) {
            throw new UnsupportedOperationException("Only XPath locators are supported for counting");
        }
        return this.selenium.getXpathCount(locator.getRawLocator()).intValue();
    }

    public int getCursorPosition(ElementLocator<?> elementLocator) {
        return this.selenium.getCursorPosition(elementLocator.inSeleniumRepresentation()).intValue();
    }

    public Dimension getElementDimension(ElementLocator<?> elementLocator) {
        return new Dimension(this.getElementWidth(elementLocator), this.getElementHeight(elementLocator));
    }

    public int getElementHeight(ElementLocator<?> elementLocator) {
        return this.selenium.getElementHeight(elementLocator.inSeleniumRepresentation()).intValue();
    }

    public int getElementIndex(ElementLocator<?> elementLocator) {
        return this.selenium.getElementIndex(elementLocator.inSeleniumRepresentation()).intValue();
    }

    public Point getElementPosition(ElementLocator<?> elementLocator) {
        return new Point(this.getElementPositionLeft(elementLocator), this.getElementPositionTop(elementLocator));
    }

    public int getElementPositionLeft(ElementLocator<?> elementLocator) {
        return this.selenium.getElementPositionLeft(elementLocator.inSeleniumRepresentation()).intValue();
    }

    public int getElementPositionTop(ElementLocator<?> elementLocator) {
        return this.selenium.getElementPositionTop(elementLocator.inSeleniumRepresentation()).intValue();
    }

    public int getElementWidth(ElementLocator<?> elementLocator) {
        return this.selenium.getElementWidth(elementLocator.inSeleniumRepresentation()).intValue();
    }

    public String getEval(JavaScript script) {
        return this.selenium.getEval(script.toString());
    }

    @Override
    public JavaScript getExpression(JavaScript expression) {
        throw new UnsupportedOperationException("not implemented yet");
    }

    public String getHtmlSource() {
        return this.selenium.getHtmlSource();
    }

    public URL getLocation() {
        try {
            return new URL(this.selenium.getLocation());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public int getMouseSpeed() {
        return this.selenium.getMouseSpeed().intValue();
    }

    public String getPrompt() {
        return this.selenium.getPrompt();
    }

    public List<String> getSelectOptions(ElementLocator<?> selectLocator) {
        return Arrays.asList(this.selenium.getSelectOptions(selectLocator.inSeleniumRepresentation()));
    }

    public String getSelectedId(ElementLocator<?> selectLocator) {
        return this.selenium.getSelectedId(selectLocator.inSeleniumRepresentation());
    }

    public List<String> getSelectedIds(ElementLocator<?> selectLocator) {
        return Arrays.asList(this.selenium.getSelectedIds(selectLocator.inSeleniumRepresentation()));
    }

    public int getSelectedIndex(ElementLocator<?> selectLocator) {
        return Integer.valueOf(this.selenium.getSelectedIndex(selectLocator.inSeleniumRepresentation()));
    }

    public List<Integer> getSelectedIndexes(ElementLocator<?> selectLocator) {
        return Arrays.asList(this.transformArrayOfStringToInteger.transform((String[])this.selenium.getSelectedIndexes(selectLocator.inSeleniumRepresentation())));
    }

    public String getSelectedLabel(ElementLocator<?> selectLocator) {
        return this.selenium.getSelectedLabel(selectLocator.inSeleniumRepresentation());
    }

    public List<String> getSelectedLabels(ElementLocator<?> selectLocator) {
        return Arrays.asList(this.selenium.getSelectedLabels(selectLocator.inSeleniumRepresentation()));
    }

    public String getSelectedValue(ElementLocator<?> selectLocator) {
        return this.selenium.getSelectedValue(this.selenium.getSelectedValue(selectLocator.inSeleniumRepresentation()));
    }

    public List<String> getSelectedValues(ElementLocator<?> selectLocator) {
        return Arrays.asList(this.selenium.getSelectedValues(selectLocator.inSeleniumRepresentation()));
    }

    public long getSpeed() {
        return Long.valueOf(this.selenium.getSpeed());
    }

    public String getText(ElementLocator<?> elementLocator) {
        return this.selenium.getText(elementLocator.inSeleniumRepresentation());
    }

    public String getTitle() {
        return this.selenium.getTitle();
    }

    public String getValue(ElementLocator<?> elementLocator) {
        return this.selenium.getValue(elementLocator.inSeleniumRepresentation());
    }

    @Override
    public boolean getWhetherThisFrameMatchFrameExpression(String currentFrameString, String target) {
        return this.selenium.getWhetherThisFrameMatchFrameExpression(currentFrameString, target);
    }

    @Override
    public boolean getWhetherThisWindowMatchWindowExpression(String currentWindowString, String target) {
        return this.selenium.getWhetherThisWindowMatchWindowExpression(currentWindowString, target);
    }

    public void goBack() {
        this.selenium.goBack();
    }

    public void highlight(ElementLocator<?> elementLocator) {
        this.selenium.highlight(elementLocator.inSeleniumRepresentation());
    }

    public void ignoreAttributesWithoutValue(boolean ignore) {
        this.selenium.ignoreAttributesWithoutValue(String.valueOf(ignore));
    }

    public boolean isAlertPresent() {
        return this.selenium.isAlertPresent();
    }

    public boolean isChecked(ElementLocator<?> elementLocator) {
        return this.selenium.isChecked(elementLocator.inSeleniumRepresentation());
    }

    public boolean isConfirmationPresent() {
        return this.selenium.isConfirmationPresent();
    }

    public boolean isEditable(ElementLocator<?> elementLocator) {
        return this.selenium.isEditable(elementLocator.inSeleniumRepresentation());
    }

    public boolean isElementPresent(ElementLocator<?> elementLocator) {
        return this.selenium.isElementPresent(elementLocator.inSeleniumRepresentation());
    }

    public boolean isOrdered(ElementLocator<?> elementLocator1, ElementLocator<?> elementLocator2) {
        return this.selenium.isOrdered(elementLocator1.inSeleniumRepresentation(), elementLocator2.inSeleniumRepresentation());
    }

    public boolean isPromptPresent() {
        return this.selenium.isPromptPresent();
    }

    public boolean isSomethingSelected(ElementLocator<?> selectLocator) {
        return this.selenium.isSomethingSelected(selectLocator.inSeleniumRepresentation());
    }

    public boolean isTextPresent(String text) {
        return this.selenium.isTextPresent(text);
    }

    public boolean isVisible(ElementLocator<?> elementLocator) {
        return this.selenium.isVisible(elementLocator.inSeleniumRepresentation());
    }

    public void keyDown(ElementLocator<?> elementLocator, char character) {
        this.selenium.keyPress(elementLocator.inSeleniumRepresentation(), String.valueOf(character));
    }

    public void keyDown(ElementLocator<?> elementLocator, KeyCode keyCode) {
        this.selenium.keyPress(elementLocator.inSeleniumRepresentation(), keyCode.inSeleniumRepresentation());
    }

    public void keyDownNative(int keycode) {
        this.selenium.keyDownNative(TypedSeleniumImpl.keyEventToNativeCode(keycode));
    }

    public void keyPress(ElementLocator<?> elementLocator, char character) {
        this.selenium.keyPress(elementLocator.inSeleniumRepresentation(), String.valueOf(character));
    }

    public void keyPress(ElementLocator<?> elementLocator, KeyCode keyCode) {
        this.selenium.keyPress(elementLocator.inSeleniumRepresentation(), keyCode.inSeleniumRepresentation());
    }

    public void keyPressNative(int keycode) {
        this.selenium.keyPressNative(TypedSeleniumImpl.keyEventToNativeCode(keycode));
    }

    public void keyUp(ElementLocator<?> elementLocator, char character) {
        this.selenium.keyPress(elementLocator.inSeleniumRepresentation(), String.valueOf(character));
    }

    public void keyUp(ElementLocator<?> elementLocator, KeyCode keyCode) {
        this.selenium.keyPress(elementLocator.inSeleniumRepresentation(), keyCode.inSeleniumRepresentation());
    }

    public void keyUpNative(int keycode) {
        this.selenium.keyUpNative(TypedSeleniumImpl.keyEventToNativeCode(keycode));
    }

    public void logToBrowser(String textToLog) {
        this.selenium.setContext(textToLog);
    }

    public void metaKeyDown() {
        this.selenium.metaKeyDown();
    }

    public void metaKeyUp() {
        this.selenium.metaKeyUp();
    }

    public void mouseDown(ElementLocator<?> elementLocator) {
        this.selenium.mouseDown(elementLocator.inSeleniumRepresentation());
    }

    public void mouseDownAt(ElementLocator<?> elementLocator, Point point) {
        this.selenium.mouseDownAt(elementLocator.inSeleniumRepresentation(), point.inSeleniumRepresentation());
    }

    public void mouseDownRight(ElementLocator<?> elementLocator) {
        this.selenium.mouseDownRight(elementLocator.inSeleniumRepresentation());
    }

    public void mouseDownRightAt(ElementLocator<?> elementLocator, Point point) {
        this.selenium.mouseDownRightAt(elementLocator.inSeleniumRepresentation(), point.inSeleniumRepresentation());
    }

    public void mouseMove(ElementLocator<?> elementLocator) {
        this.selenium.mouseMove(elementLocator.inSeleniumRepresentation());
    }

    public void mouseMoveAt(ElementLocator<?> elementLocator, Point point) {
        this.selenium.mouseMoveAt(elementLocator.inSeleniumRepresentation(), point.inSeleniumRepresentation());
    }

    public void mouseOut(ElementLocator<?> elementLocator) {
        this.selenium.mouseOut(elementLocator.inSeleniumRepresentation());
    }

    public void mouseOver(ElementLocator<?> elementLocator) {
        this.selenium.mouseOver(elementLocator.inSeleniumRepresentation());
    }

    public void mouseUp(ElementLocator<?> elementLocator) {
        this.selenium.mouseUp(elementLocator.inSeleniumRepresentation());
    }

    public void mouseUpAt(ElementLocator<?> elementLocator, Point point) {
        this.selenium.mouseUpAt(elementLocator.inSeleniumRepresentation(), point.inSeleniumRepresentation());
    }

    public void mouseUpRight(ElementLocator<?> elementLocator) {
        this.selenium.mouseUpRight(elementLocator.inSeleniumRepresentation());
    }

    public void mouseUpRightAt(ElementLocator<?> elementLocator, Point point) {
        this.selenium.mouseUpRightAt(elementLocator.inSeleniumRepresentation(), point.inSeleniumRepresentation());
    }

    public void open(URL url) {
        this.selenium.open(url.toString());
    }

    public void openWindow(URL url, WindowNameLocator windowName) {
        this.selenium.openWindow(url.toString(), windowName.getRawLocator());
    }

    public void refresh() {
        this.selenium.refresh();
    }

    public void removeAllSelections(ElementLocator<?> elementLocator) {
        this.selenium.removeAllSelections(elementLocator.inSeleniumRepresentation());
    }

    public void removeScript(JavaScript javaScript) {
        this.selenium.removeScript(javaScript.getIdentification());
    }

    public void removeSelection(ElementLocator<?> elementLocator, OptionLocator<?> optionLocator) {
        this.selenium.removeSelection(elementLocator.inSeleniumRepresentation(), optionLocator.inSeleniumRepresentation());
    }

    public String retrieveLastRemoteControlLogs() {
        return this.selenium.retrieveLastRemoteControlLogs();
    }

    public void runScript(JavaScript script) {
        this.selenium.runScript(script.getAsString());
    }

    public void select(ElementLocator<?> selectLocator, OptionLocator<?> optionLocator) {
        this.selenium.select(selectLocator.inSeleniumRepresentation(), optionLocator.inSeleniumRepresentation());
    }

    public void selectFrame(FrameLocator<?> frameLocator) {
        this.selenium.selectFrame(frameLocator.inSeleniumRepresentation());
    }

    public void selectPopUp(WindowLocator<?> windowLocator) {
        this.selenium.selectPopUp(windowLocator.getRawLocator());
    }

    public void selectWindow(WindowLocator<?> windowLocator) {
        this.selenium.selectWindow(windowLocator.inSeleniumRepresentation());
    }

    public void setBrowserLogLevel(LogLevel logLevel) {
        this.selenium.setBrowserLogLevel(logLevel.getLogLevelName());
    }

    public void setCursorPosition(ElementLocator<?> elementLocator, int position) {
        this.selenium.setCursorPosition(elementLocator.inSeleniumRepresentation(), String.valueOf(position));
    }

    @Override
    public void setExtensionJs(JavaScript extensionJs) {
        throw new UnsupportedOperationException("not implemented yet");
    }

    public void setMouseSpeed(int pixels) {
        this.selenium.setMouseSpeed(String.valueOf(pixels));
    }

    public void setSpeed(long speedInMilis) {
        this.selenium.setSpeed(String.valueOf(speedInMilis));
    }

    public void setTimeout(long timeoutInMilis) {
        this.selenium.setTimeout(String.valueOf(timeoutInMilis));
    }

    public void shiftKeyDown() {
        this.selenium.shiftKeyDown();
    }

    public void shiftKeyUp() {
        this.selenium.shiftKeyUp();
    }

    public void shutDownSeleniumServer() {
        this.selenium.shutDownSeleniumServer();
    }

    public void start() {
        this.selenium.start();
    }

    public void stop() {
        this.selenium.stop();
    }

    public void submit(ElementLocator<?> formLocator) {
        this.selenium.submit(formLocator.inSeleniumRepresentation());
    }

    public void type(ElementLocator<?> elementLocator, String value) {
        this.selenium.type(elementLocator.inSeleniumRepresentation(), value);
    }

    public void typeKeys(ElementLocator<?> elementLocator, String value) {
        this.selenium.type(elementLocator.inSeleniumRepresentation(), value);
    }

    public void uncheck(ElementLocator<?> elementLocator) {
        this.selenium.uncheck(elementLocator.inSeleniumRepresentation());
    }

    public void useXpathLibrary(XPathLibrary xPathLibrary) {
        this.selenium.useXpathLibrary(xPathLibrary.inSeleniumRepresentation());
    }

    public void waitForCondition(JavaScript script) {
        String timeout = String.valueOf(this.configuration.getTimeout(AjocadoConfiguration.TimeoutType.DEFAULT));
        this.selenium.waitForCondition(script.getAsString(), timeout);
    }

    public void waitForCondition(JavaScript script, long timeout) {
        this.selenium.waitForCondition(script.getAsString(), String.valueOf(timeout));
    }

    public void waitForFrameToLoad(URL frameURL) {
        String timeout = String.valueOf(this.configuration.getTimeout(AjocadoConfiguration.TimeoutType.DEFAULT));
        this.selenium.waitForFrameToLoad(frameURL.toString(), timeout);
    }

    public void waitForFrameToLoad(URL frameURL, long timeout) {
        this.selenium.waitForFrameToLoad(frameURL.toString(), String.valueOf(timeout));
    }

    public void waitForPageToLoad() {
        String timeout = String.valueOf(this.configuration.getTimeout(AjocadoConfiguration.TimeoutType.DEFAULT));
        this.selenium.waitForPageToLoad(timeout);
    }

    public void waitForPageToLoad(long timeout) {
        this.selenium.waitForPageToLoad(String.valueOf(timeout));
    }

    public void waitForPopUp(WindowNameLocator windowNameLocator, long timeoutInMilis) {
        this.selenium.waitForPopUp(windowNameLocator.getRawLocator(), Long.toString(timeoutInMilis));
    }

    public void windowFocus() {
        this.selenium.windowFocus();
    }

    public void windowMaximize() {
        this.selenium.windowMaximize();
    }

    private BufferedImage decodeBase64Screenshot(String screenshotInBase64) {
        BufferedImage result;
        byte[] screenshotPng = Base64.decodeBase64((String)screenshotInBase64);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(screenshotPng);
        try {
            result = ImageIO.read(inputStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public Set<Cookie> getAllCookies() {
        throw new UnsupportedOperationException("not implemented yet");
    }

    public Cookie getCookieByName(String cookieName) {
        String value = this.selenium.getCookieByName(cookieName);
        return Cookie.createCookie((String)cookieName, (String)value);
    }

    public boolean isCookiePresent(String cookieName) {
        return this.selenium.isCookiePresent(cookieName);
    }

    public CookieCreateOptions createCookie(Cookie cookie) {
        CookieCreateOptions options = CookieOptions.forCreation();
        this.createCookie(cookie, options);
        return options;
    }

    public void createCookie(Cookie cookie, CookieCreateOptions options) {
        this.selenium.createCookie(cookie.inSeleniumRepresentation(), options.inSeleniumRepresentation());
    }

    public void deleteCookie(String cookieName, CookieDeleteOptions options) {
        this.selenium.deleteCookie(cookieName, options.inSeleniumRepresentation());
    }

    public void addCustomRequestHeader(RequestHeader header) {
        this.selenium.addCustomRequestHeader(header.getName(), header.getValue());
    }

    private static String keyEventToNativeCode(int event) {
        return Integer.toString(event);
    }
}

