/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.ajocado.waiting.conditions;

import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.Validate;
import org.jboss.arquillian.ajocado.framework.AjaxSelenium;
import org.jboss.arquillian.ajocado.framework.AjaxSeleniumContext;
import org.jboss.arquillian.ajocado.javascript.JavaScript;
import org.jboss.arquillian.ajocado.locator.element.ElementLocator;
import org.jboss.arquillian.ajocado.waiting.ajax.JavaScriptCondition;
import org.jboss.arquillian.ajocado.waiting.selenium.SeleniumCondition;

public class ElementNotPresent
implements SeleniumCondition,
JavaScriptCondition {
    private AjaxSelenium selenium = AjaxSeleniumContext.getProxy();
    private ElementLocator<?> elementLocator;

    protected ElementNotPresent() {
    }

    @Override
    public boolean isTrue() {
        Validate.notNull(this.elementLocator);
        return !this.selenium.isElementPresent(this.elementLocator);
    }

    @Override
    public JavaScript getJavaScriptCondition() {
        String escapedLocator = StringEscapeUtils.escapeJavaScript((String)this.elementLocator.inSeleniumRepresentation());
        return JavaScript.js((String)"!selenium.isElementPresent('{0}')").parametrize(new Object[]{escapedLocator});
    }

    public static ElementNotPresent getInstance() {
        return new ElementNotPresent();
    }

    public ElementNotPresent locator(ElementLocator<?> elementLocator) {
        Validate.notNull(elementLocator);
        ElementNotPresent copy = this.copy();
        copy.elementLocator = elementLocator;
        return copy;
    }

    private ElementNotPresent copy() {
        ElementNotPresent copy = new ElementNotPresent();
        copy.elementLocator = this.elementLocator;
        return copy;
    }
}

