/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.spi.util;

import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.jboss.arquillian.spi.util.TCCLActions;

public final class SecurityActions {
    private SecurityActions() {
        throw new UnsupportedOperationException("No instantiation");
    }

    public static <T> Constructor<? extends T> getConstructor(final Class<T> clazz, final Class<?> ... argumentTypes) throws NoSuchMethodException {
        try {
            return (Constructor)AccessController.doPrivileged(new PrivilegedExceptionAction<Constructor<? extends T>>(){

                @Override
                public Constructor<? extends T> run() throws NoSuchMethodException {
                    return clazz.getConstructor(argumentTypes);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Throwable t = pae.getCause();
            if (t instanceof NoSuchMethodException) {
                throw (NoSuchMethodException)t;
            }
            try {
                throw (RuntimeException)t;
            }
            catch (ClassCastException cce) {
                throw new RuntimeException("Obtained unchecked Exception; this code should never be reached", t);
            }
        }
    }

    public static <T> T newInstance(String className, Class<?>[] argumentTypes, Object[] arguments, Class<T> expectedType) {
        Object obj;
        if (className == null) {
            throw new IllegalArgumentException("ClassName must be specified");
        }
        if (argumentTypes == null) {
            throw new IllegalArgumentException("ArgumentTypes must be specified. Use empty array if no arguments");
        }
        if (arguments == null) {
            throw new IllegalArgumentException("Arguments must be specified. Use empty array if no arguments");
        }
        try {
            ClassLoader tccl = TCCLActions.getClassLoader();
            Class<?> implClass = Class.forName(className, false, tccl);
            Constructor<?> constructor = SecurityActions.getConstructor(implClass, argumentTypes);
            obj = constructor.newInstance(arguments);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create new instance of " + className + ", missing package from classpath?", e);
        }
        try {
            return expectedType.cast(obj);
        }
        catch (ClassCastException cce) {
            throw new ClassCastException("Incorrect expected type, " + expectedType.getName() + ", defined for " + obj.getClass().getName());
        }
    }
}

