/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.spi;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jboss.arquillian.spi.ContainerConfiguration;
import org.jboss.arquillian.spi.ExtensionConfiguration;

public class Configuration {
    private Map<Class<? extends ContainerConfiguration>, ContainerConfiguration> containersConfig = new HashMap<Class<? extends ContainerConfiguration>, ContainerConfiguration>();
    private Map<Class<? extends ExtensionConfiguration>, ExtensionConfiguration> extensionsConfig = new HashMap<Class<? extends ExtensionConfiguration>, ExtensionConfiguration>();
    private String deploymentExportPath = null;
    private int maxDeploymentsBeforeRestart = -1;

    public void addContainerConfig(ContainerConfiguration containerConfig) {
        this.containersConfig.put(containerConfig.getClass(), containerConfig);
    }

    public void addExtensionConfig(ExtensionConfiguration extensionConfig) {
        this.extensionsConfig.put(extensionConfig.getClass(), extensionConfig);
    }

    public <T extends ContainerConfiguration> T getContainerConfig(Class<T> clazz) {
        return (T)((ContainerConfiguration)clazz.cast(this.containersConfig.get(clazz)));
    }

    public <T extends ExtensionConfiguration> T getExtensionConfig(Class<T> clazz) {
        return (T)((ExtensionConfiguration)clazz.cast(this.extensionsConfig.get(clazz)));
    }

    public ContainerConfiguration getActiveContainerConfiguration() {
        Iterator<Map.Entry<Class<? extends ContainerConfiguration>, ContainerConfiguration>> itr = this.containersConfig.entrySet().iterator();
        if (itr.hasNext()) {
            return itr.next().getValue();
        }
        return null;
    }

    public void setDeploymentExportPath(String deploymentExportPath) {
        this.deploymentExportPath = deploymentExportPath;
    }

    public String getDeploymentExportPath() {
        return this.deploymentExportPath;
    }

    public int getMaxDeploymentsBeforeRestart() {
        return this.maxDeploymentsBeforeRestart;
    }

    public void setMaxDeploymentsBeforeRestart(int maxDeploymentsBeforeRestart) {
        this.maxDeploymentsBeforeRestart = maxDeploymentsBeforeRestart;
    }
}

