/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.appscale.remote;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.arquillian.container.appscale.remote.AppScaleRemoteConfiguration;
import org.jboss.arquillian.container.common.AppEngineCommonContainer;
import org.jboss.arquillian.container.spi.client.container.DeploymentException;
import org.jboss.arquillian.container.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.GenericArchive;
import org.jboss.shrinkwrap.api.ShrinkWrap;

public class AppScaleRemoteContainer
extends AppEngineCommonContainer<AppScaleRemoteConfiguration> {
    protected final Logger log = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    protected static final Pattern hostPortPattern = Pattern.compile("(http://[0-9\\.\\:]+)");
    private AppScaleRemoteConfiguration configuration;
    private DeploymentInfo deploymentInfo;

    public Class<AppScaleRemoteConfiguration> getConfigurationClass() {
        return AppScaleRemoteConfiguration.class;
    }

    public void setup(AppScaleRemoteConfiguration configuration) {
        this.configuration = configuration;
    }

    protected File export(Archive<?> archive) throws Exception {
        Archive appscaleArchive = (Archive)ShrinkWrap.create(GenericArchive.class);
        appscaleArchive.merge(archive, "war");
        return super.export(appscaleArchive);
    }

    protected ProtocolMetaData doDeploy(Archive<?> archive) throws DeploymentException {
        ArrayList<String> uploadDeploymentCmd = new ArrayList<String>();
        uploadDeploymentCmd.add("scp");
        uploadDeploymentCmd.add("-r");
        uploadDeploymentCmd.add(this.getAppLocation().getAbsolutePath());
        uploadDeploymentCmd.add("root@" + this.configuration.getHost() + ":/root/");
        List<String> deployCmd = this.ssh("/usr/local/appscale-tools/bin/appscale-upload-app --email " + this.configuration.getEmail() + " --file /root/" + this.getAppLocation().getName());
        ArrayList<String> responses = new ArrayList<String>();
        try {
            this.runCmd(uploadDeploymentCmd, "upload", "./", null, this.configuration.getUploadTimeout());
            this.runCmd(deployCmd, "deploy", "./", responses, this.configuration.getDeployTimeout());
        }
        catch (InterruptedException e) {
            throw new DeploymentException("Cannot deploy to AppScale.", (Throwable)e);
        }
        this.deploymentInfo = this.parseUrlFromResponse(responses);
        if (!this.deploymentInfo.isValid()) {
            throw new DeploymentException("Could not deploy, invalid reponse: " + this.deploymentInfo);
        }
        return AppScaleRemoteContainer.getProtocolMetaData((String)this.deploymentInfo.host, (int)this.deploymentInfo.port, archive);
    }

    protected void teardown() throws DeploymentException {
        List<String> undeployCmd = this.ssh("/usr/local/appscale-tools/bin/appscale-remove-app --confirm --appname " + this.deploymentInfo.appName);
        List<String> removeDeploymentArchive = this.ssh("rm -rf /root/" + this.getAppLocation().getName());
        try {
            this.runCmd(undeployCmd, "undeploy", "./", null, this.configuration.getUndeployTimeout());
            this.runCmd(removeDeploymentArchive, "remove", "./", null, this.configuration.getRemoveTimeout());
        }
        catch (InterruptedException e) {
            throw new DeploymentException("Cannot undeploy from AppScale.", (Throwable)e);
        }
    }

    protected List<String> ssh(String last) {
        return Arrays.asList("ssh", "root@" + this.configuration.getHost(), last);
    }

    void runCmd(List<String> command, String processName, String workingDirectory, List<String> responses, long timeout) throws InterruptedException {
        Process process;
        this.log.log(Level.FINE, String.format("Process name='%s' command='%s' workingDirectory='%s'", processName, command, workingDirectory));
        ProcessBuilder builder = new ProcessBuilder(command);
        builder.directory(new File(workingDirectory));
        try {
            process = builder.start();
        }
        catch (IOException e) {
            this.log.log(Level.SEVERE, "Cannot run command: " + command, e);
            return;
        }
        InputStream stderr = process.getErrorStream();
        InputStream stdout = process.getInputStream();
        Thread stderrThread = new Thread(new ReadTask(stderr, System.err, processName, null));
        stderrThread.setName(String.format("stderr for %s", processName));
        stderrThread.start();
        Thread stdoutThread = new Thread(new ReadTask(stdout, System.out, processName, responses));
        stdoutThread.setName(String.format("stdout for %s", processName));
        stdoutThread.start();
        stdoutThread.join(timeout);
        stderrThread.join(timeout);
    }

    DeploymentInfo parseUrlFromResponse(List<String> responses) {
        DeploymentInfo deploymentInfo = new DeploymentInfo();
        for (String response : responses) {
            Matcher hostPortMatcher = hostPortPattern.matcher(response);
            if (hostPortMatcher.find()) {
                String url = hostPortMatcher.group();
                URI uri = URI.create(url);
                deploymentInfo.host = uri.getHost();
                deploymentInfo.port = uri.getPort();
            }
            if (!response.startsWith("Uploading")) continue;
            deploymentInfo.appName = response.split("app ")[1];
        }
        return deploymentInfo;
    }

    static class DeploymentInfo {
        String appName;
        String host;
        Integer port;

        DeploymentInfo() {
        }

        public String toString() {
            return this.host + ":" + this.port + " - " + this.appName;
        }

        public boolean isValid() {
            return this.appName != null && !this.appName.equals("") && this.host != null && this.port != null && this.port != 0;
        }
    }

    private final class ReadTask
    implements Runnable {
        private final InputStream source;
        private final PrintStream target;
        private final String processName;
        private final List<String> response;

        private ReadTask(InputStream source, PrintStream target, String processName, List<String> response) {
            this.source = source;
            this.target = target;
            this.processName = processName;
            this.response = response;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            InputStream source = this.source;
            try {
                String s;
                BufferedReader reader = new BufferedReader(new InputStreamReader(new BufferedInputStream(source)));
                OutputStreamWriter writer = new OutputStreamWriter(this.target);
                while ((s = reader.readLine()) != null) {
                    PrintStream printStream = this.target;
                    synchronized (printStream) {
                        if (this.response != null) {
                            this.response.add(s);
                        }
                        writer.write(91);
                        writer.write(this.processName);
                        writer.write("] ");
                        writer.write(s);
                        writer.write(10);
                        writer.flush();
                    }
                }
                source.close();
            }
            catch (IOException e) {
                AppScaleRemoteContainer.this.log.log(Level.SEVERE, "Cannot start read task.", e);
            }
            finally {
                AppScaleRemoteContainer.safeClose((Closeable)source);
            }
        }
    }
}

