/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.osgi.felix;

import java.util.HashMap;
import java.util.Map;
import org.apache.felix.framework.Logger;
import org.apache.felix.main.AutoProcessor;
import org.jboss.arquillian.container.osgi.EmbeddedDeployableContainer;
import org.jboss.arquillian.container.osgi.OSGiContainerConfiguration;
import org.jboss.arquillian.container.osgi.felix.FelixLogger;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.launch.Framework;
import org.osgi.framework.launch.FrameworkFactory;

public class FelixEmbeddedDeployableContainer
extends EmbeddedDeployableContainer<OSGiContainerConfiguration> {
    private final Logger logger = new FelixLogger();

    public Class<OSGiContainerConfiguration> getConfigurationClass() {
        return OSGiContainerConfiguration.class;
    }

    protected Framework createFramework(OSGiContainerConfiguration conf) {
        HashMap<String, Logger> config = new HashMap<String, Logger>(conf.getFrameworkConfiguration());
        if (config.get("felix.log.logger") == null) {
            config.put("felix.log.logger", this.logger);
        }
        FrameworkFactory factory = conf.getFrameworkFactory();
        return factory.newFramework(config);
    }

    protected BundleContext startFramework() throws BundleException {
        BundleContext bundleContext = super.startFramework();
        Map config = this.getContainerConfiguration().getFrameworkConfiguration();
        AutoProcessor.process((Map)config, (BundleContext)bundleContext);
        return bundleContext;
    }

    protected EmbeddedDeployableContainer.ContainerLogger getLogger() {
        return new EmbeddedDeployableContainer.AbstractContainerLogger(){

            public void log(EmbeddedDeployableContainer.ContainerLogger.Level level, String message, Throwable th) {
                switch (level) {
                    case DEBUG: {
                        FelixEmbeddedDeployableContainer.this.logger.log(4, message, th);
                        break;
                    }
                    case INFO: {
                        FelixEmbeddedDeployableContainer.this.logger.log(3, message, th);
                        break;
                    }
                    case WARN: {
                        FelixEmbeddedDeployableContainer.this.logger.log(2, message, th);
                        break;
                    }
                    case ERROR: {
                        FelixEmbeddedDeployableContainer.this.logger.log(1, message, th);
                    }
                }
            }
        };
    }
}

