/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.impl;

import org.jboss.arquillian.config.descriptor.api.ContainerDef;
import org.jboss.arquillian.config.descriptor.api.ProtocolDef;
import org.jboss.arquillian.container.impl.DefaultServerKillProcessor;
import org.jboss.arquillian.container.impl.MapObject;
import org.jboss.arquillian.container.spi.Container;
import org.jboss.arquillian.container.spi.ServerKillProcessor;
import org.jboss.arquillian.container.spi.client.container.ContainerConfiguration;
import org.jboss.arquillian.container.spi.client.container.DeployableContainer;
import org.jboss.arquillian.container.spi.client.container.LifecycleException;
import org.jboss.arquillian.container.spi.client.protocol.ProtocolDescription;
import org.jboss.arquillian.container.spi.context.annotation.ContainerScoped;
import org.jboss.arquillian.container.spi.event.container.AfterKill;
import org.jboss.arquillian.container.spi.event.container.AfterSetup;
import org.jboss.arquillian.container.spi.event.container.AfterStart;
import org.jboss.arquillian.container.spi.event.container.AfterStop;
import org.jboss.arquillian.container.spi.event.container.BeforeKill;
import org.jboss.arquillian.container.spi.event.container.BeforeSetup;
import org.jboss.arquillian.container.spi.event.container.BeforeStart;
import org.jboss.arquillian.container.spi.event.container.BeforeStop;
import org.jboss.arquillian.container.spi.event.container.ContainerEvent;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.spi.ServiceLoader;
import org.jboss.arquillian.core.spi.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContainerImpl
implements Container {
    @Inject
    private Event<ContainerEvent> event;
    @Inject
    @ContainerScoped
    private InstanceProducer<Container> containerProducer;
    @Inject
    private Instance<ServiceLoader> serviceLoader;
    private DeployableContainer<?> deployableContainer;
    private String name;
    private Container.State state = Container.State.STOPPED;
    private Throwable failureCause;
    private ContainerDef containerConfiguration;

    public ContainerImpl(String name, DeployableContainer<?> deployableContainer, ContainerDef containerConfiguration) {
        Validate.notNull((Object)name, (String)"Name must be specified");
        Validate.notNull(deployableContainer, (String)"DeployableContainer must be specified");
        Validate.notNull((Object)containerConfiguration, (String)"ConfigurationConfiguration must be specified");
        this.name = name;
        this.deployableContainer = deployableContainer;
        this.containerConfiguration = containerConfiguration;
    }

    public String getName() {
        return this.name;
    }

    public DeployableContainer<?> getDeployableContainer() {
        return this.deployableContainer;
    }

    public ContainerDef getContainerConfiguration() {
        return this.containerConfiguration;
    }

    public ContainerConfiguration createDeployableConfiguration() throws Exception {
        ContainerConfiguration config = (ContainerConfiguration)this.deployableContainer.getConfigurationClass().newInstance();
        MapObject.populate(config, this.containerConfiguration.getContainerProperties());
        config.validate();
        return config;
    }

    public boolean hasProtocolConfiguration(ProtocolDescription description) {
        for (ProtocolDef protocol : this.containerConfiguration.getProtocols()) {
            if (!description.getName().equals(protocol.getType())) continue;
            return true;
        }
        return false;
    }

    public ProtocolDef getProtocolConfiguration(ProtocolDescription description) {
        for (ProtocolDef protocol : this.containerConfiguration.getProtocols()) {
            if (!description.getName().equals(protocol.getType())) continue;
            return protocol;
        }
        return null;
    }

    public Container.State getState() {
        return this.state;
    }

    public void setState(Container.State state) {
        this.state = state;
    }

    public Throwable getFailureCause() {
        return this.failureCause;
    }

    public void setup() throws Exception {
        this.event.fire((Object)new BeforeSetup(this.deployableContainer));
        try {
            this.containerProducer.set((Object)this);
            this.deployableContainer.setup(this.createDeployableConfiguration());
            this.setState(Container.State.SETUP);
        }
        catch (Exception e) {
            this.setState(Container.State.SETUP_FAILED);
            this.failureCause = e;
            throw e;
        }
        this.event.fire((Object)new AfterSetup(this.deployableContainer));
    }

    public void start() throws LifecycleException {
        this.event.fire((Object)new BeforeStart(this.deployableContainer));
        try {
            this.deployableContainer.start();
            this.setState(Container.State.STARTED);
        }
        catch (LifecycleException e) {
            this.setState(Container.State.STARTED_FAILED);
            this.failureCause = e;
            throw e;
        }
        this.event.fire((Object)new AfterStart(this.deployableContainer));
    }

    public void stop() throws LifecycleException {
        this.event.fire((Object)new BeforeStop(this.deployableContainer));
        try {
            this.deployableContainer.stop();
            this.setState(Container.State.STOPPED);
        }
        catch (LifecycleException e) {
            this.setState(Container.State.STOPPED_FAILED);
            this.failureCause = e;
            throw e;
        }
        this.event.fire((Object)new AfterStop(this.deployableContainer));
    }

    public void kill() throws Exception {
        this.event.fire((Object)new BeforeKill(this.deployableContainer));
        try {
            this.getServerKillProcessor().kill((Container)this);
            this.setState(Container.State.KILLED);
        }
        catch (Exception e) {
            this.setState(Container.State.KILLED_FAILED);
            this.failureCause = e;
            throw e;
        }
        this.event.fire((Object)new AfterKill(this.deployableContainer));
    }

    private ServerKillProcessor getServerKillProcessor() {
        ServiceLoader loader = (ServiceLoader)this.serviceLoader.get();
        if (loader == null) {
            throw new IllegalStateException("No " + ServiceLoader.class.getName() + " found in context");
        }
        ServerKillProcessor serverKillProcessor = (ServerKillProcessor)((ServiceLoader)this.serviceLoader.get()).onlyOne(ServerKillProcessor.class, DefaultServerKillProcessor.class);
        if (serverKillProcessor == null) {
            throw new IllegalStateException("No " + ServerKillProcessor.class.getName() + " found in context");
        }
        return serverKillProcessor;
    }
}

